/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>
#include <soc/memlayout.h>

/*
 * The linker script below configures the memory layout for the Qualcomm X1P42100 SoC.
 *
 * The memory map and addressing scheme are implemented according to the official Qualcomm
 * Hardware Reference Document (HRD) for this specific SoC.
 *
 * 0x10000000000 +----------------------------------------------------------+ <--------------
 *               |                      dram_space_2                        | DRAM Space 2  ^
 * 0x8800000000  +----------------------------------------------------------+ <---------    |
 *               |         ... (Memory not mapped: Unavailable) ...         |  XXXXXXXXX    |
 * 0x1000000000  +----------------------------------------------------------+ <---------    |
 *               |                      dram_space_1                        | DRAM Space 1  |
 * 0x880000000   +----------------------------------------------------------+ <---------    |
 *               |         ... (Memory not mapped: Unavailable) ...         |  XXXXXXXXX    |
 * 0x100000000   +----------------------------------------------------------+ <---------    |
 *               |                 dram_smem (Shared Memory)                |      ^        |
 * 0xFFE00000    +----------------------------------------------------------+      |        |
 *               |                     dram_llcc_lpi                        |      |        |
 * 0xFF800000    +----------------------------------------------------------+      |        |
 *               |                       dram_acdb                          |      |        |
 *               +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0xE69C0000    +----------------------------------------------------------+      |        |
 *               |                     dram_display                         |      |        |
 * 0xE4800000    +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0xD9632000    +----------------------------------------------------------+      |        |
 *               |                       dram_ta                            |      |        |
 * 0xD8632000    +----------------------------------------------------------+      |        |
 *               |                 BL31 (ARM Trusted Firmware)              |      |        |
 * 0xD856A000    +----------------------------------------------------------+      |        |
 *               |                  dram_tz (TrustZone)                     |      |        |
 * 0xD8000000    +----------------------------------------------------------+      |      DRAM
 *               |               ... Usable memory ...                      |      |        |
 * 0xD7800000    +----------------------------------------------------------+      |        |
 *               |                 Linux Kernel Reserve                     |      |        |
 * 0xC7800000    +----------------------------------------------------------+      |        |
 *               |                        CBMEM                             |      |        |
 *               +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0xA1800000    +----------------------------------------------------------+      |        |
 *               |                      RAMSTAGE                            | DRAM Space 0  |
 * 0xA0800000    +----------------------------------------------------------+      |        |
 *               |                 POSTRAM_CBFS_CACHE                       |      |        |
 * 0x9F800000    +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0x91380000    +----------------------------------------------------------+      |        |
 *               |                       dram_pil                           |      |        |
 * 0x866C0000    +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0x85F80000    +----------------------------------------------------------+      |        |
 *               |                       dram_wlan                          |      |        |
 * 0x85380000    +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0x82800000    +----------------------------------------------------------+      |        |
 *               |                 dram_adsp_rpc_heap                       |      |        |
 * 0x82000000    +----------------------------------------------------------+      |        |
 *               |                   dram_tz_static                         |      |        |
 * 0x81F00000    +----------------------------------------------------------+      |        |
 *               |                       dram_pdp                           |      |        |
 * 0x81E00000    +----------------------------------------------------------+      |        |
 *               |                  ... Usable memory ...                   |      |        |
 * 0x81CF4000    +----------------------------------------------------------+      |        |
 *               |                       dram_dc_log                        |      |        |
 * 0x81CE4000    +----------------------------------------------------------+      |        |
 *               |                       dram_tme_log                       |      |        |
 * 0x81CE0000    +----------------------------------------------------------+      |        |
 *               |                  dram_tme_crashdump                      |      |        |
 * 0x81CA0000    +----------------------------------------------------------+      |        |
 *               |                   dram_aop_config                        |      |        |
 * 0x81C80000    +----------------------------------------------------------+      |        |
 *               |                   dram_aop_cmd_db                        |      |        |
 * 0x81C60000    +----------------------------------------------------------+      |        |
 *               |                       dram_aop                           |      |        |
 * 0x81C00000    +----------------------------------------------------------+      |        |
 *               |                     dram_ramdump                         |      |        |
 * 0x81A40000    +----------------------------------------------------------+      |        |
 *               |                     dram_xbl_log                         |      |        |
 * 0x81A00000    +----------------------------------------------------------+      |        |
 *               |                ... Usable memory ...                     |      |        |
 * 0x815A0000    +----------------------------------------------------------+      |        |
 *               |                      dram_cpucp                          |      |        |
 * 0x80E00000    +----------------------------------------------------------+      |        |
 *               |                      dram_ncc                            |      |        |
 * 0x80A00000    +----------------------------------------------------------+      |        |
 *               |              postram_dma_coherent_dram                   |      |        |
 * 0x80004000    +----------------------------------------------------------+      |        |
 *               |                    POSTRAM STACK                         |      v        v
 * 0x80000000    +----------------------------------------------------------+ <--------------
 *               |         ... (Memory not mapped: Unavailable) ...         | XXXXXXXXX
 * 0x24060000    +----------------------------------------------------------+ <---------
 *               |                         shrm                             |    SHRM
 * 0x24040000    +----------------------------------------------------------+ <---------
 *               |         ... (Memory not mapped: Unavailable) ...         | XXXXXXXXX
 * 0x14A80000    +----------------------------------------------------------+ <---------
 *               |                    auth_metadata                         |      ^
 * 0x14A7E000    +----------------------------------------------------------+      |
 *               |                     debug_policy                         |      |
 * 0x14A7D000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x14A59000    +----------------------------------------------------------+      |
 *               |         OVERLAP_DECOMPRESSOR_VERSTAGE_ROMSTAGE           |      |
 * 0x14A38000    +----------------------------------------------------------+      |
 *               |                 PRERAM_CBMEM_CONSOLE                     |      |
 * 0x14A30000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x14A1A000    +----------------------------------------------------------+      |
 *               |                        CPR                               |      |
 * 0x14A17000    +----------------------------------------------------------+      |
 *               |                       qclib                              |      |
 * 0x14897000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x14891000    +----------------------------------------------------------+      |
 *               |                  apdp_ramdump_meta                       |      |
 * 0x14890000    +----------------------------------------------------------+      |
 *               |                    aop_blob_meta                         |      |
 * 0x1488C000    +----------------------------------------------------------+      |
 *               |                    qc_blob_meta                          |      |
 * 0x14888000    +----------------------------------------------------------+      |
 *               |                    ddr_training                          |      |
 * 0x14878000    +----------------------------------------------------------+      |
 *               |               dtb (Device Tree Blob)                     |      |
 * 0x14870000    +----------------------------------------------------------+      |
 *               |                dcb (DDR Config Block)                    |      |
 * 0x14862000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x14860C00    +----------------------------------------------------------+      |
 *               |                     FMAP_CACHE                           |      |
 * 0x14860000    +----------------------------------------------------------+    BSRAM
 *               |                    CBFS_MCACHE                           |      |
 * 0x1485C000    +----------------------------------------------------------+      |
 *               |                  qclib_serial_log                        |      |
 * 0x1485B000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x14859000    +----------------------------------------------------------+      |
 *               |               preram_dma_coherent_dram                   |      |
 * 0x14857000    +----------------------------------------------------------+      |
 *               |                    VBOOT2_WORK                           |      |
 * 0x14854000    +----------------------------------------------------------+      |
 *               |                    PRERAM STACK                          |      |
 * 0x14850000    +----------------------------------------------------------+      |
 *               |             TTB (Translation Table Base)                 |      |
 * 0x14842000    +----------------------------------------------------------+      |
 *               |                     TIMESTAMP                            |      |
 * 0x14841C00    +----------------------------------------------------------+      |
 *               |                 PRERAM_CBFS_CACHE                        |      |
 * 0x14828000    +----------------------------------------------------------+      |
 *               |                     BOOTBLOCK                            |      |
 * 0x14819000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x14815000    +----------------------------------------------------------+      |
 *               |                   pbl_timestamps                         |      v
 * 0x14800000    +----------------------------------------------------------+ <---------
 *               |              ... (Large Address Gap) ...                 |
 *               +----------------------------------------------------------+
 *               |                ... Usable memory ...                     |
 * 0x146AC000    +----------------------------------------------------------+ <---------
 *               |                 WATCHDOG_TOMBSTONE                       |      ^
 * 0x146ABFFC    +----------------------------------------------------------+      |
 *               |                   ddr_information                        |      |
 * 0x146ABFE8    +----------------------------------------------------------+      |
 *               |                     shared_imem                          |      |
 * 0x146AA000    +----------------------------------------------------------+      |
 *               |                      aop_imem                            |      |
 * 0x146A8000    +----------------------------------------------------------+    SSRAM
 *               |                   qdss_usb_trace                         |      |
 * 0x146A6000    +----------------------------------------------------------+      |
 *               |                ... Usable memory ...                     |      |
 * 0x146A5000    +----------------------------------------------------------+      |
 *               |                      AOP SDI                             |      |
 * 0x14699000    +----------------------------------------------------------+      |
 *               |                 Reserved for QSEE                        |      v
 * 0x14680000    +----------------------------------------------------------+ <---------
 *               |         ... (Memory not mapped: Unavailable) ...         | XXXXXXXXX
 * 0x0B100000    +----------------------------------------------------------+ <---------
 *               |                ... Usable memory ...                     |      ^
 * 0x0B0E8000    +----------------------------------------------------------+      |
 *               |                    aop_data_ram                          |      |
 * 0x0B0E0000    +----------------------------------------------------------+   AOP SRAM
 *               |                ... Usable memory ...                     |      |
 * 0x0B018000    +----------------------------------------------------------+      |
 *               |                    aop_code_ram                          |      v
 * 0x0B000000    +----------------------------------------------------------+ <---------
 *
 */

SECTIONS
{
	AOPSRAM_START(0x0B000000)
	REGION(aop_code_ram, 0x0B000000, 0x18000, 4K)
	REGION(aop_data_ram, 0x0B0E0000, 0x8000, 4K)
	AOPSRAM_END(0x0B100000)

	SSRAM_START(0x14680000)
	REGION(qsee, 0x14680000, 100K, 4K)
	REGION(aop_sdi, 0x14699000, 48K, 4K)
	REGION(qdss_usb_trace, 0x146A6000, 8K, 4K)
	REGION(aop_imem, 0x146A8000, 8K, 4K)
	REGION(shared_imem, 0x146AA000, 0x1000, 4K)
	REGION(ddr_information, 0x146ABFE8, 16, 8)
	WATCHDOG_TOMBSTONE(0x146ABFFC, 4)
	SSRAM_END(0x146AC000)

	BSRAM_START(0x14800000)
	REGION(pbl_timestamps, 0x14800000, 84K, 4K)
	BOOTBLOCK(0x14819000, 60K)
	PRERAM_CBFS_CACHE(0x14828000, 103K)
	TIMESTAMP(0x14841C00, 1K)
	TTB(0x14842000, 56K)
	PRERAM_STACK(0x14850000, 16K)
	VBOOT2_WORK(0x14854000, 12K)
	PRERAM_DMA_COHERENT(0x14857000, 8K)
	REGION(qclib_serial_log, 0x1485B000, 4K, 4K)
	CBFS_MCACHE(0x1485C000,16K)
	FMAP_CACHE(0x14860400, 2K)
	REGION(dcb, 0x14862000, 56K, 4K)
	REGION(dtb, 0x14870000, 32K, 4K)
	REGION(ddr_training, 0x14878000, 64K, 4K)
	REGION(qc_blob_meta, 0x14888000, 16K, 4K)
	REGION(aop_blob_meta, 0x1488c000, 16K, 4K)
	REGION(apdp_ramdump_meta, 0x14890000, 4K, 4K)
	REGION(qclib, 0x14897000, 1536K, 4K)
	REGION(cpr_settings, 0x14A17000, 12K, 4K)
	PRERAM_CBMEM_CONSOLE(0x14A30000, 32K)
	OVERLAP_DECOMPRESSOR_VERSTAGE_ROMSTAGE(0x14A38000, 132K)
	REGION(debug_policy, 0x14A7D000 , 4K, 4K)
	REGION(auth_metadata, 0x14A7E000, 8K, 4K)
	BSRAM_END(0x14A80000)

	REGION(shrm, 0x24040000, 128K , 4K)

	DRAM_START(0x80000000)
	POSTRAM_STACK(0x80000000, 16K)
	POSTRAM_DMA_COHERENT(0x80004000, 8K)
	REGION(dram_ncc, 0x80A00000, 0x400000, 4K)
	REGION(dram_cpucp, 0x80E00000, 0x7A0000, 4K)

	REGION(dram_xbl_log, 0x81A00000, 0x40000, 4K)
	REGION(dram_ramdump, 0x81A40000, 0x1C0000, 4K)

	REGION(dram_aop, 0x81C00000, 0x60000, 4K)
	REGION(dram_aop_cmd_db, 0x81C60000, 0x20000, 4K)
	REGION(dram_aop_config, 0x81C80000, 0x20000, 4K)
	REGION(dram_tme_crashdump, 0x81CA0000, 0x40000, 4K)
	REGION(dram_tme_log, 0x81CE0000, 0x4000, 4K)
	REGION(dram_dc_log, 0x81CE4000, 0x10000, 4K)

	REGION(dram_pdp, 0x81E00000, 0x100000, 4K)
	REGION(dram_tz_static, 0x81F00000, 0x100000, 4K)
	REGION(dram_adsp_rpc_heap, 0x82000000, 0x800000, 4K)
	REGION(dram_wlan, 0x85380000, 0xC00000, 4K)
	REGION(dram_pil, 0x866C0000, 0xACC0000, 4K)

	POSTRAM_CBFS_CACHE(0x9F800000, 16M)
	RAMSTAGE(0xA0800000, 16M)
	REGION(dram_tz, 0xD8000000, 0x56A000, 4K)
	BL31(0xD856A000, 800K)
	REGION(dram_ta, 0xD8632000, 0x1000000, 4K)
	REGION(dram_display, 0xE4800000, 0x21C0000, 4K)
	REGION(dram_llcc_lpi, 0xFF800000, 0x600000, 4K)
	REGION(dram_smem, 0xFFE00000, 0x200000, 4K)
	DRAM_END(0x100000000)

	/*
	 * Define the address range limits for fragmented DRAM regions.
	 *
	 * These regions, `dram_space_1` and `dram_space_2`, are used to map physical
	 * memory beyond the initial `_dram` region. The MMU configuration logic in
	 * `mmu.c` uses `REGION_SIZE()` to dynamically size these ranges based on the
	 * total system DRAM capacity, which is determined by the QCLib.
	 *
	 * Example for a 16GB DRAM system:
	 * - `_dram` (2GB):          0x80000000 - 0x100000000
	 * - `_dram_space_1` (14GB): 0x880000000 - 0x440000000 (0x880000000 + 14GB)
	 *
	 * Note: The example memory addresses are for illustration and depend on the
	 * platform's specific memory map.
	 */
	REGION(dram_space_1, 0x880000000, 0x780000000, 4K)
	REGION(dram_space_2, 0x8800000000, 0x7800000000, 4K)
}
