/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_MEDIATEK_COMMON_MIPI_TX_REG_V1_H_
#define _SOC_MEDIATEK_COMMON_MIPI_TX_REG_V1_H_

#include <commonlib/bsd/helpers.h>
#include <types.h>

/* MIPITX_REG */
struct mipi_tx_regs {
	u32 reserved0[3];
	u32 lane_con;
	u32 voltage_sel;
	u32 reserved1[5];
	u32 pll_pwr;
	u32 pll_con0;
	u32 pll_con1;
	u32 pll_con2;
	u32 pll_con3;
	u32 pll_con4;
	u32 phy_sel[4];
	u32 reserved2[61];
	u32 d2_sw_ctl_en;
	u32 reserved3[63];
	u32 d0_sw_ctl_en;
	u32 reserved4[56];
	u32 ck_ckmode_en;
	u32 reserved5[6];
	u32 ck_sw_ctl_en;
	u32 reserved6[63];
	u32 d1_sw_ctl_en;
	u32 reserved7[63];
	u32 d3_sw_ctl_en;
};

check_member(mipi_tx_regs, voltage_sel, 0x10);
check_member(mipi_tx_regs, pll_con4, 0x3C);
check_member(mipi_tx_regs, phy_sel[0], 0x40);
check_member(mipi_tx_regs, phy_sel[3], 0x4C);
check_member(mipi_tx_regs, d3_sw_ctl_en, 0x544);

static struct mipi_tx_regs *const mipi_tx0 = (void *)MIPITX0_BASE;

/* Register values */
#define DSI_CK_CKMODE_EN	BIT(0)
#define DSI_SW_CTL_EN		BIT(0)
#define AD_DSI_PLL_SDM_PWR_ON	BIT(0)
#define AD_DSI_PLL_SDM_ISO_EN	BIT(1)

#define RG_DSI_PLL_EN		BIT(4)
#define RG_DSI_PLL_POSDIV	(0x7 << 8)

#endif /* _SOC_MEDIATEK_COMMON_MIPI_TX_REG_V1_H_ */
