/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef DSI_REGISTER_V3_H
#define DSI_REGISTER_V3_H

#include <commonlib/helpers.h>
#include <soc/addressmap.h>
#include <types.h>

struct dsi_regs {
	u32 dsi_start;
	u32 dsi_status;
	u32 dsi_inten;
	u32 dsi_intsta;
	u32 dsi_dp_inten;
	u32 dsi_dp_intsta;
	u32 dsi_scp_inten;
	u32 dsi_scp_intsta;
	u32 dsi_cg_con;
	u32 dsi_rst_con;
	u32 dsi_1tnp_con;
	u32 dsi_size_con;
	u32 dsi_con_ctrl;
	u32 dsi_mode_ctrl;
	u32 dsi_txrx_ctrl;
	u32 dsi_psctrl;
	u32 dsi_v3d_con;
	u32 dsi_cmdq_size;
	u32 dsi_mem_conti;
	u32 dsi_frm_bc;
	u32 dsi_cmd_type1_hs;
	u32 dsi_cmd_type1_lp_ext;
	u32 dsi_ext_source;
	u32 reserved0;
	u32 dsi_vsa_nl;
	u32 dsi_vbp_nl;
	u32 dsi_vfp_nl;
	u32 dsi_vact_nl;
	u32 reserved1[4];
	u32 dsi_hsa_wc;
	u32 dsi_hbp_wc;
	u32 dsi_hfp_wc;
	u32 dsi_bllp_wc;
	u32 reserved2[4];
	u32 dsi_rx_con;
	u32 dsi_rx_data03;
	u32 dsi_rx_data47;
	u32 dsi_rx_data8b;
	u32 dsi_rx_datac;
	u32 dsi_rx_rack;
	u32 dsi_rx_trig_sta;
	u32 reserved3;
	u32 dsi_dma_in_con0;
	u32 dsi_dma_in_con1;
	u32 reserved4[2];
	u32 dsi_shadow_ctrl;
	u32 dsi_shadow_group_en;
	u32 dsi_shadow_source_sel;
	u32 dsi_shadow_sta;
	u32 reserved5[4];
	u32 dsi_target_nl;
	u32 reserved6;
	u32 dsi_scramble_con;
	u32 reserved7;
	u32 dsi_hstx_cklp_wc;
	u32 dsi_hstx_cklp_wc_auto_result;
	u32 reserved8[2];
	u32 dsi_vm_cmd_con;
	u32 dsi_vm_cmd_con1;
	u32 dsi_vm_cmd_data[16];
	u32 reserved9[6];
	u32 dsi_vfp_early_stop;
	u32 dsi_vfp_early_stop_interval;
	u32 dsi_vfp_early_stop_l0;
	u32 dsi_vfp_early_stop_l2;
	u32 dsi_vfp_early_stop_l4;
	u32 dsi_vfp_early_stop_l6;
	u32 reserved10[2];
	u32 dsi_em_gen_con;
	u32 reserved11[3];
	u32 dsi_lfr_con;	/* Available since MT8183 */
	u32 dsi_lfr_sta;	/* Available since MT8183 */
	u32 dsi_ltpo_vdo_con;
	u32 dsi_ltpo_vdo_sq0;
	u32 dsi_ltpo_vdo_sq1;
	u32 dsi_ltpo_vdo_sq2;
	u32 dsi_ltpo_vdo_sq3;
	u32 dsi_ltpo_vdo_sq4;
	u32 reserved12[4];
	u32 dsi_phy_lccon;
	u32 dsi_phy_ld0con;
	u32 dsi_phy_syncon;
	u32 reserved13;
	u32 dsi_cphy_con0;
	u32 dsi_cphy_con1;
	u32 reserved14[6];
	u32 dsi_time_con0;
	u32 dsi_time_con1;
	u32 dsi_time_con2;
	u32 reserved15;
	u32 dsi_gce_event_con0;
	u32 dsi_gce_event_con1;
	u32 reserved16[2];
	u32 dsi_dbg_con0;
	u32 dsi_dbg_con1;
	u32 reserved17[2];
	u32 dsi_self_pat_con0;
	u32 dsi_self_pat_con1;
	u32 reserved18[2];
	u32 dsi_input_setting;
	u32 dsi_input_debug;
	u32 dsi_in_cksm;
	u32 reserved19;
	u32 dsi_cksm_out;
	u32 dsi_crc_cksm;
	u32 dsi_sof_num;
	u32 reserved20;
	u32 dsi_frame_cnt_dsick;
	u32 dsi_frame_cnt_mmck;
	u32 reserved21[2];
	u32 dsi_mac_state_dbg0[5];
	u32 reserved22[7];
	u32 dsi_mute_mode_con;
	u32 dsi_mute_mode_dbg;
	u32 reserved23[22];
	u32 dsi_buf_con0;
	u32 dsi_buf_con1;
	u32 dsi_buf_reset;
	u32 dsi_buf_log;
	u32 dsi_buf_rw_times;
	u32 dsi_buf_sodi_high;
	u32 dsi_buf_sodi_low;
	u32 dsi_buf_dvfs_high;
	u32 dsi_buf_dvfs_low;
	u32 dsi_buf_preultra_high;
	u32 dsi_buf_preultra_low;
	u32 dsi_buf_ultra_high;
	u32 dsi_buf_ultra_low;
	u32 dsi_buf_urgent_high;
	u32 dsi_buf_urgent_low;
	u32 dsi_buf_preurgent_high;
	u32 reserved24[32];
	u32 dsi_ocla_con0;
	u32 reserved25;
	u32 dsi_ocla_sub_log[5];
	u32 dsi_ocla_dsi_log[5];
	u32 dsi_mac_err;
	u32 dsi_rollback_dbg;
	u32 dsi_reserved;
	u32 dsi_reserved_w_shadow;
	u32 dsi_cmdq[128];
	u32 dsi_phy_timecon0;
	u32 dsi_phy_timecon1;
	u32 dsi_phy_timecon2;
	u32 dsi_phy_timecon3;
	u32 dsi_phy_lcpat;
	u32 dsi_phy_con;
	u32 dsi_dphy_lane_swap;
	u32 dsi_cphy_trio_swap;
	u32 reserved26[2];
	u32 dsi_cphy_trio_con;
	u32 reserved27;
	u32 dsi_dphy_dbg0;
	u32 dsi_dphy_dbg1;
	u32 dsi_dphy_dbg2;
	u32 dsi_dphy_dbg3;
	u32 dsi_dphy_dbg4;
	u32 dsi_dphy_dbg5;
	u32 dsi_dphy_dbg6;
	u32 reserved28;
	u32 dsi_cphy_dbg0;
	u32 dsi_cphy_dbg1;
	u32 reserved29[2];
	u32 dsi_phy_dbg_con;
	u32 reserved30[8];
	u32 dsi_line_time_fix;
	u32 reserved31[2];
	u32 dsi_phy_cg_con;
	u32 reserved32[26];
	u32 dsi_phy_rollback_dbg;
};

check_member(dsi_regs, dsi_buf_con0, 0x300);
check_member(dsi_regs, dsi_ocla_con0, 0x3C0);
check_member(dsi_regs, dsi_phy_timecon0, 0x600);
check_member(dsi_regs, dsi_phy_cg_con, 0x690);
check_member(dsi_regs, dsi_phy_rollback_dbg, 0x6FC);

static struct dsi_regs *const dsi0 = (void *)DSI0_BASE;
static struct dsi_regs *const dsi1 = (void *)DSI1_BASE;

#endif /* DSI_REGISTER_V3_H */
