/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* Pad configuration was generated automatically using intelp2m 2.5-149f0c750c */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_I0, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_I1, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_I2, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_I3, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_I4, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_I5, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I6, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I10, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_I11, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_I12, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_I13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_I14, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_I15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I16, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I17, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I19, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I20, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I21, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_I22, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_R ------- */
	_PAD_CFG_STRUCT(GPP_R0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_R1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_R2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_R3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_R4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_R5, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R6, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R10, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R15, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_R16, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF), 0),
	_PAD_CFG_STRUCT(GPP_R17, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_R18, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF), 0),
	_PAD_CFG_STRUCT(GPP_R19, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_R20, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_R21, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_J0, NONE, RSMRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_J1, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_J2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_J3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_J4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_J5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_J6, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_J7, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_J8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_J9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_J10, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_J11, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group vGPIO ------- */

	/* ------- GPIO Group vGPIO_0 ------- */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_B0, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B1, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_B2, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPO(GPP_B3, 1, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_B4, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_B5, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_B6, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_B7, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_B8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B10, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B11, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_B12, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_B13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_B14, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), PAD_PULL(DN_20K)),
	PAD_CFG_GPI_TRIG_OWN(GPP_B15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B16, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_B17, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_B18, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_B19, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPO(GPP_B20, 0, PLTRST),
	_PAD_CFG_STRUCT(GPP_B21, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | 1, 0),
	PAD_CFG_GPO(GPP_B22, 0, PLTRST),
	_PAD_CFG_STRUCT(GPP_B23, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),

	/* ------- GPIO Group GPP_G ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_G0, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_G1, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_G2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G3, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G4, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_G5, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_G6, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_G7, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_H0, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H1, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H3, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H4, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_H5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_H6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_H7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H10, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_H11, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_H12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H15, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_H16, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_H17, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H19, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H20, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H21, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H22, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_H23, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPD ------- */
	PAD_CFG_GPI_TRIG_OWN(GPD0, NONE, PWROK, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPD1, NONE, PWROK, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPD2, NONE, PWROK, NF1),	/* LAN_WAKE# */
	PAD_CFG_NF(GPD3, NONE, PWROK, NF1),	/* PWRBTN# */
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),	/* SLP_S4# */
	PAD_CFG_GPI_TRIG_OWN(GPD6, NONE, PWROK, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPD7, NONE, PWROK, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1),	/* SUSCLK */
	PAD_CFG_GPI_TRIG_OWN(GPD9, NONE, PWROK, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPD10, 0, PWROK),	/* GPIO */
	PAD_CFG_GPO(GPD11, 0, PWROK),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPD12, NONE, PWROK, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group SPI ------- */

	/* ------- GPIO Group GPP_A ------- */
	_PAD_CFG_STRUCT(GPP_A0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_A1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_A2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_A3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_A4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_A5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),
	_PAD_CFG_STRUCT(GPP_A6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_A7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A9, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_A10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),
	PAD_CFG_GPI_TRIG_OWN(GPP_A11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_A14, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_C ------- */
	_PAD_CFG_STRUCT(GPP_C0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_C1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_C2, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_C3, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C4, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_C5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	PAD_CFG_GPO(GPP_C6, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_C7, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_C8, PAD_FUNC(GPIO) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_C9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C10, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C12, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C13, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_C14, PAD_FUNC(GPIO) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_C15, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_C16, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_C17, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_C18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C19, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C20, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C21, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C22, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_C23, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group vGPIO_3 ------- */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_S ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_S0, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S1, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S3, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S4, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S5, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S6, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_S7, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_E ------- */
	_PAD_CFG_STRUCT(GPP_E0, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1) | 1, 0),
	_PAD_CFG_STRUCT(GPP_E1, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_E2, NONE, PLTRST, OFF, ACPI),
	PAD_NC(GPP_E3, NONE),
	_PAD_CFG_STRUCT(GPP_E4, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_E5, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E6, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E7, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_E8, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_E9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_E10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_E11, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_E12, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_E13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E16, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E17, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_E19, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_E20, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_E21, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_K ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_K0, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K1, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_K2, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_K3, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K4, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K5, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_K6, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),
	_PAD_CFG_STRUCT(GPP_K7, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),
	PAD_CFG_GPO(GPP_K8, 1, PLTRST),
	_PAD_CFG_STRUCT(GPP_K9, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_K10, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),
	PAD_CFG_GPI_TRIG_OWN(GPP_K11, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_F0, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F1, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F3, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F4, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F5, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F6, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F8, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F9, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F10, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F11, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F14, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F16, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F17, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F19, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F20, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F21, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_F22, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | 1, 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_F23, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_D ------- */
	_PAD_CFG_STRUCT(GPP_D0, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_D1, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D2, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D3, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_D4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_D5, PAD_FUNC(NF2) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),
	_PAD_CFG_STRUCT(GPP_D6, PAD_FUNC(NF3) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_D7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D8, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_D9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_D10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	_PAD_CFG_STRUCT(GPP_D11, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_D12, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D13, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D14, NONE, PLTRST, OFF, ACPI),
	_PAD_CFG_STRUCT(GPP_D15, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),
	PAD_CFG_GPI_TRIG_OWN(GPP_D16, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D17, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D19, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D20, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D21, NONE, RSMRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D22, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D23, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group JTAG ------- */

	/* ------- GPIO Group CPU ------- */
};

/* PCIe CLK REQs as per devicetree.cb */
static const struct pad_config clkreq_disabled_table[] = {
	/* GPP_D0 - SRCCLKREQ0# */
	PAD_NC(GPP_D0, NONE),
	/* GPP_H6 - SRCCLKREQ4# */
	PAD_NC(GPP_D11, NONE),
	/* GPP_H6 - SRCCLKREQ11# */
	PAD_NC(GPP_H5, NONE),
	/* GPP_H6 - SRCCLKREQ12# */
	PAD_NC(GPP_H6, NONE),

	/* CPU PCIe CLKREQ virtual wire message buses */
	_PAD_CFG_STRUCT(VGPIO_PCIE_0,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_1,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_2,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_3,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_4,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_5,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_6,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_7,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_8,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_9,  PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_10, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_11, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_12, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_13, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_14, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_15, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_64, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_65, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_66, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_67, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),

	_PAD_CFG_STRUCT(VGPIO_PCIE_16, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_17, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_18, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_19, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_20, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_21, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_22, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_23, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_24, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_25, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_26, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_27, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_28, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_29, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_30, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_31, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_68, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_69, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_70, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_71, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),

	_PAD_CFG_STRUCT(VGPIO_PCIE_32, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_33, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_34, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_35, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_36, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_37, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_38, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_39, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_40, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_41, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_42, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_43, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_44, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_45, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_46, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_47, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_72, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_73, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_74, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_75, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),

	_PAD_CFG_STRUCT(VGPIO_PCIE_48, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_49, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_50, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_51, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_52, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_53, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_54, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_55, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_56, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_57, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_58, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_59, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_60, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_61, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_62, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_63, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_76, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_77, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_78, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
	_PAD_CFG_STRUCT(VGPIO_PCIE_79, PAD_FUNC(GPIO) | PAD_RESET(DEEP), 0),
};

#endif /* CFG_GPIO_H */
