/*
 * Copyright (c) 2025, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef DCM_MTK_DCM_UTILS_H_
#define DCM_MTK_DCM_UTILS_H_

#include <stdbool.h>

#include <platform_def.h>

#define MCUSYS_PAR_WRAP_BASE		(MCUCFG_BASE + 0x001B0000)
#define MCUSYS_PAR_WRAP_SIZE		(0x10000)
#define APINFRA_IO_CTRL_AO		(IO_PHYS + 0x00156000)
#define APINFRA_IO_CTRL_AO_SIZE		(0x1000)
#define APINFRA_IO_NOC_AO		(IO_PHYS + 0x04012000)
#define APINFRA_IO_NOC_AO_SIZE		(0x1000)
#define APINFRA_MEM_INTF_NOC_AO		(IO_PHYS + 0x04032000)
#define APINFRA_MEM_INTF_NOC_AO_SIZE	(0x1000)
#define APINFRA_MEM_CTRL_AO		(IO_PHYS + 0x04124000)
#define APINFRA_MEM_CTRL_AO_SIZE	(0x1000)
#define PERI_AO_BCRM_BASE		(IO_PHYS + 0x06610000)
#define PERI_AO_BCRM_BASE_SIZE		(0x1000)
#define VLP_AO_BCRM_BASE		(IO_PHYS + 0x0c030000)
#define VLP_AO_BCRM_BASE_SIZE		(0x1000)

#define MCUSYS_PAR_WRAP_L3_SHARE_DCM_CTRL	(MCUSYS_PAR_WRAP_BASE + 0x78)
#define MCUSYS_PAR_WRAP_MP_ADB_DCM_CFG0		(MCUSYS_PAR_WRAP_BASE + 0x270)
#define MCUSYS_PAR_WRAP_ADB_FIFO_DCM_EN		(MCUSYS_PAR_WRAP_BASE + 0x278)
#define MCUSYS_PAR_WRAP_MP0_DCM_CFG0		(MCUSYS_PAR_WRAP_BASE + 0x27c)
#define MCUSYS_PAR_WRAP_QDCM_CONFIG0		(MCUSYS_PAR_WRAP_BASE + 0x280)
#define MCUSYS_PAR_WRAP_L3GIC_ARCH_CG_CONFIG	(MCUSYS_PAR_WRAP_BASE + 0x294)
#define MCUSYS_PAR_WRAP_QDCM_CONFIG1		(MCUSYS_PAR_WRAP_BASE + 0x284)
#define MCUSYS_PAR_WRAP_QDCM_CONFIG2		(MCUSYS_PAR_WRAP_BASE + 0x288)
#define MCUSYS_PAR_WRAP_QDCM_CONFIG3		(MCUSYS_PAR_WRAP_BASE + 0x28c)
#define MCUSYS_PAR_WRAP_CI700_DCM_CTRL		(MCUSYS_PAR_WRAP_BASE + 0x298)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_3TO1_CONFIG	(MCUSYS_PAR_WRAP_BASE + 0x2a0)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_2TO1_CONFIG	(MCUSYS_PAR_WRAP_BASE + 0x2a4)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_4TO2_CONFIG	(MCUSYS_PAR_WRAP_BASE + 0x2a8)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_1TO2_CONFIG	(MCUSYS_PAR_WRAP_BASE + 0x2ac)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_2TO5_CONFIG	(MCUSYS_PAR_WRAP_BASE + 0x2b0)
#define MCUSYS_PAR_WRAP_CBIP_P2P_CONFIG0	(MCUSYS_PAR_WRAP_BASE + 0x2b4)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_1TO2_L3GIC_CONFIG \
		(MCUSYS_PAR_WRAP_BASE + 0x2bc)
#define MCUSYS_PAR_WRAP_CBIP_CABGEN_1TO2_INFRA_CONFIG \
		(MCUSYS_PAR_WRAP_BASE + 0x2c4)
#define MCUSYS_PAR_WRAP_MP_CENTRAL_FABRIC_SUB_CHANNEL_CG \
		(MCUSYS_PAR_WRAP_BASE + 0x2b8)
#define MCUSYS_PAR_WRAP_ACP_SLAVE_DCM_EN	(MCUSYS_PAR_WRAP_BASE + 0x2dc)
#define MCUSYS_PAR_WRAP_GIC_SPI_SLOW_CK_CFG	(MCUSYS_PAR_WRAP_BASE + 0x2e0)
#define MCUSYS_PAR_WRAP_EBG_CKE_WRAP_FIFO_CFG	(MCUSYS_PAR_WRAP_BASE + 0x404)
#define CLK_AXI_VDNR_DCM_TOP_APINFRA_IO_INTX_BUS_CTRL_0 \
		(APINFRA_IO_CTRL_AO + 0x8)
#define CLK_IO_NOC_VDNR_DCM_TOP_APINFRA_IO_INTF_PAR_BUS_CTRL_0 \
		(APINFRA_IO_NOC_AO + 0x4)
#define VDNR_DCM_TOP_APINFRA_MEM_INTF_PAR_BUS_CTRL_0 \
		(APINFRA_MEM_INTF_NOC_AO + 0x0)
#define CLK_FMEM_SUB_CFG_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_0 \
		(APINFRA_MEM_CTRL_AO + 0xc)
#define CLK_FMEM_SUB_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_0 \
		(APINFRA_MEM_CTRL_AO + 0x14)
#define CLK_FMEM_SUB_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_1 \
		(APINFRA_MEM_CTRL_AO + 0x18)
#define CLK_FMEM_SUB_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_2 \
		(APINFRA_MEM_CTRL_AO + 0x1c)
#define CLK_FMEM_SUB_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_3 \
		(APINFRA_MEM_CTRL_AO + 0x20)
#define CLK_FMEM_SUB_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_4 \
		(APINFRA_MEM_CTRL_AO + 0x24)
#define CLK_FMEM_SUB_VDNR_DCM_TOP_APINFRA_MEM_INTX_BUS_CTRL_5 \
		(APINFRA_MEM_CTRL_AO + 0x28)

#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL1_0	(PERI_AO_BCRM_BASE + 0x2c)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL1_1	(PERI_AO_BCRM_BASE + 0x30)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL1_2	(PERI_AO_BCRM_BASE + 0x34)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL1_3	(PERI_AO_BCRM_BASE + 0x38)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL2_0	(PERI_AO_BCRM_BASE + 0x20)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL2_1	(PERI_AO_BCRM_BASE + 0x24)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL2_2	(PERI_AO_BCRM_BASE + 0x28)
#define VDNR_DCM_TOP_PERI_PAR_BUS_CTRL2_3	(PERI_AO_BCRM_BASE + 0x2c)
#define VDNR_DCM_TOP_VLP_PAR_BUS_TOP_CTRL_0	(VLP_AO_BCRM_BASE + 0x5c)

#define MCUSYS_PAR_WRAP_MCU_L3C_DCM_REG0_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_L3C_DCM_REG0_ON		0x1
#define MCUSYS_PAR_WRAP_MCU_L3C_DCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_ACP_DCM_REG0_MASK		0x10001
#define MCUSYS_PAR_WRAP_MCU_ACP_DCM_REG0_ON		0x10001
#define MCUSYS_PAR_WRAP_MCU_ACP_DCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_ADB_DCM_REG0_MASK		0x1FFF07FF
#define MCUSYS_PAR_WRAP_MCU_ADB_DCM_REG0_ON		0x1FFF07FF
#define MCUSYS_PAR_WRAP_MCU_ADB_DCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_STALLDCM_REG0_MASK		0xFF
#define MCUSYS_PAR_WRAP_MCU_STALLDCM_REG0_ON		0xFF
#define MCUSYS_PAR_WRAP_MCU_STALLDCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_APB_DCM_REG0_MASK		0x1FFFF00
#define MCUSYS_PAR_WRAP_MCU_APB_DCM_REG0_ON		0x1FFFF00
#define MCUSYS_PAR_WRAP_MCU_APB_DCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_IO_DCM_REG0_MASK		0x1001
#define MCUSYS_PAR_WRAP_MCU_IO_DCM_REG1_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_IO_DCM_REG0_ON		0x1001
#define MCUSYS_PAR_WRAP_MCU_IO_DCM_REG1_ON		0x1
#define MCUSYS_PAR_WRAP_MCU_IO_DCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_IO_DCM_REG1_OFF		0
#define MCUSYS_PAR_WRAP_MCU_BUS_QDCM_REG0_MASK		0x1110000
#define MCUSYS_PAR_WRAP_MCU_BUS_QDCM_REG1_MASK		0x1111
#define MCUSYS_PAR_WRAP_MCU_BUS_QDCM_REG0_ON		0x1110000
#define MCUSYS_PAR_WRAP_MCU_BUS_QDCM_REG1_ON		0x1111
#define MCUSYS_PAR_WRAP_MCU_BUS_QDCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_BUS_QDCM_REG1_OFF		0
#define MCUSYS_PAR_WRAP_MCU_CORE_QDCM_REG0_MASK		0x11111111
#define MCUSYS_PAR_WRAP_MCU_CORE_QDCM_REG1_MASK		0x1111
#define MCUSYS_PAR_WRAP_MCU_CORE_QDCM_REG0_ON		0x11111111
#define MCUSYS_PAR_WRAP_MCU_CORE_QDCM_REG1_ON		0x1111
#define MCUSYS_PAR_WRAP_MCU_CORE_QDCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_CORE_QDCM_REG1_OFF		0
#define MCUSYS_PAR_WRAP_MCU_BKR_LDCM1_REG0_MASK		0XFFFF0003
#define MCUSYS_PAR_WRAP_MCU_BKR_LDCM1_REG0_ON		0x8A080002
#define MCUSYS_PAR_WRAP_MCU_BKR_LDCM1_REG0_OFF		0x8A080000
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG0_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG1_MASK		0x3
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG2_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG3_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG4_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG5_MASK		0x7
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG6_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG7_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG0_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG1_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG2_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG3_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG4_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG5_ON		0x7
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG6_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG7_ON		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG0_OFF		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG1_OFF		0x3
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG2_OFF		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG3_OFF		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG4_OFF		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG5_OFF		0
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG6_OFF		0x1
#define MCUSYS_PAR_WRAP_MCU_CBIP_DCM_REG7_OFF		0x1
#define MCUSYS_PAR_WRAP_MCU_MISC_DCM_REG0_MASK		0x1
#define MCUSYS_PAR_WRAP_MCU_MISC_DCM_REG0_ON		0x1
#define MCUSYS_PAR_WRAP_MCU_MISC_DCM_REG0_OFF		0
#define MCUSYS_PAR_WRAP_MCU_DSU_ACP_DCM_REG0_MASK	0x1
#define MCUSYS_PAR_WRAP_MCU_DSU_ACP_DCM_REG0_ON		0x1
#define MCUSYS_PAR_WRAP_MCU_DSU_ACP_DCM_REG0_OFF	0
#define MCUSYS_PAR_WRAP_MCU_CHI_MON_DCM_REG0_MASK	0x1E
#define MCUSYS_PAR_WRAP_MCU_CHI_MON_DCM_REG0_ON		0
#define MCUSYS_PAR_WRAP_MCU_CHI_MON_DCM_REG0_OFF	0x1E
#define MCUSYS_PAR_WRAP_MCU_GIC_SPI_DCM_REG0_MASK	0x1
#define MCUSYS_PAR_WRAP_MCU_GIC_SPI_DCM_REG0_ON		0x1
#define MCUSYS_PAR_WRAP_MCU_GIC_SPI_DCM_REG0_OFF	0
#define MCUSYS_PAR_WRAP_MCU_EBG_DCM_REG0_MASK		BIT(2)
#define MCUSYS_PAR_WRAP_MCU_EBG_DCM_REG0_ON		0
#define MCUSYS_PAR_WRAP_MCU_EBG_DCM_REG0_OFF		BIT(2)
#define APINFRA_IO_CTRL_AO_INFRA_BUS_DCM_REG0_MASK	0x14
#define APINFRA_IO_CTRL_AO_INFRA_BUS_DCM_REG0_ON	0x14
#define APINFRA_IO_CTRL_AO_INFRA_BUS_DCM_REG0_OFF	0
#define APINFRA_IO_NOC_AO_INFRA_BUS_DCM_REG0_MASK	BIT(4)
#define APINFRA_IO_NOC_AO_INFRA_BUS_DCM_REG0_ON		BIT(4)
#define APINFRA_IO_NOC_AO_INFRA_BUS_DCM_REG0_OFF	0
#define APINFRA_MEM_INTF_NOC_AO_INFRA_BUS_DCM_REG0_MASK	BIT(4)
#define APINFRA_MEM_INTF_NOC_AO_INFRA_BUS_DCM_REG0_ON	BIT(4)
#define APINFRA_MEM_INTF_NOC_AO_INFRA_BUS_DCM_REG0_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG0_MASK	0x1C
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG1_MASK	0x90
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG2_MASK	BIT(21)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG3_MASK	BIT(22)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG4_MASK	BIT(20)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG5_MASK	BIT(24)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG6_MASK	BIT(23)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG0_ON	0x1C
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG1_ON	0x90
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG2_ON	BIT(21)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG3_ON	BIT(22)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG4_ON	BIT(20)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG5_ON	BIT(24)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG6_ON	BIT(23)
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG0_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG1_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG2_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG3_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG4_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG5_OFF	0
#define APINFRA_MEM_CTRL_AO_INFRA_BUS_DCM_REG6_OFF	0
#define PERI_AO_BCRM_PERI_BUS_DCM_REG0_MASK		0x14920
#define PERI_AO_BCRM_PERI_BUS_DCM_REG1_MASK		BIT(13)
#define PERI_AO_BCRM_PERI_BUS_DCM_REG2_MASK		BIT(13)
#define PERI_AO_BCRM_PERI_BUS_DCM_REG3_MASK		BIT(13)
#define PERI_AO_BCRM_PERI_BUS_DCM_REG0_ON		0x14920
#define PERI_AO_BCRM_PERI_BUS_DCM_REG1_ON		BIT(13)
#define PERI_AO_BCRM_PERI_BUS_DCM_REG2_ON		BIT(13)
#define PERI_AO_BCRM_PERI_BUS_DCM_REG3_ON		BIT(13)
#define PERI_AO_BCRM_PERI_BUS_DCM_REG0_OFF		0
#define PERI_AO_BCRM_PERI_BUS_DCM_REG1_OFF		0
#define PERI_AO_BCRM_PERI_BUS_DCM_REG2_OFF		0
#define PERI_AO_BCRM_PERI_BUS_DCM_REG3_OFF		0
#define VLP_AO_BCRM_VLP_BUS_DCM_REG0_MASK		0x7C026
#define VLP_AO_BCRM_VLP_BUS_DCM_REG0_ON			0x26
#define VLP_AO_BCRM_VLP_BUS_DCM_REG0_OFF		0x6
#define MCUSYS_PAR_WRAP_MCU_BKR_LDCM2_REG0_MASK		(0xFFFF0003)
#define MCUSYS_PAR_WRAP_MCU_BKR_LDCM2_REG0_ON		(0x8A080003)
#define MCUSYS_PAR_WRAP_MCU_BKR_LDCM2_REG0_OFF		(0xA0880000)

void dcm_mcusys_par_wrap_mcu_l3c_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_l3c_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_acp_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_acp_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_adb_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_adb_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_stalldcm(bool on);
bool dcm_mcusys_par_wrap_mcu_stalldcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_apb_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_apb_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_io_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_io_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_bus_qdcm(bool on);
bool dcm_mcusys_par_wrap_mcu_bus_qdcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_core_qdcm(bool on);
bool dcm_mcusys_par_wrap_mcu_core_qdcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_bkr_ldcm1(bool on);
bool dcm_mcusys_par_wrap_mcu_bkr_ldcm1_is_on(void);
void dcm_mcusys_par_wrap_mcu_bkr_ldcm2(bool on);
bool dcm_mcusys_par_wrap_mcu_bkr_ldcm2_is_on(void);
void dcm_mcusys_par_wrap_mcu_cbip_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_cbip_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_misc_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_misc_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_dsu_acp_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_dsu_acp_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_chi_mon_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_chi_mon_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_gic_spi_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_gic_spi_dcm_is_on(void);
void dcm_mcusys_par_wrap_mcu_ebg_dcm(bool on);
bool dcm_mcusys_par_wrap_mcu_ebg_dcm_is_on(void);
void dcm_bcrm_apinfra_io_ctrl_ao_infra_bus_dcm(bool on);
bool dcm_bcrm_apinfra_io_ctrl_ao_infra_bus_dcm_is_on(void);
void dcm_bcrm_apinfra_io_noc_ao_infra_bus_dcm(bool on);
bool dcm_bcrm_apinfra_io_noc_ao_infra_bus_dcm_is_on(void);
void dcm_bcrm_apinfra_mem_intf_noc_ao_infra_bus_dcm(bool on);
bool dcm_bcrm_apinfra_mem_intf_noc_ao_infra_bus_dcm_is_on(void);
void dcm_bcrm_apinfra_mem_ctrl_ao_infra_bus_dcm(bool on);
bool dcm_bcrm_apinfra_mem_ctrl_ao_infra_bus_dcm_is_on(void);
void dcm_peri_ao_bcrm_peri_bus1_dcm(bool on);
bool dcm_peri_ao_bcrm_peri_bus1_dcm_is_on(void);
void dcm_peri_ao_bcrm_peri_bus2_dcm(bool on);
bool dcm_peri_ao_bcrm_peri_bus2_dcm_is_on(void);
void dcm_vlp_ao_bcrm_vlp_bus_dcm(bool on);
bool dcm_vlp_ao_bcrm_vlp_bus_dcm_is_on(void);

#endif /* DCM_MTK_DCM_UTILS_H_ */
