---
title: Migrating from Libreboot where GbE size differs
x-toc-enable: true
...

On most/all Dell systems, 8KB GbE regions are used in Libreboot, but
the Canoeboot setup doesn't modify the GbE region size, instead leaving
the usual default of 16KB in place.

Because of this, since the ME region is next to the GbE region, if you
were to flash a Canoeboot IFD once you already flashed Libreboot, you
would, by virtue of the IFD's partition/region layout, overwrite the
first 8KB of the ME region, thus bricking the machine until you correct it.

Therefore, if you are migrating from Libreboot to Canoeboot on a Dell system,
or indeed any system in fact, please check the size of the GbE region in
Canoeboot's version. If the Canoeboot version is 16KB, which it is on most
Dell systems, then do not overwrite the IFD region.

In other words, please do:

```
flashprog -p PROGRAMMER --ifd -i bios -w canoeboot.rom
```

Please *only* flash the BIOS region, if you already have Libreboot and are
migrating from Libreboot to Canoeboot. If you're migrating from *factory
firmware* to Canoeboot, then you can also overwrite the IFD and GbE regions.

If you still want to modify the GbE region, when migrating from Libreboot, you
can, but you can do it manually; see [nvmutil documentation](nvmutil.md).

These rules *still apply* when re-flashing over an existing Canoeboot
installation, if the initial installation was *also* a migration from
Libreboot.

This is also true if switching to Canoeboot from vendor BIOS, but then
changing to Libreboot later on and migrating back to Canoeboot.

Libreboot shrinks the ME and GbE regions, and enlarges the BIOS region,
auto-downloading and inserting Intel ME at build time. By contrast, Canoeboot
cannot (by its policy) handle such files, so you leave the original Intel ME
firmware intact and only flash the other regions, but rely on the HAP bit in
the IFD to still disable Intel ME during early bringup.

More about this is covered in [another guide](ivy_has_common.md).
