---
title: Install Canoeboot on Dell OptiPlex 7010/9010 SFF
x-toc-enable: true
...

**This is only for the SFF variant. The MT variant is also supported, but for
the MT variant, you must flash the [T1650 ROM image](t1650.md) instead.**

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](ivy_has_common.md).**

<div class="specs">
<center>
<img tabindex=1 alt="Dell OptiPlex 7010 SFF" class="p" src="https://av.libreboot.org/7010sff/2.jpg" /><span class="f"><img src="https://av.libreboot.org/7010sff/2.jpg" /></span>
<img tabindex=1 alt="Dell OptiPlex 7010 SFF" class="p" src="https://av.libreboot.org/7010sff/4.jpg" /><span class="f"><img src="https://av.libreboot.org/7010sff/4.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | Dell                                           |
| **Name**                   | OptiPlex 7010 SFF                                |
| **Variants**               | OptiPlex 9010 SFF                                |
| **Released**               | 2012                                           |
| **Chipset**                | Intel C216                                     |
| **CPU**                    | Intel Ivy Bridge                               |
| **Graphics**               | Discrete graphics, or Intel HD Graphics model
                               depending on CPU model                         | 
| **Memory**                 | DDR3 DIMMs (max 32GB, 4x8GB)    |
| **Architecture**           | x86\_64                                         |
| **Original boot firmware** | Dell UEFI firmware                             |
| **Intel ME/AMD PSP**       | Present. Can be disabled via setting HAP bit.   |
| **Flash chip**             | SOIC-16 and/or SOIC-8 12MiB (96Mbit)           |


```
W+: Works without vendor firmware; 
N: Doesn't work; 
W*: Works with vendor firmware; 
U: Untested; 
P+: Partially works; 
P*: Partially works with vendor firmware
?: UNKNOWN AT THIS TIME
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | W+ |
| **Display (if Intel GPU)**                        | W+ |
| **Display (discrete GPU, SeaBIOS payload only)**  | W* |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |

| ***Payloads supported***   |           |
|----------------------------|-----------|
| **GRUB (libgfxinit only)** | Works     |
| **SeaBIOS**                | Works     |
| **SeaBIOS with GRUB**      | Works     |
</div>

Open source BIOS/UEFI firmware
------------------------------

This document will teach you how to install Canoeboot, on your
Dell OptiPlex 7010 SFF and/or OptiPlex 9010 SFF desktop motherboard.
Canoeboot is a [Free Software](https://writefreesoftware.org/learn) project
that replaces proprietary BIOS/UEFI firmware.

**Unavailable in Canoeboot 25.04 or earlier. You must [compile from
source](../build/), or use a version newer than Canoeboot 25.04.**

Official information about the computer can be found here:
<https://www.dell.com/support/manuals/en-uk/optiplex-7010-plus-small-ff/opti_7010_sff_plus_om/specifications-of-optiplex-small-form-factor-plus-7010?guid=guid-7c9f07ce-626e-44ca-be3a-a1fb036413f9&lang=en-us>

### Build ROM image from source

The build target, when building from source, is thus:

	./mk -b coreboot dell7010sff_12mb

NOTE: The same 7010 SFF image also works on 9010 SFF. It's the same motherboard.

Alternatively, you can use one of Canoeboot's pre-compiled release images.

Install Canoeboot
-----------------

Canoeboot can be installed via internal and/or external flashing methods.

### Avoid overwriting Intel ME

If you're installing Canoeboot, please ensure that you don't overwrite Intel ME;
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

Canoeboot's build system *does not* handle Intel ME, so the ME region is blank.
This differs from Libreboot, which auto-downloads and inserts Intel ME. Canoeboot
flashes around what's already there, setting only the HAP bit.

### Set MAC address

This platform uses an Intel Flash Descriptor, and defines an Intel GbE NVM
region. As such, release/build ROMs will contain the same MAC address. To
change the MAC address, please read [nvmutil documentation](../install/nvmutil.md).

### WARNING about CPU/GPU compatibility

If you want to use onboard graphics, you must have a CPU that has a GPU built
into it. You can find a list here:

<https://en.wikipedia.org/wiki/Ivy_Bridge_(microarchitecture)>

Coreboot has libre initialisation code for Intel graphics, but libre
initialisation code is not available for most graphics cards. This machine can
take any graphics card that fits in the PCI-E slot. When a graphics card is
used, SeaBIOS executes its VGA ROM which provides video init, instead of
coreboot's native Intel video init. GRUB piggybacks off of what SeaBIOS did,
so the GRUB payload will also work.

### Flash a ROM image (software)

**BEFORE FLASHING, and/or if migrating from Libreboot: Read the article
about [16KB GbE regions](dell_gbe.md).**

If you're already running Canoeboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

<img tabindex=1 alt="Dell OptiPlex 7010 SFF service mode jumper set" class="p" src="https://av.libreboot.org/7010sff/1.jpg" /><span class="f"><img src="https://av.libreboot.org/7010sff/1.jpg" /></span>
<img tabindex=1 alt="Insides of Dell Optiplex 7010 SFF" class="p" src="https://av.libreboot.org/7010sff/3.jpg" /><span class="f"><img src="https://av.libreboot.org/7010sff/3.jpg" /></span>

If you have factory firmware (Dell), you can short the service jumper. It's
near the RAM, under where the HDD goes (click the photos shown above).
Just put a short on it when booting,
and all flash protection is disabled; the factory firmware write might EFI
variables to flash during shutdown sequence, so you should *pull the plug* to
shut it down (remove the power by pulling the plug) after flashprog
says `VERIFIED`.

### Flash a ROM image (hardware)

**BEFORE FLASHING, and/or if migrating from Libreboot: Read the article
about [16KB GbE regions](dell_gbe.md).**

For general information, please refer to [25xx NOR flash
instructions](../install/spi.md) - that page refers to use of socketed flash.

This machine is somewhat cumbersome to flash, because it has a SOIC-16 flash
for the first 8MB part, and 4MB SOIC8. You can split up your 12MB ROM image
like so:

	dd if=canoeboot.rom of=4mb.rom bs=1M skip=8
	dd if=canoeboot.rom of=8mb.rom bs=1M count=8

**Please only flash the IFD and BIOS regions. The CBFS size is 4MB, so you can
just flash the 4MB image to handle the BIOS region, and then use the `--ifd`
option in flashprog to flash just the IFD region in the 8MB chip, for disabling
Intel ME by setting the IFD's HAP bit.**

The side cover comes off easily, and you can find the flash ICs next to the RAM.

No photos yet, but the two flash ICs are next to each other, and near to where
the PCH is.
