/*

MIT License

Copyright (c) 2021 PCSX-Redux authors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

*/

#include <stdint.h>

struct BuDirectoryEntry {
    uint32_t allocState;
    int32_t fileSize;
    int16_t nextBlock;
    char name[22];
};

extern struct BuDirectoryEntry g_buDirEntries[2][15];
extern uint8_t g_buBuffer[2][128];
extern int32_t g_buBroken[2][20];
extern int g_buOperation[2];
extern int g_buAutoFormat;

int buInit(int deviceId);
int buFormat(int deviceId);
int buWriteTOC(int deviceId, int* bitmap);
int buReallocateBrokenSectorAndRetry(int deviceId, int sector, char* buffer);
void buFinishAndTrigger(int port, int spec);
