# int

Emulates BIOS interrupts on Linux, using libx86. Prints registers EAX,
EBX, ECX, EDX, ES, EDI, DS, ESI, FS and GS. Only those that are non-zero
(either before or after) are printed.

## Usage

Depends on libx86. Run `make` to compile the tool. You have to have
booted the kernel with `iomem=relaxed`. You might have to run this
command once as well:

	mount -o remount,exec /dev

### Examples

	# ./int 15 -a 5f80 -b ff00
	Calling int15h
	         ax    bx   cl
	Before: 5f80  ff00  00
	After:  005f  ff30  03

	# ./int 15 -a 5f80 -b ff01 -c 30
	Calling int15h
	         ax    bx   cl   es
	Before: 5f80  ff01  30  0000
	After:  005f  ff01  30  ef2c

