--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE auditor_deposit_confirmations
(deposit_confirmation_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
    ,h_contract_terms BYTEA NOT NULL CHECK (LENGTH(h_contract_terms)=64)
    ,h_policy BYTEA NOT NULL CHECK (LENGTH(h_policy)=64)
    ,h_wire BYTEA NOT NULL CHECK (LENGTH(h_wire)=64)
    ,exchange_timestamp BIGINT NOT NULL
    ,refund_deadline BIGINT NOT NULL
    ,wire_deadline BIGINT NOT NULL
    ,total_without_fee taler_amount NOT NULL
    ,coin_pubs BYTEA[] NOT NULL CHECK (CARDINALITY(coin_pubs)>0)
    ,coin_sigs BYTEA[] NOT NULL CHECK (CARDINALITY(coin_sigs)=CARDINALITY(coin_pubs))
    ,merchant_pub BYTEA NOT NULL CHECK (LENGTH(merchant_pub)=32)
    ,exchange_sig BYTEA NOT NULL CHECK (LENGTH(exchange_sig)=64)
    ,exchange_pub BYTEA NOT NULL CHECK (LENGTH(exchange_pub)=32)
    ,master_sig BYTEA NOT NULL CHECK (LENGTH(master_sig)=64)
    ,suppressed BOOLEAN NOT NULL DEFAULT FALSE
    ,ancient BOOLEAN NOT NULL DEFAULT FALSE
    ,PRIMARY KEY (h_contract_terms,h_wire,merchant_pub,exchange_sig,exchange_pub,master_sig)
    );
COMMENT ON TABLE auditor_deposit_confirmations
  IS 'deposit confirmation sent to us by merchants; we must check that the exchange reported these properly.';

CREATE INDEX IF NOT EXISTS auditor_deposit_confirmations_not_ancient
    ON auditor_deposit_confirmations
    (exchange_timestamp ASC)
    WHERE NOT ancient;

CREATE OR REPLACE FUNCTION auditor_new_transactions_trigger()
    RETURNS trigger
    LANGUAGE plpgsql
AS $$
BEGIN
    NOTIFY XX81AFHF88YGN6ESNH39KR5VQE9MHD7GSSNMTCXB82SZ6T99ARHE0;
    RETURN NEW;
END $$;
COMMENT ON FUNCTION auditor_new_transactions_trigger()
    IS 'Call auditor_call_db_notify on new entry';

CREATE TRIGGER auditor_notify_helper_deposits
    AFTER INSERT
    ON auditor.auditor_deposit_confirmations
EXECUTE PROCEDURE auditor_new_transactions_trigger();
