/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2018 Intel Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef HDA_VERB_H
#define HDA_VERB_H

#include <device/azalia_device.h>

const u32 cim_verb_data[] = {
	/* ALC 700 */
	0x10EC0700,
	0xFFFFFFFF,
	0x00000023,

	AZALIA_SUBVENDOR(0, 0x10EC10F2),
	AZALIA_PIN_CFG(0, 0x01, 0x00000000),
	AZALIA_PIN_CFG(0, 0x12, 0x40000000),
	AZALIA_PIN_CFG(0, 0x13, 0x40000000),
	AZALIA_PIN_CFG(0, 0x14, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x15, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x16, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x17, 0x90170110),
	AZALIA_PIN_CFG(0, 0x18, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x19, 0x04A11030),
	AZALIA_PIN_CFG(0, 0x1A, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x1B, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x1D, 0x40622005),
	AZALIA_PIN_CFG(0, 0x1E, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x1F, 0x411111F0),
	AZALIA_PIN_CFG(0, 0x21, 0x04211020),
	AZALIA_PIN_CFG(0, 0x29, 0x411111F0),

	/* Widget node 0x20 */
	0x02050045,
	0x02045289,
	0x0205004A,
	0x0204201B,
	/* Widget node 0x20 - 1 */
	0x05850000,
	0x05843888,
	0x0205006F,
	0x02042C0B,

	//Widget node 0X20 for ALC1305   20160603 update
	0x02050024,
	0x02040010,
	0x02050026,
	0x02040000,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040004,
	0x02050028,
	0x02040600,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204003C,
	0x02050028,
	0x0204FFD0,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040080,
	0x02050028,
	0x02040080,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040080,
	0x02050028,
	0x02040880,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204003A,
	0x02050028,
	0x02040DFE,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006A,
	0x02050028,
	0x0204005D,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006C,
	0x02050028,
	0x02040442,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040005,
	0x02050028,
	0x02040880,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040006,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040008,
	0x02050028,
	0x0204B000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204002E,
	0x02050028,
	0x02040800,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006A,
	0x02050028,
	0x020400C3,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006C,
	0x02050028,
	0x0204D4A0,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006A,
	0x02050028,
	0x020400CC,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006C,
	0x02050028,
	0x0204400A,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006A,
	0x02050028,
	0x020400C1,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006C,
	0x02050028,
	0x02040320,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040039,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204003B,
	0x02050028,
	0x0204FFFF,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204003C,
	0x02050028,
	0x0204FC20,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204003A,
	0x02050028,
	0x02041DFE,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C0,
	0x02050028,
	0x020401FA,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C1,
	0x02050028,
	0x0204DE23,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C2,
	0x02050028,
	0x02041C00,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C3,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C4,
	0x02050028,
	0x02040200,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C5,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C6,
	0x02050028,
	0x020403F5,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C7,
	0x02050028,
	0x0204AF1B,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C8,
	0x02050028,
	0x02041E0A,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400C9,
	0x02050028,
	0x0204368E,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400CA,
	0x02050028,
	0x020401FA,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400CB,
	0x02050028,
	0x0204DE23,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400CC,
	0x02050028,
	0x02041C00,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400CD,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400CE,
	0x02050028,
	0x02040200,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400CF,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400D0,
	0x02050028,
	0x020403F5,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400D1,
	0x02050028,
	0x0204AF1B,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400D2,
	0x02050028,
	0x02041E0A,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x020400D3,
	0x02050028,
	0x0204368E,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040040,
	0x02050028,
	0x0204800F,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040062,
	0x02050028,
	0x02048000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040063,
	0x02050028,
	0x02044848,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040064,
	0x02050028,
	0x02040800,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040065,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040066,
	0x02050028,
	0x02044004,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040067,
	0x02050028,
	0x02040802,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040068,
	0x02050028,
	0x0204890F,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040069,
	0x02050028,
	0x0204E021,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040070,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040071,
	0x02050000,
	0x02043330,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040072,
	0x02050000,
	0x02043333,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040073,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040074,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040075,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040076,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040050,
	0x02050028,
	0x020402EC,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040051,
	0x02050028,
	0x02044909,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040052,
	0x02050028,
	0x020440B0,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040046,
	0x02050028,
	0x0204C22E,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040047,
	0x02050028,
	0x02040C00,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040048,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040049,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204004A,
	0x02050028,
	0x02040000,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204004B,
	0x02050028,
	0x02041C00,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006A,
	0x02050028,
	0x02040090,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204006C,
	0x02050028,
	0x0204721F,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x0204009E,
	0x02050028,
	0x02040001,
	0x02050029,
	0x0204B024,

	0x02050024,
	0x02040010,
	0x02050026,
	0x02040004,
	0x02050028,
	0x02040500,
	0x02050029,
	0x0204B024
};

const u32 pc_beep_verbs[] = {
};
AZALIA_ARRAY_SIZES;
#endif
