#!/bin/bash

blacklistfile=$1
videomodule=$2

if [[ -n $videomodule ]]
then
	cat >$blacklistfile <<EOF
# This file was created by initramfs
# Do not edit this file manually
# Please use cl-setup-video to select video driver

EOF
	case $videomodule in
		nouveau)
			echo "blacklist nvidia" >>$blacklistfile
			;;
		radeon)
			echo "blacklist amdgpu" >>$blacklistfile
			;;
		nvidia)
			echo "blacklist nouveau" >>$blacklistfile
			;;
		amdgpu)
			echo "blacklist radeon" >>$blacklistfile
			;;
	esac
else
	rm -f $blacklistfile
fi
