# -*- coding: utf-8 -*-

# Copyright 2008-2016 Mir Calculate. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import re
from ..cl_template import TemplateFormat


class objShare(TemplateFormat):
    """Общий класс для объектов, наследуем"""

    docObj = None
    reComment = None
    reSepFields = None
    sepFields = None

    def setDataField(self, txtLines, endtxtLines):
        raise NotImplemented()

    def createFieldTerm(self, name, value, quote, docObj):
        """Создание поля переменная - значение

        при создании поля проверяется первый символ названия переменной
        и добавляется тег action
        "!" - <action>drop</action> удаляет
        "+" - <action>join</action> добавляет
        "-" - <action>replace</action> заменяет
        """
        fieldAction = False
        if name:
            if name[0] == "!" or name[0] == "-" or name[0] == "+":
                qnt = self.removeSymbolTerm(quote)
                fieldXML = docObj.createField("var", [qnt], name[1:], [value], False, False)
                if name[0] == "!":
                    fieldAction = "drop"
                elif name[0] == "+":
                    fieldXML.set("type", "seplist")
                    fieldAction = "join"
            else:
                fieldXML = docObj.createField(
                    "var", [quote.replace("\n", "")], name, [value], False, False
                )
        else:
            fieldXML = docObj.createField(
                "var", [quote.replace("\n", "")], name, [value], False, False
            )
        if fieldAction:
            docObj.setActionField(fieldXML, fieldAction)
        return fieldXML

    def removeSymbolTerm(self, text):
        """Удаляет первый символ названия переменной в строке

        Если первый встречающийся символ с начала строки
        '+', '-', '!' то он из этой строки будет удален,
        если перед этим символом были пробельные символы,
        то они будут сохранены, так-же если в строке есть символ
        перевода строки он будет удален.
        """
        reTerm = re.compile("^[ \t]*(!|\+|\-)")
        textNS = text.replace("\n", "")
        res = reTerm.search(textNS)
        if res:
            textNS = textNS[res.start() : res.end() - 1] + textNS[res.end() :]
        return textNS

    def getConfig(self, joinChar=""):
        """Выдает конфигурационный файл"""
        listConfigTxt = []
        childNodes = list(self.docObj.getNodeBody())
        for node in childNodes:
            # if node.nodeType == node.ELEMENT_NODE:
            if node.tag == "field":
                listConfigTxt.append(self.docObj.getQuoteField(node))
            elif node.tag == "area":
                self.docObj.xmlToText([node], listConfigTxt)
        return "%s\n" % joinChar.join(listConfigTxt).rstrip("\n ")

    def splitToFields(self, txtBloc):
        """Разбиваем текст на поля (объекты) которые имеют следующие аттрибуты

        self.name  - если переменная то имя переменной
        self.value  - если у переменной есть значение то значение переменной
        self.comment - если комментарий то текст комментария
        self.br - если перевод строки то текст перед переводом из пробелов

        Результат список объектов полей
        """
        finBloc = "\n"
        if txtBloc[-1] != "\n":
            finBloc = ""

        linesBlocTmp = txtBloc.splitlines()
        linesBloc = []
        brBloc = []
        z = 0
        lenLines = len(linesBlocTmp)
        for i in linesBlocTmp:
            if self.reComment.split(i)[0]:
                findCooment = self.reComment.search(i)
                comment = False
                par = i
                if findCooment:
                    par = i[: findCooment.start()]
                    comment = i[findCooment.start() :]
                fields = self.reSepFields.split(par)
                lenFields = len(fields)

                if lenFields > 1:
                    for fi in range(lenFields - 1):
                        linesBloc.append(fields[fi] + self.sepFields)
                        if fi == lenFields - 2:
                            if comment:
                                brBloc.append("")
                            else:
                                if (lenLines - 1) == z:
                                    brBloc.append(finBloc)
                                else:
                                    brBloc.append("\n")
                        else:
                            brBloc.append("")
                    if comment:
                        linesBloc.append(comment)
                        if (lenLines - 1) == z:
                            brBloc.append(finBloc)
                        else:
                            brBloc.append("\n")
                else:
                    linesBloc.append(i)
                    if (lenLines - 1) == z:
                        brBloc.append(finBloc)
                    else:
                        brBloc.append("\n")
            else:
                linesBloc.append(i)
                if (lenLines - 1) == z:
                    brBloc.append(finBloc)
                else:
                    brBloc.append("\n")
            z += 1
        fields = self.setDataField(linesBloc, brBloc)
        return fields
