# -*- coding: utf-8 -*-

# Copyright 2008-2016 Mir Calculate. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import re
from .bind import bind


class dhcp(bind):
    """Класс для обработки конфигурационного файла типа dhcp"""

    _comment = "#"
    configName = "dhcp"
    configVersion = "0.1"
    __openArea = "{"
    __closeArea = "[ \t]*\}[ \t]*"
    sepFields = ";"
    reOpen = re.compile(__openArea)
    reClose = re.compile(__closeArea)
    reCloseArea = re.compile(__closeArea + "\s*\Z")
    reComment = re.compile("^[ \t]*%s" % _comment)
    reSepFields = re.compile(sepFields)
    reSeparator = re.compile("[ \t]+")

    def setDataField(self, txtLines, endtxtLines):
        """Создаем список объектов с переменными"""

        class fieldData:
            def __init__(self):
                self.name = False
                self.value = False
                self.comment = False
                self.br = False

        fields = []
        field = fieldData()
        z = 0
        for k in txtLines:
            textLine = k + endtxtLines[z]
            z += 1
            findComment = self.reComment.search(textLine)
            if not textLine.strip():
                field.br = textLine
                fields.append(field)
                field = fieldData()
            elif findComment:
                field.comment = textLine
                fields.append(field)
                field = fieldData()
            else:
                pars = textLine.strip()
                nameValue = self.reSeparator.split(pars)
                if len(nameValue) == 1:
                    field.name = textLine.replace(self.sepFields, "").strip()
                    field.value = ""
                    field.br = textLine
                    fields.append(field)
                    field = fieldData()

                if len(nameValue) > 2:
                    nameCheck = nameValue[0]
                    if nameValue[0][:1] in ["+", "-", "!"]:
                        nameCheck = nameValue[0][1:]
                    if nameCheck == "option" or nameCheck == "hardware" or nameCheck == "set":
                        valueList = nameValue[2:]
                        nameValue = [
                            nameValue[0] + nameValue[1],
                            " ".join(valueList).replace(self.sepFields, ""),
                        ]
                    else:
                        valueList = nameValue[1:]
                        nameValue = [nameValue[0], " ".join(valueList).replace(self.sepFields, "")]
                if len(nameValue) == 2:
                    name = nameValue[0]
                    value = nameValue[1].replace(self.sepFields, "")
                    field.name = name.replace(" ", "").replace("\t", "")
                    field.value = value
                    field.br = textLine
                    fields.append(field)
                    field = fieldData()
        return fields

    def join(self, dhcpObj):
        """Объединяем конфигурации"""
        if isinstance(dhcpObj, dhcp):
            self.docObj.joinDoc(dhcpObj.doc)
