; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -msan-check-access-address=0 -msan-track-origins=1 -S -passes='module(msan)' 2>&1 | FileCheck -allow-deprecated-dag-overlap --check-prefix=CHECK %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare i32 @llvm.vector.reduce.add(<3 x i32>)
declare i32 @llvm.vector.reduce.and(<3 x i32>)
declare i32 @llvm.vector.reduce.or(<3 x i32>)

define i32 @reduce_add() sanitize_memory {
; CHECK-LABEL: define i32 @reduce_add(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[P:%.*]] = inttoptr i64 0 to ptr
; CHECK-NEXT:    [[O:%.*]] = load <3 x i32>, ptr [[P]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 87960930222080
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = add i64 [[TMP2]], 17592186044416
; CHECK-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP4]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <3 x i32>, ptr [[TMP3]], align 16
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 16
; CHECK-NEXT:    [[TMP7:%.*]] = call i32 @llvm.vector.reduce.or.v3i32(<3 x i32> [[_MSLD]])
; CHECK-NEXT:    [[R:%.*]] = call i32 @llvm.vector.reduce.add.v3i32(<3 x i32> [[O]])
; CHECK-NEXT:    store i32 [[TMP7]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    store i32 [[TMP6]], ptr @__msan_retval_origin_tls, align 4
; CHECK-NEXT:    ret i32 [[R]]
;
  %p = inttoptr i64 0 to ptr
  %o = load <3 x i32>, ptr %p
  %r = call i32 @llvm.vector.reduce.add(<3 x i32> %o)
  ret i32 %r
}

define i32 @reduce_and() sanitize_memory {
; CHECK-LABEL: define i32 @reduce_and(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[P:%.*]] = inttoptr i64 0 to ptr
; CHECK-NEXT:    [[O:%.*]] = load <3 x i32>, ptr [[P]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 87960930222080
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = add i64 [[TMP2]], 17592186044416
; CHECK-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP4]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <3 x i32>, ptr [[TMP3]], align 16
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 16
; CHECK-NEXT:    [[TMP7:%.*]] = or <3 x i32> [[O]], [[_MSLD]]
; CHECK-NEXT:    [[TMP8:%.*]] = call i32 @llvm.vector.reduce.and.v3i32(<3 x i32> [[TMP7]])
; CHECK-NEXT:    [[TMP9:%.*]] = call i32 @llvm.vector.reduce.or.v3i32(<3 x i32> [[_MSLD]])
; CHECK-NEXT:    [[TMP10:%.*]] = and i32 [[TMP8]], [[TMP9]]
; CHECK-NEXT:    [[R:%.*]] = call i32 @llvm.vector.reduce.and.v3i32(<3 x i32> [[O]])
; CHECK-NEXT:    store i32 [[TMP10]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    store i32 [[TMP6]], ptr @__msan_retval_origin_tls, align 4
; CHECK-NEXT:    ret i32 [[R]]
;
  %p = inttoptr i64 0 to ptr
  %o = load <3 x i32>, ptr %p
  %r = call i32 @llvm.vector.reduce.and(<3 x i32> %o)
  ret i32 %r
}

define i32 @reduce_or() sanitize_memory {
; CHECK-LABEL: define i32 @reduce_or(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[P:%.*]] = inttoptr i64 0 to ptr
; CHECK-NEXT:    [[O:%.*]] = load <3 x i32>, ptr [[P]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 87960930222080
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = add i64 [[TMP2]], 17592186044416
; CHECK-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP4]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <3 x i32>, ptr [[TMP3]], align 16
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 16
; CHECK-NEXT:    [[TMP7:%.*]] = xor <3 x i32> [[O]], splat (i32 -1)
; CHECK-NEXT:    [[TMP8:%.*]] = or <3 x i32> [[TMP7]], [[_MSLD]]
; CHECK-NEXT:    [[TMP9:%.*]] = call i32 @llvm.vector.reduce.and.v3i32(<3 x i32> [[TMP8]])
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.vector.reduce.or.v3i32(<3 x i32> [[_MSLD]])
; CHECK-NEXT:    [[TMP11:%.*]] = and i32 [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[R:%.*]] = call i32 @llvm.vector.reduce.or.v3i32(<3 x i32> [[O]])
; CHECK-NEXT:    store i32 [[TMP11]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    store i32 [[TMP6]], ptr @__msan_retval_origin_tls, align 4
; CHECK-NEXT:    ret i32 [[R]]
;
  %p = inttoptr i64 0 to ptr
  %o = load <3 x i32>, ptr %p
  %r = call i32 @llvm.vector.reduce.or(<3 x i32> %o)
  ret i32 %r
}
