; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve,+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-LE
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-LE
; RUN: llc -mtriple=thumbebv8.1m.main-none-none-eabi -mattr=+mve.fp -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-BE

define arm_aapcs_vfpcc <4 x i32> @vdup_i32(i32 %src) {
; CHECK-LE-LABEL: vdup_i32:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_i32:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = insertelement <4 x i32> undef, i32 %src, i32 0
  %out = shufflevector <4 x i32> %0, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <8 x i16> @vdup_i16(i16 %src) {
; CHECK-LE-LABEL: vdup_i16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_i16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = insertelement <8 x i16> undef, i16 %src, i32 0
  %out = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> zeroinitializer
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <16 x i8> @vdup_i8(i8 %src) {
; CHECK-LE-LABEL: vdup_i8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vdup.8 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_i8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vdup.8 q1, r0
; CHECK-BE-NEXT:    vrev64.8 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = insertelement <16 x i8> undef, i8 %src, i32 0
  %out = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> zeroinitializer
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <2 x i64> @vdup_i64(i64 %src) {
; CHECK-LE-LABEL: vdup_i64:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov q0[2], q0[0], r0, r0
; CHECK-LE-NEXT:    vmov q0[3], q0[1], r1, r1
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_i64:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vmov q1[2], q1[0], r0, r0
; CHECK-BE-NEXT:    vmov q1[3], q1[1], r1, r1
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = insertelement <2 x i64> undef, i64 %src, i32 0
  %out = shufflevector <2 x i64> %0, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %out
}

define arm_aapcs_vfpcc <4 x float> @vdup_f32_1(float %src) {
; CHECK-LE-LABEL: vdup_f32_1:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov r0, s0
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_f32_1:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vmov r0, s0
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = insertelement <4 x float> undef, float %src, i32 0
  %out = shufflevector <4 x float> %0, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @vdup_f32_2(float %src1, float %src2) {
; CHECK-LE-LABEL: vdup_f32_2:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vadd.f32 s0, s0, s1
; CHECK-LE-NEXT:    vmov r0, s0
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_f32_2:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vadd.f32 s0, s0, s1
; CHECK-BE-NEXT:    vmov r0, s0
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = fadd float %src1, %src2
  %1 = insertelement <4 x float> undef, float %0, i32 0
  %out = shufflevector <4 x float> %1, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @vdup_f32_1bc(float %src) {
; CHECK-LE-LABEL: vdup_f32_1bc:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov r0, s0
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_f32_1bc:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vmov r0, s0
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %srcbc = bitcast float %src to i32
  %0 = insertelement <4 x i32> undef, i32 %srcbc, i32 0
  %out = shufflevector <4 x i32> %0, <4 x i32> undef, <4 x i32> zeroinitializer
  %outbc = bitcast <4 x i32> %out to <4 x float>
  ret <4 x float> %outbc
}

define arm_aapcs_vfpcc <4 x float> @vdup_f32_2bc(float %src1, float %src2) {
; CHECK-LE-LABEL: vdup_f32_2bc:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vadd.f32 s0, s0, s1
; CHECK-LE-NEXT:    vmov r0, s0
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_f32_2bc:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vadd.f32 s0, s0, s1
; CHECK-BE-NEXT:    vmov r0, s0
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = fadd float %src1, %src2
  %bc = bitcast float %0 to i32
  %1 = insertelement <4 x i32> undef, i32 %bc, i32 0
  %out = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> zeroinitializer
  %outbc = bitcast <4 x i32> %out to <4 x float>
  ret <4 x float> %outbc
}

define arm_aapcs_vfpcc <8 x half> @vdup_f16(half %0, half %1) {
; CHECK-LE-LABEL: vdup_f16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vadd.f16 s0, s0, s1
; CHECK-LE-NEXT:    vmov.f16 r0, s0
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_f16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vadd.f16 s0, s0, s1
; CHECK-BE-NEXT:    vmov.f16 r0, s0
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %2 = fadd half %0, %1
  %3 = insertelement <8 x half> undef, half %2, i32 0
  %out = shufflevector <8 x half> %3, <8 x half> undef, <8 x i32> zeroinitializer
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @vdup_f16_bc(half %0, half %1) {
; CHECK-LE-LABEL: vdup_f16_bc:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vadd.f16 s0, s0, s1
; CHECK-LE-NEXT:    vmov.f16 r0, s0
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vdup_f16_bc:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vadd.f16 s0, s0, s1
; CHECK-BE-NEXT:    vmov.f16 r0, s0
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %2 = fadd half %0, %1
  %bc = bitcast half %2 to i16
  %3 = insertelement <8 x i16> undef, i16 %bc, i32 0
  %out = shufflevector <8 x i16> %3, <8 x i16> undef, <8 x i32> zeroinitializer
  %outbc = bitcast <8 x i16> %out to <8 x half>
  ret <8 x half> %outbc
}

define arm_aapcs_vfpcc <2 x double> @vdup_f64(double %src) {
; CHECK-LABEL: vdup_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s2, s0
; CHECK-NEXT:    vmov.f32 s3, s1
; CHECK-NEXT:    bx lr
entry:
  %0 = insertelement <2 x double> undef, double %src, i32 0
  %out = shufflevector <2 x double> %0, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %out
}



define arm_aapcs_vfpcc <4 x i32> @vduplane_i32(<4 x i32> %src) {
; CHECK-LE-LABEL: vduplane_i32:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov r0, s3
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vduplane_i32:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmov r0, s7
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src, <4 x i32> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <8 x i16> @vduplane_i16(<8 x i16> %src) {
; CHECK-LE-LABEL: vduplane_i16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov.u16 r0, q0[3]
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vduplane_i16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q1[3]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src, <8 x i16> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <16 x i8> @vduplane_i8(<16 x i8> %src) {
; CHECK-LE-LABEL: vduplane_i8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov.u8 r0, q0[3]
; CHECK-LE-NEXT:    vdup.8 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vduplane_i8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.8 q1, q0
; CHECK-BE-NEXT:    vmov.u8 r0, q1[3]
; CHECK-BE-NEXT:    vdup.8 q1, r0
; CHECK-BE-NEXT:    vrev64.8 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <2 x i64> @vduplane_i64(<2 x i64> %src) {
; CHECK-LABEL: vduplane_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.f32 s1, s3
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src, <2 x i64> undef, <2 x i32> <i32 1, i32 1>
  ret <2 x i64> %out
}

define arm_aapcs_vfpcc <4 x float> @vduplane_f32(<4 x float> %src) {
; CHECK-LE-LABEL: vduplane_f32:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov r0, s3
; CHECK-LE-NEXT:    vdup.32 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vduplane_f32:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmov r0, s7
; CHECK-BE-NEXT:    vdup.32 q1, r0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <8 x half> @vduplane_f16(<8 x half> %src) {
; CHECK-LE-LABEL: vduplane_f16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmov.u16 r0, q0[3]
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: vduplane_f16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q1[3]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src, <8 x half> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <2 x double> @vduplane_f64(<2 x double> %src) {
; CHECK-LABEL: vduplane_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.f32 s1, s3
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src, <2 x double> undef, <2 x i32> <i32 1, i32 1>
  ret <2 x double> %out
}


define arm_aapcs_vfpcc float @vdup_f32_extract(float %src) {
; CHECK-LABEL: vdup_f32_extract:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %srcbc = bitcast float %src to i32
  %0 = insertelement <4 x i32> undef, i32 %srcbc, i32 0
  %out = shufflevector <4 x i32> %0, <4 x i32> undef, <4 x i32> zeroinitializer
  %outbc = bitcast <4 x i32> %out to <4 x float>
  %ext = extractelement <4 x float> %outbc, i32 2
  ret float %ext
}

define arm_aapcs_vfpcc half @vdup_f16_extract(half %0, half %1) {
; CHECK-LABEL: vdup_f16_extract:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vadd.f16 s0, s0, s1
; CHECK-NEXT:    bx lr
entry:
  %2 = fadd half %0, %1
  %bc = bitcast half %2 to i16
  %3 = insertelement <8 x i16> undef, i16 %bc, i32 0
  %out = shufflevector <8 x i16> %3, <8 x i16> undef, <8 x i32> zeroinitializer
  %outbc = bitcast <8 x i16> %out to <8 x half>
  %ext = extractelement <8 x half> %outbc, i32 2
  ret half %ext
}


define arm_aapcs_vfpcc <8 x i16> @bitcast_i64_v8i16(i64 %a) {
; CHECK-LE-LABEL: bitcast_i64_v8i16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    .pad #8
; CHECK-LE-NEXT:    sub sp, #8
; CHECK-LE-NEXT:    str r0, [sp]
; CHECK-LE-NEXT:    mov r0, sp
; CHECK-LE-NEXT:    vldrh.u32 q0, [r0]
; CHECK-LE-NEXT:    vmov r0, s0
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    add sp, #8
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_i64_v8i16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    .pad #8
; CHECK-BE-NEXT:    sub sp, #8
; CHECK-BE-NEXT:    strd r0, r1, [sp]
; CHECK-BE-NEXT:    mov r0, sp
; CHECK-BE-NEXT:    vldrh.u32 q0, [r0]
; CHECK-BE-NEXT:    vmov r0, s0
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    add sp, #8
; CHECK-BE-NEXT:    bx lr
  %b = bitcast i64 %a to <4 x i16>
  %r = shufflevector <4 x i16> %b, <4 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x i16> @bitcast_i128_v8i16(i128 %a) {
; CHECK-LE-LABEL: bitcast_i128_v8i16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_i128_v8i16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov.32 q0[0], r0
; CHECK-BE-NEXT:    vrev32.16 q0, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q0[0]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
  %b = bitcast i128 %a to <8 x i16>
  %r = shufflevector <8 x i16> %b, <8 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x i16> @bitcast_i64_v8i16_lane1(i64 %a) {
; CHECK-LE-LABEL: bitcast_i64_v8i16_lane1:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    .pad #8
; CHECK-LE-NEXT:    sub sp, #8
; CHECK-LE-NEXT:    str r0, [sp]
; CHECK-LE-NEXT:    mov r0, sp
; CHECK-LE-NEXT:    vldrh.u32 q0, [r0]
; CHECK-LE-NEXT:    vmov r0, s1
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    add sp, #8
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_i64_v8i16_lane1:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    .pad #8
; CHECK-BE-NEXT:    sub sp, #8
; CHECK-BE-NEXT:    strd r0, r1, [sp]
; CHECK-BE-NEXT:    mov r0, sp
; CHECK-BE-NEXT:    vldrh.u32 q0, [r0]
; CHECK-BE-NEXT:    vmov r0, s1
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    add sp, #8
; CHECK-BE-NEXT:    bx lr
  %b = bitcast i64 %a to <4 x i16>
  %r = shufflevector <4 x i16> %b, <4 x i16> poison, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x i16> @bitcast_f64_v8i16(double %a) {
; CHECK-LE-LABEL: bitcast_f64_v8i16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vmov.u16 r0, q0[0]
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_f64_v8i16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q1[0]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
  %b = bitcast double %a to <4 x i16>
  %r = shufflevector <4 x i16> %b, <4 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x half> @bitcast_i64_v8f16(i64 %a) {
; CHECK-LE-LABEL: bitcast_i64_v8f16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vmov.32 q0[0], r0
; CHECK-LE-NEXT:    vmov.u16 r0, q0[0]
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_i64_v8f16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov.32 q0[0], r0
; CHECK-BE-NEXT:    vrev32.16 q0, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q0[0]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
  %b = bitcast i64 %a to <4 x half>
  %r = shufflevector <4 x half> %b, <4 x half> poison, <8 x i32> zeroinitializer
  ret <8 x half> %r
}

define arm_aapcs_vfpcc <2 x i64> @bitcast_i64_v2f64(i64 %a) {
; CHECK-LE-LABEL: bitcast_i64_v2f64:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vmov q0[2], q0[0], r0, r0
; CHECK-LE-NEXT:    vmov q0[3], q0[1], r1, r1
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_i64_v2f64:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov q1[2], q1[0], r0, r0
; CHECK-BE-NEXT:    vmov q1[3], q1[1], r1, r1
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
  %b = bitcast i64 %a to <1 x i64>
  %r = shufflevector <1 x i64> %b, <1 x i64> poison, <2 x i32> zeroinitializer
  ret <2 x i64> %r
}

define arm_aapcs_vfpcc <2 x i64> @bitcast_v2f64_v2i64(<2 x double> %a) {
; CHECK-LABEL: bitcast_v2f64_v2i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s2, s0
; CHECK-NEXT:    vmov.f32 s3, s1
; CHECK-NEXT:    bx lr
  %b = bitcast <2 x double> %a to <2 x i64>
  %r = shufflevector <2 x i64> %b, <2 x i64> poison, <2 x i32> zeroinitializer
  ret <2 x i64> %r
}

define arm_aapcs_vfpcc <2 x i64> @bitcast_v8i16_v2i64(<8 x i16> %a) {
; CHECK-LABEL: bitcast_v8i16_v2i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s2, s0
; CHECK-NEXT:    vmov.f32 s3, s1
; CHECK-NEXT:    bx lr
  %b = bitcast <8 x i16> %a to <2 x i64>
  %r = shufflevector <2 x i64> %b, <2 x i64> poison, <2 x i32> zeroinitializer
  ret <2 x i64> %r
}

define arm_aapcs_vfpcc <8 x i16> @bitcast_v2f64_v8i16(<2 x i64> %a) {
; CHECK-LE-LABEL: bitcast_v2f64_v8i16:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vmov.u16 r0, q0[0]
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: bitcast_v2f64_v8i16:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q1[0]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
  %b = bitcast <2 x i64> %a to <8 x i16>
  %r = shufflevector <8 x i16> %b, <8 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x i16> @other_max_case(i32 %blockSize) {
; CHECK-LE-LABEL: other_max_case:
; CHECK-LE:       @ %bb.0:
; CHECK-LE-NEXT:    vdup.16 q0, r0
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: other_max_case:
; CHECK-BE:       @ %bb.0:
; CHECK-BE-NEXT:    vmov.32 q0[0], r0
; CHECK-BE-NEXT:    vrev32.16 q0, q0
; CHECK-BE-NEXT:    vmov.u16 r0, q0[0]
; CHECK-BE-NEXT:    vdup.16 q1, r0
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
  %vec.blockSize = bitcast i32 %blockSize to <2 x i16>
  %.splat2 = shufflevector <2 x i16> %vec.blockSize, <2 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %.splat2
}
