; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint -o - %s \
; RUN:   -verify-machineinstrs | FileCheck --check-prefix=QCI %s

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint,+save-restore \
; RUN:   -o - %s -verify-machineinstrs \
; RUN:   | FileCheck --check-prefix=QCI %s

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint -o - %s \
; RUN:   -verify-machineinstrs -frame-pointer=all | FileCheck --check-prefix=QCI-FP %s

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint,+zcmp \
; RUN:   -o - %s -verify-machineinstrs \
; RUN:   | FileCheck --check-prefix=QCI-PUSH-POP %s

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint,+experimental-xqccmp \
; RUN:   -o - %s -verify-machineinstrs \
; RUN:   | FileCheck --check-prefix=QCI-QCCMP-PUSH-POP %s

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint,+experimental-xqccmp \
; RUN:   -o - %s -verify-machineinstrs  -frame-pointer=all \
; RUN:   | FileCheck --check-prefix=QCI-QCCMP-PUSH-POP-FP %s

;; This tests "interrupt"="qci-nest" and "interrupt"="qci-nonest" frame lowering.
;; including CFI information. These tests should all lack `nounwind`.
;;
;; When `+save-restore` is enabled, the codegen should be identical as these
;; calls are incompatible with the interrupt attribute because the restore is
;; tail-called.

define void @test_nest_empty() "interrupt"="qci-nest" {
; QCI-LABEL: test_nest_empty:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nest_empty:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nest_empty:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nest_empty:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nest_empty:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  ret void
}

define void @test_nonest_empty() "interrupt"="qci-nonest" {
; QCI-LABEL: test_nonest_empty:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nonest_empty:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nonest_empty:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nonest_empty:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nonest_empty:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  ret void
}


declare void @use_i32(i32)

define void @test_nest_asm() "interrupt"="qci-nest" {
; QCI-LABEL: test_nest_asm:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    li a0, 1
; QCI-NEXT:    #APP
; QCI-NEXT:    # a0 <- a0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    call use_i32
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nest_asm:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    li a0, 1
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    # a0 <- a0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    call use_i32
; QCI-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nest_asm:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    li a0, 1
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    # a0 <- a0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    call use_i32
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nest_asm:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 1
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    # a0 <- a0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    call use_i32
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nest_asm:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    # a0 <- a0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call use_i32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = call i32 asm sideeffect "/* $0 <- $1 */", "=r,r"(i32 1)
  call void @use_i32(i32 %1)
  ret void
}

define void @test_nonest_asm() "interrupt"="qci-nonest" {
; QCI-LABEL: test_nonest_asm:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    li a0, 1
; QCI-NEXT:    #APP
; QCI-NEXT:    # a0 <- a0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    call use_i32
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nonest_asm:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    li a0, 1
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    # a0 <- a0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    call use_i32
; QCI-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nonest_asm:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    li a0, 1
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    # a0 <- a0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    call use_i32
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nonest_asm:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 1
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    # a0 <- a0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    call use_i32
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nonest_asm:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    # a0 <- a0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call use_i32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = call i32 asm sideeffect "/* $0 <- $1 */", "=r,r"(i32 1)
  call void @use_i32(i32 %1)
  ret void
}

declare i64 @function_with_one_stack_arg(i64, i64, i64, i64, i32)
declare void @use_i64(i64)

define void @test_nest_call() "interrupt"="qci-nest" {
; QCI-LABEL: test_nest_call:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -16
; QCI-NEXT:    .cfi_def_cfa_offset 112
; QCI-NEXT:    li a0, 4
; QCI-NEXT:    li a2, 1
; QCI-NEXT:    li a4, 2
; QCI-NEXT:    li a6, 3
; QCI-NEXT:    sw a0, 0(sp)
; QCI-NEXT:    li a0, 0
; QCI-NEXT:    li a1, 0
; QCI-NEXT:    li a3, 0
; QCI-NEXT:    li a5, 0
; QCI-NEXT:    li a7, 0
; QCI-NEXT:    call function_with_one_stack_arg
; QCI-NEXT:    call use_i64
; QCI-NEXT:    addi sp, sp, 16
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nest_call:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    li a0, 4
; QCI-FP-NEXT:    li a2, 1
; QCI-FP-NEXT:    li a4, 2
; QCI-FP-NEXT:    li a6, 3
; QCI-FP-NEXT:    sw a0, 0(sp)
; QCI-FP-NEXT:    li a0, 0
; QCI-FP-NEXT:    li a1, 0
; QCI-FP-NEXT:    li a3, 0
; QCI-FP-NEXT:    li a5, 0
; QCI-FP-NEXT:    li a7, 0
; QCI-FP-NEXT:    call function_with_one_stack_arg
; QCI-FP-NEXT:    call use_i64
; QCI-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-FP-NEXT:    addi sp, sp, 16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nest_call:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    addi sp, sp, -16
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-PUSH-POP-NEXT:    li a0, 4
; QCI-PUSH-POP-NEXT:    li a2, 1
; QCI-PUSH-POP-NEXT:    li a4, 2
; QCI-PUSH-POP-NEXT:    li a6, 3
; QCI-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-PUSH-POP-NEXT:    li a0, 0
; QCI-PUSH-POP-NEXT:    li a1, 0
; QCI-PUSH-POP-NEXT:    li a3, 0
; QCI-PUSH-POP-NEXT:    li a5, 0
; QCI-PUSH-POP-NEXT:    li a7, 0
; QCI-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-PUSH-POP-NEXT:    call use_i64
; QCI-PUSH-POP-NEXT:    addi sp, sp, 16
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nest_call:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, 16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nest_call:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, 16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = call i64 @function_with_one_stack_arg(i64 0, i64 1, i64 2, i64 3, i32 4)
  call void @use_i64(i64 %1)
  ret void
}

define void @test_nonest_call() "interrupt"="qci-nonest" {
; QCI-LABEL: test_nonest_call:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -16
; QCI-NEXT:    .cfi_def_cfa_offset 112
; QCI-NEXT:    li a0, 4
; QCI-NEXT:    li a2, 1
; QCI-NEXT:    li a4, 2
; QCI-NEXT:    li a6, 3
; QCI-NEXT:    sw a0, 0(sp)
; QCI-NEXT:    li a0, 0
; QCI-NEXT:    li a1, 0
; QCI-NEXT:    li a3, 0
; QCI-NEXT:    li a5, 0
; QCI-NEXT:    li a7, 0
; QCI-NEXT:    call function_with_one_stack_arg
; QCI-NEXT:    call use_i64
; QCI-NEXT:    addi sp, sp, 16
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nonest_call:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    li a0, 4
; QCI-FP-NEXT:    li a2, 1
; QCI-FP-NEXT:    li a4, 2
; QCI-FP-NEXT:    li a6, 3
; QCI-FP-NEXT:    sw a0, 0(sp)
; QCI-FP-NEXT:    li a0, 0
; QCI-FP-NEXT:    li a1, 0
; QCI-FP-NEXT:    li a3, 0
; QCI-FP-NEXT:    li a5, 0
; QCI-FP-NEXT:    li a7, 0
; QCI-FP-NEXT:    call function_with_one_stack_arg
; QCI-FP-NEXT:    call use_i64
; QCI-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-FP-NEXT:    addi sp, sp, 16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nonest_call:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    addi sp, sp, -16
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-PUSH-POP-NEXT:    li a0, 4
; QCI-PUSH-POP-NEXT:    li a2, 1
; QCI-PUSH-POP-NEXT:    li a4, 2
; QCI-PUSH-POP-NEXT:    li a6, 3
; QCI-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-PUSH-POP-NEXT:    li a0, 0
; QCI-PUSH-POP-NEXT:    li a1, 0
; QCI-PUSH-POP-NEXT:    li a3, 0
; QCI-PUSH-POP-NEXT:    li a5, 0
; QCI-PUSH-POP-NEXT:    li a7, 0
; QCI-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-PUSH-POP-NEXT:    call use_i64
; QCI-PUSH-POP-NEXT:    addi sp, sp, 16
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nonest_call:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, 16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nonest_call:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, 16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = call i64 @function_with_one_stack_arg(i64 0, i64 1, i64 2, i64 3, i32 4)
  call void @use_i64(i64 %1)
  ret void
}

@var = global [32 x i32] zeroinitializer

define void @test_spill_nest() "interrupt"="qci-nest" {
; QCI-LABEL: test_spill_nest:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -80
; QCI-NEXT:    .cfi_def_cfa_offset 176
; QCI-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s1, -100
; QCI-NEXT:    .cfi_offset s2, -104
; QCI-NEXT:    .cfi_offset s3, -108
; QCI-NEXT:    .cfi_offset s4, -112
; QCI-NEXT:    .cfi_offset s5, -116
; QCI-NEXT:    .cfi_offset s6, -120
; QCI-NEXT:    .cfi_offset s7, -124
; QCI-NEXT:    .cfi_offset s8, -128
; QCI-NEXT:    .cfi_offset s9, -132
; QCI-NEXT:    .cfi_offset s10, -136
; QCI-NEXT:    .cfi_offset s11, -140
; QCI-NEXT:    lui t0, %hi(var)
; QCI-NEXT:    lw a0, %lo(var)(t0)
; QCI-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-NEXT:    addi a5, t0, %lo(var)
; QCI-NEXT:    lw a0, 16(a5)
; QCI-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 20(a5)
; QCI-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw t4, 24(a5)
; QCI-NEXT:    lw t5, 28(a5)
; QCI-NEXT:    lw t6, 32(a5)
; QCI-NEXT:    lw s2, 36(a5)
; QCI-NEXT:    lw s3, 40(a5)
; QCI-NEXT:    lw s4, 44(a5)
; QCI-NEXT:    lw s5, 48(a5)
; QCI-NEXT:    lw s6, 52(a5)
; QCI-NEXT:    lw s7, 56(a5)
; QCI-NEXT:    lw s8, 60(a5)
; QCI-NEXT:    lw s9, 64(a5)
; QCI-NEXT:    lw s10, 68(a5)
; QCI-NEXT:    lw s11, 72(a5)
; QCI-NEXT:    lw ra, 76(a5)
; QCI-NEXT:    lw s1, 80(a5)
; QCI-NEXT:    lw t3, 84(a5)
; QCI-NEXT:    lw t2, 88(a5)
; QCI-NEXT:    lw t1, 92(a5)
; QCI-NEXT:    lw a7, 112(a5)
; QCI-NEXT:    lw s0, 116(a5)
; QCI-NEXT:    lw a3, 120(a5)
; QCI-NEXT:    lw a0, 124(a5)
; QCI-NEXT:    lw a6, 96(a5)
; QCI-NEXT:    lw a4, 100(a5)
; QCI-NEXT:    lw a2, 104(a5)
; QCI-NEXT:    lw a1, 108(a5)
; QCI-NEXT:    sw a0, 124(a5)
; QCI-NEXT:    sw a3, 120(a5)
; QCI-NEXT:    sw s0, 116(a5)
; QCI-NEXT:    sw a7, 112(a5)
; QCI-NEXT:    sw a1, 108(a5)
; QCI-NEXT:    sw a2, 104(a5)
; QCI-NEXT:    sw a4, 100(a5)
; QCI-NEXT:    sw a6, 96(a5)
; QCI-NEXT:    sw t1, 92(a5)
; QCI-NEXT:    sw t2, 88(a5)
; QCI-NEXT:    sw t3, 84(a5)
; QCI-NEXT:    sw s1, 80(a5)
; QCI-NEXT:    sw ra, 76(a5)
; QCI-NEXT:    sw s11, 72(a5)
; QCI-NEXT:    sw s10, 68(a5)
; QCI-NEXT:    sw s9, 64(a5)
; QCI-NEXT:    sw s8, 60(a5)
; QCI-NEXT:    sw s7, 56(a5)
; QCI-NEXT:    sw s6, 52(a5)
; QCI-NEXT:    sw s5, 48(a5)
; QCI-NEXT:    sw s4, 44(a5)
; QCI-NEXT:    sw s3, 40(a5)
; QCI-NEXT:    sw s2, 36(a5)
; QCI-NEXT:    sw t6, 32(a5)
; QCI-NEXT:    sw t5, 28(a5)
; QCI-NEXT:    sw t4, 24(a5)
; QCI-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 20(a5)
; QCI-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 16(a5)
; QCI-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var)(t0)
; QCI-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s1
; QCI-NEXT:    .cfi_restore s2
; QCI-NEXT:    .cfi_restore s3
; QCI-NEXT:    .cfi_restore s4
; QCI-NEXT:    .cfi_restore s5
; QCI-NEXT:    .cfi_restore s6
; QCI-NEXT:    .cfi_restore s7
; QCI-NEXT:    .cfi_restore s8
; QCI-NEXT:    .cfi_restore s9
; QCI-NEXT:    .cfi_restore s10
; QCI-NEXT:    .cfi_restore s11
; QCI-NEXT:    addi sp, sp, 80
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_spill_nest:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -80
; QCI-FP-NEXT:    .cfi_def_cfa_offset 176
; QCI-FP-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s1, -100
; QCI-FP-NEXT:    .cfi_offset s2, -104
; QCI-FP-NEXT:    .cfi_offset s3, -108
; QCI-FP-NEXT:    .cfi_offset s4, -112
; QCI-FP-NEXT:    .cfi_offset s5, -116
; QCI-FP-NEXT:    .cfi_offset s6, -120
; QCI-FP-NEXT:    .cfi_offset s7, -124
; QCI-FP-NEXT:    .cfi_offset s8, -128
; QCI-FP-NEXT:    .cfi_offset s9, -132
; QCI-FP-NEXT:    .cfi_offset s10, -136
; QCI-FP-NEXT:    .cfi_offset s11, -140
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    lui t1, %hi(var)
; QCI-FP-NEXT:    lw a0, %lo(var)(t1)
; QCI-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+4)(t1)
; QCI-FP-NEXT:    sw a0, -148(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+8)(t1)
; QCI-FP-NEXT:    sw a0, -152(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+12)(t1)
; QCI-FP-NEXT:    sw a0, -156(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    addi a5, t1, %lo(var)
; QCI-FP-NEXT:    lw a0, 16(a5)
; QCI-FP-NEXT:    sw a0, -160(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 20(a5)
; QCI-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 24(a5)
; QCI-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw t5, 28(a5)
; QCI-FP-NEXT:    lw t6, 32(a5)
; QCI-FP-NEXT:    lw s2, 36(a5)
; QCI-FP-NEXT:    lw s3, 40(a5)
; QCI-FP-NEXT:    lw s4, 44(a5)
; QCI-FP-NEXT:    lw s5, 48(a5)
; QCI-FP-NEXT:    lw s6, 52(a5)
; QCI-FP-NEXT:    lw s7, 56(a5)
; QCI-FP-NEXT:    lw s8, 60(a5)
; QCI-FP-NEXT:    lw s9, 64(a5)
; QCI-FP-NEXT:    lw s10, 68(a5)
; QCI-FP-NEXT:    lw s11, 72(a5)
; QCI-FP-NEXT:    lw ra, 76(a5)
; QCI-FP-NEXT:    lw t4, 80(a5)
; QCI-FP-NEXT:    lw t3, 84(a5)
; QCI-FP-NEXT:    lw t2, 88(a5)
; QCI-FP-NEXT:    lw s1, 92(a5)
; QCI-FP-NEXT:    lw t0, 112(a5)
; QCI-FP-NEXT:    lw a4, 116(a5)
; QCI-FP-NEXT:    lw a3, 120(a5)
; QCI-FP-NEXT:    lw a0, 124(a5)
; QCI-FP-NEXT:    lw a7, 96(a5)
; QCI-FP-NEXT:    lw a6, 100(a5)
; QCI-FP-NEXT:    lw a2, 104(a5)
; QCI-FP-NEXT:    lw a1, 108(a5)
; QCI-FP-NEXT:    sw a0, 124(a5)
; QCI-FP-NEXT:    sw a3, 120(a5)
; QCI-FP-NEXT:    sw a4, 116(a5)
; QCI-FP-NEXT:    sw t0, 112(a5)
; QCI-FP-NEXT:    sw a1, 108(a5)
; QCI-FP-NEXT:    sw a2, 104(a5)
; QCI-FP-NEXT:    sw a6, 100(a5)
; QCI-FP-NEXT:    sw a7, 96(a5)
; QCI-FP-NEXT:    sw s1, 92(a5)
; QCI-FP-NEXT:    sw t2, 88(a5)
; QCI-FP-NEXT:    sw t3, 84(a5)
; QCI-FP-NEXT:    sw t4, 80(a5)
; QCI-FP-NEXT:    sw ra, 76(a5)
; QCI-FP-NEXT:    sw s11, 72(a5)
; QCI-FP-NEXT:    sw s10, 68(a5)
; QCI-FP-NEXT:    sw s9, 64(a5)
; QCI-FP-NEXT:    sw s8, 60(a5)
; QCI-FP-NEXT:    sw s7, 56(a5)
; QCI-FP-NEXT:    sw s6, 52(a5)
; QCI-FP-NEXT:    sw s5, 48(a5)
; QCI-FP-NEXT:    sw s4, 44(a5)
; QCI-FP-NEXT:    sw s3, 40(a5)
; QCI-FP-NEXT:    sw s2, 36(a5)
; QCI-FP-NEXT:    sw t6, 32(a5)
; QCI-FP-NEXT:    sw t5, 28(a5)
; QCI-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 24(a5)
; QCI-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 20(a5)
; QCI-FP-NEXT:    lw a0, -160(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 16(a5)
; QCI-FP-NEXT:    lw a0, -156(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+12)(t1)
; QCI-FP-NEXT:    lw a0, -152(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+8)(t1)
; QCI-FP-NEXT:    lw a0, -148(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+4)(t1)
; QCI-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var)(t1)
; QCI-FP-NEXT:    .cfi_def_cfa sp, 176
; QCI-FP-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s1
; QCI-FP-NEXT:    .cfi_restore s2
; QCI-FP-NEXT:    .cfi_restore s3
; QCI-FP-NEXT:    .cfi_restore s4
; QCI-FP-NEXT:    .cfi_restore s5
; QCI-FP-NEXT:    .cfi_restore s6
; QCI-FP-NEXT:    .cfi_restore s7
; QCI-FP-NEXT:    .cfi_restore s8
; QCI-FP-NEXT:    .cfi_restore s9
; QCI-FP-NEXT:    .cfi_restore s10
; QCI-FP-NEXT:    .cfi_restore s11
; QCI-FP-NEXT:    addi sp, sp, 80
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_spill_nest:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s11}, -96
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 192
; QCI-PUSH-POP-NEXT:    .cfi_offset s1, -140
; QCI-PUSH-POP-NEXT:    .cfi_offset s2, -136
; QCI-PUSH-POP-NEXT:    .cfi_offset s3, -132
; QCI-PUSH-POP-NEXT:    .cfi_offset s4, -128
; QCI-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-PUSH-POP-NEXT:    .cfi_offset s6, -120
; QCI-PUSH-POP-NEXT:    .cfi_offset s7, -116
; QCI-PUSH-POP-NEXT:    .cfi_offset s8, -112
; QCI-PUSH-POP-NEXT:    .cfi_offset s9, -108
; QCI-PUSH-POP-NEXT:    .cfi_offset s10, -104
; QCI-PUSH-POP-NEXT:    .cfi_offset s11, -100
; QCI-PUSH-POP-NEXT:    lui t0, %hi(var)
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    addi a5, t0, %lo(var)
; QCI-PUSH-POP-NEXT:    lw a0, 16(a5)
; QCI-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 20(a5)
; QCI-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw t4, 24(a5)
; QCI-PUSH-POP-NEXT:    lw t5, 28(a5)
; QCI-PUSH-POP-NEXT:    lw t6, 32(a5)
; QCI-PUSH-POP-NEXT:    lw s2, 36(a5)
; QCI-PUSH-POP-NEXT:    lw s3, 40(a5)
; QCI-PUSH-POP-NEXT:    lw s4, 44(a5)
; QCI-PUSH-POP-NEXT:    lw s5, 48(a5)
; QCI-PUSH-POP-NEXT:    lw s6, 52(a5)
; QCI-PUSH-POP-NEXT:    lw s7, 56(a5)
; QCI-PUSH-POP-NEXT:    lw s8, 60(a5)
; QCI-PUSH-POP-NEXT:    lw s9, 64(a5)
; QCI-PUSH-POP-NEXT:    lw s10, 68(a5)
; QCI-PUSH-POP-NEXT:    lw s11, 72(a5)
; QCI-PUSH-POP-NEXT:    lw ra, 76(a5)
; QCI-PUSH-POP-NEXT:    lw s1, 80(a5)
; QCI-PUSH-POP-NEXT:    lw t3, 84(a5)
; QCI-PUSH-POP-NEXT:    lw t2, 88(a5)
; QCI-PUSH-POP-NEXT:    lw t1, 92(a5)
; QCI-PUSH-POP-NEXT:    lw a7, 112(a5)
; QCI-PUSH-POP-NEXT:    lw s0, 116(a5)
; QCI-PUSH-POP-NEXT:    lw a3, 120(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 124(a5)
; QCI-PUSH-POP-NEXT:    lw a6, 96(a5)
; QCI-PUSH-POP-NEXT:    lw a4, 100(a5)
; QCI-PUSH-POP-NEXT:    lw a2, 104(a5)
; QCI-PUSH-POP-NEXT:    lw a1, 108(a5)
; QCI-PUSH-POP-NEXT:    sw a0, 124(a5)
; QCI-PUSH-POP-NEXT:    sw a3, 120(a5)
; QCI-PUSH-POP-NEXT:    sw s0, 116(a5)
; QCI-PUSH-POP-NEXT:    sw a7, 112(a5)
; QCI-PUSH-POP-NEXT:    sw a1, 108(a5)
; QCI-PUSH-POP-NEXT:    sw a2, 104(a5)
; QCI-PUSH-POP-NEXT:    sw a4, 100(a5)
; QCI-PUSH-POP-NEXT:    sw a6, 96(a5)
; QCI-PUSH-POP-NEXT:    sw t1, 92(a5)
; QCI-PUSH-POP-NEXT:    sw t2, 88(a5)
; QCI-PUSH-POP-NEXT:    sw t3, 84(a5)
; QCI-PUSH-POP-NEXT:    sw s1, 80(a5)
; QCI-PUSH-POP-NEXT:    sw ra, 76(a5)
; QCI-PUSH-POP-NEXT:    sw s11, 72(a5)
; QCI-PUSH-POP-NEXT:    sw s10, 68(a5)
; QCI-PUSH-POP-NEXT:    sw s9, 64(a5)
; QCI-PUSH-POP-NEXT:    sw s8, 60(a5)
; QCI-PUSH-POP-NEXT:    sw s7, 56(a5)
; QCI-PUSH-POP-NEXT:    sw s6, 52(a5)
; QCI-PUSH-POP-NEXT:    sw s5, 48(a5)
; QCI-PUSH-POP-NEXT:    sw s4, 44(a5)
; QCI-PUSH-POP-NEXT:    sw s3, 40(a5)
; QCI-PUSH-POP-NEXT:    sw s2, 36(a5)
; QCI-PUSH-POP-NEXT:    sw t6, 32(a5)
; QCI-PUSH-POP-NEXT:    sw t5, 28(a5)
; QCI-PUSH-POP-NEXT:    sw t4, 24(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 20(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 16(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var)(t0)
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s11}, 96
; QCI-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_spill_nest:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s11}, -96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 192
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-NEXT:    lui t0, %hi(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    addi a5, t0, %lo(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw t4, 24(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s1, 80(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t1, 92(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a7, 112(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s0, 116(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a6, 96(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a4, 100(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s0, 116(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a7, 112(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a4, 100(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a6, 96(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t1, 92(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s1, 80(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t4, 24(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s11}, 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_spill_nest:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s11}, -96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 192
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lui t1, %hi(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+4)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+8)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -172(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+12)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -176(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi a5, t1, %lo(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -180(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -184(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 24(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -188(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t4, 80(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s1, 92(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t0, 112(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a4, 116(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a7, 96(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a6, 100(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a4, 116(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t0, 112(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a6, 100(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a7, 96(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s1, 92(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t4, 80(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -188(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 24(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -184(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -180(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -176(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+12)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -172(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+8)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+4)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 192
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s11}, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_spill_nonest() "interrupt"="qci-nonest" {
; QCI-LABEL: test_spill_nonest:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -80
; QCI-NEXT:    .cfi_def_cfa_offset 176
; QCI-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s1, -100
; QCI-NEXT:    .cfi_offset s2, -104
; QCI-NEXT:    .cfi_offset s3, -108
; QCI-NEXT:    .cfi_offset s4, -112
; QCI-NEXT:    .cfi_offset s5, -116
; QCI-NEXT:    .cfi_offset s6, -120
; QCI-NEXT:    .cfi_offset s7, -124
; QCI-NEXT:    .cfi_offset s8, -128
; QCI-NEXT:    .cfi_offset s9, -132
; QCI-NEXT:    .cfi_offset s10, -136
; QCI-NEXT:    .cfi_offset s11, -140
; QCI-NEXT:    lui t0, %hi(var)
; QCI-NEXT:    lw a0, %lo(var)(t0)
; QCI-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-NEXT:    addi a5, t0, %lo(var)
; QCI-NEXT:    lw a0, 16(a5)
; QCI-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 20(a5)
; QCI-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw t4, 24(a5)
; QCI-NEXT:    lw t5, 28(a5)
; QCI-NEXT:    lw t6, 32(a5)
; QCI-NEXT:    lw s2, 36(a5)
; QCI-NEXT:    lw s3, 40(a5)
; QCI-NEXT:    lw s4, 44(a5)
; QCI-NEXT:    lw s5, 48(a5)
; QCI-NEXT:    lw s6, 52(a5)
; QCI-NEXT:    lw s7, 56(a5)
; QCI-NEXT:    lw s8, 60(a5)
; QCI-NEXT:    lw s9, 64(a5)
; QCI-NEXT:    lw s10, 68(a5)
; QCI-NEXT:    lw s11, 72(a5)
; QCI-NEXT:    lw ra, 76(a5)
; QCI-NEXT:    lw s1, 80(a5)
; QCI-NEXT:    lw t3, 84(a5)
; QCI-NEXT:    lw t2, 88(a5)
; QCI-NEXT:    lw t1, 92(a5)
; QCI-NEXT:    lw a7, 112(a5)
; QCI-NEXT:    lw s0, 116(a5)
; QCI-NEXT:    lw a3, 120(a5)
; QCI-NEXT:    lw a0, 124(a5)
; QCI-NEXT:    lw a6, 96(a5)
; QCI-NEXT:    lw a4, 100(a5)
; QCI-NEXT:    lw a2, 104(a5)
; QCI-NEXT:    lw a1, 108(a5)
; QCI-NEXT:    sw a0, 124(a5)
; QCI-NEXT:    sw a3, 120(a5)
; QCI-NEXT:    sw s0, 116(a5)
; QCI-NEXT:    sw a7, 112(a5)
; QCI-NEXT:    sw a1, 108(a5)
; QCI-NEXT:    sw a2, 104(a5)
; QCI-NEXT:    sw a4, 100(a5)
; QCI-NEXT:    sw a6, 96(a5)
; QCI-NEXT:    sw t1, 92(a5)
; QCI-NEXT:    sw t2, 88(a5)
; QCI-NEXT:    sw t3, 84(a5)
; QCI-NEXT:    sw s1, 80(a5)
; QCI-NEXT:    sw ra, 76(a5)
; QCI-NEXT:    sw s11, 72(a5)
; QCI-NEXT:    sw s10, 68(a5)
; QCI-NEXT:    sw s9, 64(a5)
; QCI-NEXT:    sw s8, 60(a5)
; QCI-NEXT:    sw s7, 56(a5)
; QCI-NEXT:    sw s6, 52(a5)
; QCI-NEXT:    sw s5, 48(a5)
; QCI-NEXT:    sw s4, 44(a5)
; QCI-NEXT:    sw s3, 40(a5)
; QCI-NEXT:    sw s2, 36(a5)
; QCI-NEXT:    sw t6, 32(a5)
; QCI-NEXT:    sw t5, 28(a5)
; QCI-NEXT:    sw t4, 24(a5)
; QCI-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 20(a5)
; QCI-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 16(a5)
; QCI-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var)(t0)
; QCI-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s1
; QCI-NEXT:    .cfi_restore s2
; QCI-NEXT:    .cfi_restore s3
; QCI-NEXT:    .cfi_restore s4
; QCI-NEXT:    .cfi_restore s5
; QCI-NEXT:    .cfi_restore s6
; QCI-NEXT:    .cfi_restore s7
; QCI-NEXT:    .cfi_restore s8
; QCI-NEXT:    .cfi_restore s9
; QCI-NEXT:    .cfi_restore s10
; QCI-NEXT:    .cfi_restore s11
; QCI-NEXT:    addi sp, sp, 80
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_spill_nonest:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -80
; QCI-FP-NEXT:    .cfi_def_cfa_offset 176
; QCI-FP-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s1, -100
; QCI-FP-NEXT:    .cfi_offset s2, -104
; QCI-FP-NEXT:    .cfi_offset s3, -108
; QCI-FP-NEXT:    .cfi_offset s4, -112
; QCI-FP-NEXT:    .cfi_offset s5, -116
; QCI-FP-NEXT:    .cfi_offset s6, -120
; QCI-FP-NEXT:    .cfi_offset s7, -124
; QCI-FP-NEXT:    .cfi_offset s8, -128
; QCI-FP-NEXT:    .cfi_offset s9, -132
; QCI-FP-NEXT:    .cfi_offset s10, -136
; QCI-FP-NEXT:    .cfi_offset s11, -140
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    lui t1, %hi(var)
; QCI-FP-NEXT:    lw a0, %lo(var)(t1)
; QCI-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+4)(t1)
; QCI-FP-NEXT:    sw a0, -148(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+8)(t1)
; QCI-FP-NEXT:    sw a0, -152(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+12)(t1)
; QCI-FP-NEXT:    sw a0, -156(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    addi a5, t1, %lo(var)
; QCI-FP-NEXT:    lw a0, 16(a5)
; QCI-FP-NEXT:    sw a0, -160(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 20(a5)
; QCI-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 24(a5)
; QCI-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw t5, 28(a5)
; QCI-FP-NEXT:    lw t6, 32(a5)
; QCI-FP-NEXT:    lw s2, 36(a5)
; QCI-FP-NEXT:    lw s3, 40(a5)
; QCI-FP-NEXT:    lw s4, 44(a5)
; QCI-FP-NEXT:    lw s5, 48(a5)
; QCI-FP-NEXT:    lw s6, 52(a5)
; QCI-FP-NEXT:    lw s7, 56(a5)
; QCI-FP-NEXT:    lw s8, 60(a5)
; QCI-FP-NEXT:    lw s9, 64(a5)
; QCI-FP-NEXT:    lw s10, 68(a5)
; QCI-FP-NEXT:    lw s11, 72(a5)
; QCI-FP-NEXT:    lw ra, 76(a5)
; QCI-FP-NEXT:    lw t4, 80(a5)
; QCI-FP-NEXT:    lw t3, 84(a5)
; QCI-FP-NEXT:    lw t2, 88(a5)
; QCI-FP-NEXT:    lw s1, 92(a5)
; QCI-FP-NEXT:    lw t0, 112(a5)
; QCI-FP-NEXT:    lw a4, 116(a5)
; QCI-FP-NEXT:    lw a3, 120(a5)
; QCI-FP-NEXT:    lw a0, 124(a5)
; QCI-FP-NEXT:    lw a7, 96(a5)
; QCI-FP-NEXT:    lw a6, 100(a5)
; QCI-FP-NEXT:    lw a2, 104(a5)
; QCI-FP-NEXT:    lw a1, 108(a5)
; QCI-FP-NEXT:    sw a0, 124(a5)
; QCI-FP-NEXT:    sw a3, 120(a5)
; QCI-FP-NEXT:    sw a4, 116(a5)
; QCI-FP-NEXT:    sw t0, 112(a5)
; QCI-FP-NEXT:    sw a1, 108(a5)
; QCI-FP-NEXT:    sw a2, 104(a5)
; QCI-FP-NEXT:    sw a6, 100(a5)
; QCI-FP-NEXT:    sw a7, 96(a5)
; QCI-FP-NEXT:    sw s1, 92(a5)
; QCI-FP-NEXT:    sw t2, 88(a5)
; QCI-FP-NEXT:    sw t3, 84(a5)
; QCI-FP-NEXT:    sw t4, 80(a5)
; QCI-FP-NEXT:    sw ra, 76(a5)
; QCI-FP-NEXT:    sw s11, 72(a5)
; QCI-FP-NEXT:    sw s10, 68(a5)
; QCI-FP-NEXT:    sw s9, 64(a5)
; QCI-FP-NEXT:    sw s8, 60(a5)
; QCI-FP-NEXT:    sw s7, 56(a5)
; QCI-FP-NEXT:    sw s6, 52(a5)
; QCI-FP-NEXT:    sw s5, 48(a5)
; QCI-FP-NEXT:    sw s4, 44(a5)
; QCI-FP-NEXT:    sw s3, 40(a5)
; QCI-FP-NEXT:    sw s2, 36(a5)
; QCI-FP-NEXT:    sw t6, 32(a5)
; QCI-FP-NEXT:    sw t5, 28(a5)
; QCI-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 24(a5)
; QCI-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 20(a5)
; QCI-FP-NEXT:    lw a0, -160(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 16(a5)
; QCI-FP-NEXT:    lw a0, -156(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+12)(t1)
; QCI-FP-NEXT:    lw a0, -152(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+8)(t1)
; QCI-FP-NEXT:    lw a0, -148(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+4)(t1)
; QCI-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var)(t1)
; QCI-FP-NEXT:    .cfi_def_cfa sp, 176
; QCI-FP-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s1
; QCI-FP-NEXT:    .cfi_restore s2
; QCI-FP-NEXT:    .cfi_restore s3
; QCI-FP-NEXT:    .cfi_restore s4
; QCI-FP-NEXT:    .cfi_restore s5
; QCI-FP-NEXT:    .cfi_restore s6
; QCI-FP-NEXT:    .cfi_restore s7
; QCI-FP-NEXT:    .cfi_restore s8
; QCI-FP-NEXT:    .cfi_restore s9
; QCI-FP-NEXT:    .cfi_restore s10
; QCI-FP-NEXT:    .cfi_restore s11
; QCI-FP-NEXT:    addi sp, sp, 80
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_spill_nonest:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s11}, -96
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 192
; QCI-PUSH-POP-NEXT:    .cfi_offset s1, -140
; QCI-PUSH-POP-NEXT:    .cfi_offset s2, -136
; QCI-PUSH-POP-NEXT:    .cfi_offset s3, -132
; QCI-PUSH-POP-NEXT:    .cfi_offset s4, -128
; QCI-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-PUSH-POP-NEXT:    .cfi_offset s6, -120
; QCI-PUSH-POP-NEXT:    .cfi_offset s7, -116
; QCI-PUSH-POP-NEXT:    .cfi_offset s8, -112
; QCI-PUSH-POP-NEXT:    .cfi_offset s9, -108
; QCI-PUSH-POP-NEXT:    .cfi_offset s10, -104
; QCI-PUSH-POP-NEXT:    .cfi_offset s11, -100
; QCI-PUSH-POP-NEXT:    lui t0, %hi(var)
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    addi a5, t0, %lo(var)
; QCI-PUSH-POP-NEXT:    lw a0, 16(a5)
; QCI-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 20(a5)
; QCI-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw t4, 24(a5)
; QCI-PUSH-POP-NEXT:    lw t5, 28(a5)
; QCI-PUSH-POP-NEXT:    lw t6, 32(a5)
; QCI-PUSH-POP-NEXT:    lw s2, 36(a5)
; QCI-PUSH-POP-NEXT:    lw s3, 40(a5)
; QCI-PUSH-POP-NEXT:    lw s4, 44(a5)
; QCI-PUSH-POP-NEXT:    lw s5, 48(a5)
; QCI-PUSH-POP-NEXT:    lw s6, 52(a5)
; QCI-PUSH-POP-NEXT:    lw s7, 56(a5)
; QCI-PUSH-POP-NEXT:    lw s8, 60(a5)
; QCI-PUSH-POP-NEXT:    lw s9, 64(a5)
; QCI-PUSH-POP-NEXT:    lw s10, 68(a5)
; QCI-PUSH-POP-NEXT:    lw s11, 72(a5)
; QCI-PUSH-POP-NEXT:    lw ra, 76(a5)
; QCI-PUSH-POP-NEXT:    lw s1, 80(a5)
; QCI-PUSH-POP-NEXT:    lw t3, 84(a5)
; QCI-PUSH-POP-NEXT:    lw t2, 88(a5)
; QCI-PUSH-POP-NEXT:    lw t1, 92(a5)
; QCI-PUSH-POP-NEXT:    lw a7, 112(a5)
; QCI-PUSH-POP-NEXT:    lw s0, 116(a5)
; QCI-PUSH-POP-NEXT:    lw a3, 120(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 124(a5)
; QCI-PUSH-POP-NEXT:    lw a6, 96(a5)
; QCI-PUSH-POP-NEXT:    lw a4, 100(a5)
; QCI-PUSH-POP-NEXT:    lw a2, 104(a5)
; QCI-PUSH-POP-NEXT:    lw a1, 108(a5)
; QCI-PUSH-POP-NEXT:    sw a0, 124(a5)
; QCI-PUSH-POP-NEXT:    sw a3, 120(a5)
; QCI-PUSH-POP-NEXT:    sw s0, 116(a5)
; QCI-PUSH-POP-NEXT:    sw a7, 112(a5)
; QCI-PUSH-POP-NEXT:    sw a1, 108(a5)
; QCI-PUSH-POP-NEXT:    sw a2, 104(a5)
; QCI-PUSH-POP-NEXT:    sw a4, 100(a5)
; QCI-PUSH-POP-NEXT:    sw a6, 96(a5)
; QCI-PUSH-POP-NEXT:    sw t1, 92(a5)
; QCI-PUSH-POP-NEXT:    sw t2, 88(a5)
; QCI-PUSH-POP-NEXT:    sw t3, 84(a5)
; QCI-PUSH-POP-NEXT:    sw s1, 80(a5)
; QCI-PUSH-POP-NEXT:    sw ra, 76(a5)
; QCI-PUSH-POP-NEXT:    sw s11, 72(a5)
; QCI-PUSH-POP-NEXT:    sw s10, 68(a5)
; QCI-PUSH-POP-NEXT:    sw s9, 64(a5)
; QCI-PUSH-POP-NEXT:    sw s8, 60(a5)
; QCI-PUSH-POP-NEXT:    sw s7, 56(a5)
; QCI-PUSH-POP-NEXT:    sw s6, 52(a5)
; QCI-PUSH-POP-NEXT:    sw s5, 48(a5)
; QCI-PUSH-POP-NEXT:    sw s4, 44(a5)
; QCI-PUSH-POP-NEXT:    sw s3, 40(a5)
; QCI-PUSH-POP-NEXT:    sw s2, 36(a5)
; QCI-PUSH-POP-NEXT:    sw t6, 32(a5)
; QCI-PUSH-POP-NEXT:    sw t5, 28(a5)
; QCI-PUSH-POP-NEXT:    sw t4, 24(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 20(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 16(a5)
; QCI-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var)(t0)
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s11}, 96
; QCI-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_spill_nonest:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s11}, -96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 192
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-NEXT:    lui t0, %hi(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    addi a5, t0, %lo(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw t4, 24(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s1, 80(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw t1, 92(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a7, 112(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s0, 116(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a6, 96(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a4, 100(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s0, 116(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a7, 112(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a4, 100(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a6, 96(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t1, 92(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s1, 80(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    sw t4, 24(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var)(t0)
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s11}, 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_spill_nonest:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s11}, -96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 192
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lui t1, %hi(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+4)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+8)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -172(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+12)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -176(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi a5, t1, %lo(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -180(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -184(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 24(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -188(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t4, 80(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s1, 92(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw t0, 112(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a4, 116(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a7, 96(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a6, 100(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 124(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a3, 120(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a4, 116(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t0, 112(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a1, 108(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a2, 104(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a6, 100(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a7, 96(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s1, 92(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t2, 88(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t3, 84(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t4, 80(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw ra, 76(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s11, 72(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s10, 68(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s9, 64(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s8, 60(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s7, 56(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s6, 52(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s5, 48(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s4, 44(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s3, 40(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s2, 36(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t6, 32(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw t5, 28(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -188(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 24(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -184(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 20(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -180(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 16(a5)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -176(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+12)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -172(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+8)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+4)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var)(t1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 192
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s11}, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_spill_call_nest() "interrupt"="qci-nest" {
; QCI-LABEL: test_spill_call_nest:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -144
; QCI-NEXT:    .cfi_def_cfa_offset 240
; QCI-NEXT:    sw s1, 140(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s2, 136(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s3, 132(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s4, 128(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s5, 124(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s6, 120(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s7, 116(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s8, 112(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s9, 108(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s10, 104(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s11, 100(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s1, -100
; QCI-NEXT:    .cfi_offset s2, -104
; QCI-NEXT:    .cfi_offset s3, -108
; QCI-NEXT:    .cfi_offset s4, -112
; QCI-NEXT:    .cfi_offset s5, -116
; QCI-NEXT:    .cfi_offset s6, -120
; QCI-NEXT:    .cfi_offset s7, -124
; QCI-NEXT:    .cfi_offset s8, -128
; QCI-NEXT:    .cfi_offset s9, -132
; QCI-NEXT:    .cfi_offset s10, -136
; QCI-NEXT:    .cfi_offset s11, -140
; QCI-NEXT:    lui s0, %hi(var)
; QCI-NEXT:    lw a0, %lo(var)(s0)
; QCI-NEXT:    sw a0, 96(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-NEXT:    addi s1, s0, %lo(var)
; QCI-NEXT:    lw a0, 16(s1)
; QCI-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 20(s1)
; QCI-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 24(s1)
; QCI-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 28(s1)
; QCI-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 32(s1)
; QCI-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 36(s1)
; QCI-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 40(s1)
; QCI-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 44(s1)
; QCI-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 48(s1)
; QCI-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 52(s1)
; QCI-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 56(s1)
; QCI-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 60(s1)
; QCI-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 64(s1)
; QCI-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 68(s1)
; QCI-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 72(s1)
; QCI-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 76(s1)
; QCI-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 80(s1)
; QCI-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 84(s1)
; QCI-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw s4, 88(s1)
; QCI-NEXT:    lw s5, 92(s1)
; QCI-NEXT:    lw s6, 96(s1)
; QCI-NEXT:    lw s7, 100(s1)
; QCI-NEXT:    lw s8, 104(s1)
; QCI-NEXT:    lw s9, 108(s1)
; QCI-NEXT:    lw s10, 112(s1)
; QCI-NEXT:    lw s11, 116(s1)
; QCI-NEXT:    lw s2, 120(s1)
; QCI-NEXT:    lw s3, 124(s1)
; QCI-NEXT:    li a0, 4
; QCI-NEXT:    li a2, 1
; QCI-NEXT:    li a4, 2
; QCI-NEXT:    li a6, 3
; QCI-NEXT:    sw a0, 0(sp)
; QCI-NEXT:    li a0, 0
; QCI-NEXT:    li a1, 0
; QCI-NEXT:    li a3, 0
; QCI-NEXT:    li a5, 0
; QCI-NEXT:    li a7, 0
; QCI-NEXT:    call function_with_one_stack_arg
; QCI-NEXT:    call use_i64
; QCI-NEXT:    sw s3, 124(s1)
; QCI-NEXT:    sw s2, 120(s1)
; QCI-NEXT:    sw s11, 116(s1)
; QCI-NEXT:    sw s10, 112(s1)
; QCI-NEXT:    sw s9, 108(s1)
; QCI-NEXT:    sw s8, 104(s1)
; QCI-NEXT:    sw s7, 100(s1)
; QCI-NEXT:    sw s6, 96(s1)
; QCI-NEXT:    sw s5, 92(s1)
; QCI-NEXT:    sw s4, 88(s1)
; QCI-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 84(s1)
; QCI-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 80(s1)
; QCI-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 76(s1)
; QCI-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 72(s1)
; QCI-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 68(s1)
; QCI-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 64(s1)
; QCI-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 60(s1)
; QCI-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 56(s1)
; QCI-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 52(s1)
; QCI-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 48(s1)
; QCI-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 44(s1)
; QCI-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 40(s1)
; QCI-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 36(s1)
; QCI-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 32(s1)
; QCI-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 28(s1)
; QCI-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 24(s1)
; QCI-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 20(s1)
; QCI-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 16(s1)
; QCI-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-NEXT:    lw a0, 96(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var)(s0)
; QCI-NEXT:    lw s1, 140(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s2, 136(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s3, 132(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s4, 128(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s5, 124(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s6, 120(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s7, 116(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s8, 112(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s9, 108(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s10, 104(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s11, 100(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s1
; QCI-NEXT:    .cfi_restore s2
; QCI-NEXT:    .cfi_restore s3
; QCI-NEXT:    .cfi_restore s4
; QCI-NEXT:    .cfi_restore s5
; QCI-NEXT:    .cfi_restore s6
; QCI-NEXT:    .cfi_restore s7
; QCI-NEXT:    .cfi_restore s8
; QCI-NEXT:    .cfi_restore s9
; QCI-NEXT:    .cfi_restore s10
; QCI-NEXT:    .cfi_restore s11
; QCI-NEXT:    addi sp, sp, 144
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_spill_call_nest:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -144
; QCI-FP-NEXT:    .cfi_def_cfa_offset 240
; QCI-FP-NEXT:    sw s1, 140(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s2, 136(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s3, 132(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s4, 128(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s5, 124(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s6, 120(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s7, 116(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s8, 112(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s9, 108(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s10, 104(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s11, 100(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s1, -100
; QCI-FP-NEXT:    .cfi_offset s2, -104
; QCI-FP-NEXT:    .cfi_offset s3, -108
; QCI-FP-NEXT:    .cfi_offset s4, -112
; QCI-FP-NEXT:    .cfi_offset s5, -116
; QCI-FP-NEXT:    .cfi_offset s6, -120
; QCI-FP-NEXT:    .cfi_offset s7, -124
; QCI-FP-NEXT:    .cfi_offset s8, -128
; QCI-FP-NEXT:    .cfi_offset s9, -132
; QCI-FP-NEXT:    .cfi_offset s10, -136
; QCI-FP-NEXT:    .cfi_offset s11, -140
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    lui s6, %hi(var)
; QCI-FP-NEXT:    lw a0, %lo(var)(s6)
; QCI-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+4)(s6)
; QCI-FP-NEXT:    sw a0, -148(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+8)(s6)
; QCI-FP-NEXT:    sw a0, -152(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+12)(s6)
; QCI-FP-NEXT:    sw a0, -156(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    addi s1, s6, %lo(var)
; QCI-FP-NEXT:    lw a0, 16(s1)
; QCI-FP-NEXT:    sw a0, -160(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 20(s1)
; QCI-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 24(s1)
; QCI-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 28(s1)
; QCI-FP-NEXT:    sw a0, -172(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 32(s1)
; QCI-FP-NEXT:    sw a0, -176(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 36(s1)
; QCI-FP-NEXT:    sw a0, -180(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 40(s1)
; QCI-FP-NEXT:    sw a0, -184(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 44(s1)
; QCI-FP-NEXT:    sw a0, -188(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 48(s1)
; QCI-FP-NEXT:    sw a0, -192(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 52(s1)
; QCI-FP-NEXT:    sw a0, -196(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 56(s1)
; QCI-FP-NEXT:    sw a0, -200(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 60(s1)
; QCI-FP-NEXT:    sw a0, -204(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 64(s1)
; QCI-FP-NEXT:    sw a0, -208(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 68(s1)
; QCI-FP-NEXT:    sw a0, -212(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 72(s1)
; QCI-FP-NEXT:    sw a0, -216(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 76(s1)
; QCI-FP-NEXT:    sw a0, -220(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 80(s1)
; QCI-FP-NEXT:    sw a0, -224(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 84(s1)
; QCI-FP-NEXT:    sw a0, -228(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 88(s1)
; QCI-FP-NEXT:    sw a0, -232(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw s8, 92(s1)
; QCI-FP-NEXT:    lw s9, 96(s1)
; QCI-FP-NEXT:    lw s10, 100(s1)
; QCI-FP-NEXT:    lw s11, 104(s1)
; QCI-FP-NEXT:    lw s2, 108(s1)
; QCI-FP-NEXT:    lw s3, 112(s1)
; QCI-FP-NEXT:    lw s4, 116(s1)
; QCI-FP-NEXT:    lw s5, 120(s1)
; QCI-FP-NEXT:    lw s7, 124(s1)
; QCI-FP-NEXT:    li a0, 4
; QCI-FP-NEXT:    li a2, 1
; QCI-FP-NEXT:    li a4, 2
; QCI-FP-NEXT:    li a6, 3
; QCI-FP-NEXT:    sw a0, 0(sp)
; QCI-FP-NEXT:    li a0, 0
; QCI-FP-NEXT:    li a1, 0
; QCI-FP-NEXT:    li a3, 0
; QCI-FP-NEXT:    li a5, 0
; QCI-FP-NEXT:    li a7, 0
; QCI-FP-NEXT:    call function_with_one_stack_arg
; QCI-FP-NEXT:    call use_i64
; QCI-FP-NEXT:    sw s7, 124(s1)
; QCI-FP-NEXT:    sw s5, 120(s1)
; QCI-FP-NEXT:    sw s4, 116(s1)
; QCI-FP-NEXT:    sw s3, 112(s1)
; QCI-FP-NEXT:    sw s2, 108(s1)
; QCI-FP-NEXT:    sw s11, 104(s1)
; QCI-FP-NEXT:    sw s10, 100(s1)
; QCI-FP-NEXT:    sw s9, 96(s1)
; QCI-FP-NEXT:    sw s8, 92(s1)
; QCI-FP-NEXT:    lw a0, -232(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 88(s1)
; QCI-FP-NEXT:    lw a0, -228(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 84(s1)
; QCI-FP-NEXT:    lw a0, -224(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 80(s1)
; QCI-FP-NEXT:    lw a0, -220(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 76(s1)
; QCI-FP-NEXT:    lw a0, -216(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 72(s1)
; QCI-FP-NEXT:    lw a0, -212(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 68(s1)
; QCI-FP-NEXT:    lw a0, -208(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 64(s1)
; QCI-FP-NEXT:    lw a0, -204(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 60(s1)
; QCI-FP-NEXT:    lw a0, -200(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 56(s1)
; QCI-FP-NEXT:    lw a0, -196(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 52(s1)
; QCI-FP-NEXT:    lw a0, -192(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 48(s1)
; QCI-FP-NEXT:    lw a0, -188(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 44(s1)
; QCI-FP-NEXT:    lw a0, -184(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 40(s1)
; QCI-FP-NEXT:    lw a0, -180(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 36(s1)
; QCI-FP-NEXT:    lw a0, -176(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 32(s1)
; QCI-FP-NEXT:    lw a0, -172(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 28(s1)
; QCI-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 24(s1)
; QCI-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 20(s1)
; QCI-FP-NEXT:    lw a0, -160(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 16(s1)
; QCI-FP-NEXT:    lw a0, -156(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+12)(s6)
; QCI-FP-NEXT:    lw a0, -152(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+8)(s6)
; QCI-FP-NEXT:    lw a0, -148(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+4)(s6)
; QCI-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var)(s6)
; QCI-FP-NEXT:    .cfi_def_cfa sp, 240
; QCI-FP-NEXT:    lw s1, 140(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s2, 136(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s3, 132(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s4, 128(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s5, 124(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s6, 120(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s7, 116(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s8, 112(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s9, 108(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s10, 104(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s11, 100(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s1
; QCI-FP-NEXT:    .cfi_restore s2
; QCI-FP-NEXT:    .cfi_restore s3
; QCI-FP-NEXT:    .cfi_restore s4
; QCI-FP-NEXT:    .cfi_restore s5
; QCI-FP-NEXT:    .cfi_restore s6
; QCI-FP-NEXT:    .cfi_restore s7
; QCI-FP-NEXT:    .cfi_restore s8
; QCI-FP-NEXT:    .cfi_restore s9
; QCI-FP-NEXT:    .cfi_restore s10
; QCI-FP-NEXT:    .cfi_restore s11
; QCI-FP-NEXT:    addi sp, sp, 144
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_spill_call_nest:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s11}, -112
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-PUSH-POP-NEXT:    .cfi_offset s1, -140
; QCI-PUSH-POP-NEXT:    .cfi_offset s2, -136
; QCI-PUSH-POP-NEXT:    .cfi_offset s3, -132
; QCI-PUSH-POP-NEXT:    .cfi_offset s4, -128
; QCI-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-PUSH-POP-NEXT:    .cfi_offset s6, -120
; QCI-PUSH-POP-NEXT:    .cfi_offset s7, -116
; QCI-PUSH-POP-NEXT:    .cfi_offset s8, -112
; QCI-PUSH-POP-NEXT:    .cfi_offset s9, -108
; QCI-PUSH-POP-NEXT:    .cfi_offset s10, -104
; QCI-PUSH-POP-NEXT:    .cfi_offset s11, -100
; QCI-PUSH-POP-NEXT:    addi sp, sp, -48
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 256
; QCI-PUSH-POP-NEXT:    lui s0, %hi(var)
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    addi s1, s0, %lo(var)
; QCI-PUSH-POP-NEXT:    lw a0, 16(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 20(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 24(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 28(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 32(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 36(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 40(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 44(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 48(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 52(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 56(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 60(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 64(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 68(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 72(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 76(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 80(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 84(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw s4, 88(s1)
; QCI-PUSH-POP-NEXT:    lw s5, 92(s1)
; QCI-PUSH-POP-NEXT:    lw s6, 96(s1)
; QCI-PUSH-POP-NEXT:    lw s7, 100(s1)
; QCI-PUSH-POP-NEXT:    lw s8, 104(s1)
; QCI-PUSH-POP-NEXT:    lw s9, 108(s1)
; QCI-PUSH-POP-NEXT:    lw s10, 112(s1)
; QCI-PUSH-POP-NEXT:    lw s11, 116(s1)
; QCI-PUSH-POP-NEXT:    lw s2, 120(s1)
; QCI-PUSH-POP-NEXT:    lw s3, 124(s1)
; QCI-PUSH-POP-NEXT:    li a0, 4
; QCI-PUSH-POP-NEXT:    li a2, 1
; QCI-PUSH-POP-NEXT:    li a4, 2
; QCI-PUSH-POP-NEXT:    li a6, 3
; QCI-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-PUSH-POP-NEXT:    li a0, 0
; QCI-PUSH-POP-NEXT:    li a1, 0
; QCI-PUSH-POP-NEXT:    li a3, 0
; QCI-PUSH-POP-NEXT:    li a5, 0
; QCI-PUSH-POP-NEXT:    li a7, 0
; QCI-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-PUSH-POP-NEXT:    call use_i64
; QCI-PUSH-POP-NEXT:    sw s3, 124(s1)
; QCI-PUSH-POP-NEXT:    sw s2, 120(s1)
; QCI-PUSH-POP-NEXT:    sw s11, 116(s1)
; QCI-PUSH-POP-NEXT:    sw s10, 112(s1)
; QCI-PUSH-POP-NEXT:    sw s9, 108(s1)
; QCI-PUSH-POP-NEXT:    sw s8, 104(s1)
; QCI-PUSH-POP-NEXT:    sw s7, 100(s1)
; QCI-PUSH-POP-NEXT:    sw s6, 96(s1)
; QCI-PUSH-POP-NEXT:    sw s5, 92(s1)
; QCI-PUSH-POP-NEXT:    sw s4, 88(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 84(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 80(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 76(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 72(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 68(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 64(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 60(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 56(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 52(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 48(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 44(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 40(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 36(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 32(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 28(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 24(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 20(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 16(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-PUSH-POP-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-PUSH-POP-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-PUSH-POP-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var)(s0)
; QCI-PUSH-POP-NEXT:    addi sp, sp, 48
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s11}, 112
; QCI-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_spill_call_nest:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s11}, -112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 256
; QCI-QCCMP-PUSH-POP-NEXT:    lui s0, %hi(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    addi s1, s0, %lo(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw s4, 88(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s5, 92(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s6, 96(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s7, 100(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s8, 104(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s9, 108(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s10, 112(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s11, 116(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s2, 120(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s3, 124(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-NEXT:    sw s3, 124(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s2, 120(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s11, 116(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s10, 112(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s9, 108(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s8, 104(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s7, 100(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s6, 96(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s5, 92(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s4, 88(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, 48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s11}, 112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_spill_call_nest:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s11}, -112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 256
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lui s6, %hi(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+4)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+8)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -172(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+12)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -176(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi s1, s6, %lo(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -180(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -184(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -188(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -192(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -196(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -200(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -204(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -208(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -212(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -216(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -220(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -224(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -228(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -232(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -236(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -240(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -244(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -248(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 88(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -252(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s8, 92(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s9, 96(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s10, 100(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s11, 104(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s2, 108(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s3, 112(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s4, 116(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s5, 120(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s7, 124(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s7, 124(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s5, 120(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s4, 116(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s3, 112(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s2, 108(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s11, 104(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s10, 100(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s9, 96(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s8, 92(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -252(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 88(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -248(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -244(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -240(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -236(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -232(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -228(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -224(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -220(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -216(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -212(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -208(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -204(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -200(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -196(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -192(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -188(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -184(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -180(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -176(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+12)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -172(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+8)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+4)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 256
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, 48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s11}, 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  %2 = call i64 @function_with_one_stack_arg(i64 0, i64 1, i64 2, i64 3, i32 4)
  call void @use_i64(i64 %2)
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_spill_call_nonest() "interrupt"="qci-nonest" {
; QCI-LABEL: test_spill_call_nonest:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -144
; QCI-NEXT:    .cfi_def_cfa_offset 240
; QCI-NEXT:    sw s1, 140(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s2, 136(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s3, 132(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s4, 128(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s5, 124(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s6, 120(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s7, 116(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s8, 112(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s9, 108(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s10, 104(sp) # 4-byte Folded Spill
; QCI-NEXT:    sw s11, 100(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s1, -100
; QCI-NEXT:    .cfi_offset s2, -104
; QCI-NEXT:    .cfi_offset s3, -108
; QCI-NEXT:    .cfi_offset s4, -112
; QCI-NEXT:    .cfi_offset s5, -116
; QCI-NEXT:    .cfi_offset s6, -120
; QCI-NEXT:    .cfi_offset s7, -124
; QCI-NEXT:    .cfi_offset s8, -128
; QCI-NEXT:    .cfi_offset s9, -132
; QCI-NEXT:    .cfi_offset s10, -136
; QCI-NEXT:    .cfi_offset s11, -140
; QCI-NEXT:    lui s0, %hi(var)
; QCI-NEXT:    lw a0, %lo(var)(s0)
; QCI-NEXT:    sw a0, 96(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-NEXT:    addi s1, s0, %lo(var)
; QCI-NEXT:    lw a0, 16(s1)
; QCI-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 20(s1)
; QCI-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 24(s1)
; QCI-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 28(s1)
; QCI-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 32(s1)
; QCI-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 36(s1)
; QCI-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 40(s1)
; QCI-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 44(s1)
; QCI-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 48(s1)
; QCI-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 52(s1)
; QCI-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 56(s1)
; QCI-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 60(s1)
; QCI-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 64(s1)
; QCI-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 68(s1)
; QCI-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 72(s1)
; QCI-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 76(s1)
; QCI-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 80(s1)
; QCI-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw a0, 84(s1)
; QCI-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    lw s4, 88(s1)
; QCI-NEXT:    lw s5, 92(s1)
; QCI-NEXT:    lw s6, 96(s1)
; QCI-NEXT:    lw s7, 100(s1)
; QCI-NEXT:    lw s8, 104(s1)
; QCI-NEXT:    lw s9, 108(s1)
; QCI-NEXT:    lw s10, 112(s1)
; QCI-NEXT:    lw s11, 116(s1)
; QCI-NEXT:    lw s2, 120(s1)
; QCI-NEXT:    lw s3, 124(s1)
; QCI-NEXT:    li a0, 4
; QCI-NEXT:    li a2, 1
; QCI-NEXT:    li a4, 2
; QCI-NEXT:    li a6, 3
; QCI-NEXT:    sw a0, 0(sp)
; QCI-NEXT:    li a0, 0
; QCI-NEXT:    li a1, 0
; QCI-NEXT:    li a3, 0
; QCI-NEXT:    li a5, 0
; QCI-NEXT:    li a7, 0
; QCI-NEXT:    call function_with_one_stack_arg
; QCI-NEXT:    call use_i64
; QCI-NEXT:    sw s3, 124(s1)
; QCI-NEXT:    sw s2, 120(s1)
; QCI-NEXT:    sw s11, 116(s1)
; QCI-NEXT:    sw s10, 112(s1)
; QCI-NEXT:    sw s9, 108(s1)
; QCI-NEXT:    sw s8, 104(s1)
; QCI-NEXT:    sw s7, 100(s1)
; QCI-NEXT:    sw s6, 96(s1)
; QCI-NEXT:    sw s5, 92(s1)
; QCI-NEXT:    sw s4, 88(s1)
; QCI-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 84(s1)
; QCI-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 80(s1)
; QCI-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 76(s1)
; QCI-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 72(s1)
; QCI-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 68(s1)
; QCI-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 64(s1)
; QCI-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 60(s1)
; QCI-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 56(s1)
; QCI-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 52(s1)
; QCI-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 48(s1)
; QCI-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 44(s1)
; QCI-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 40(s1)
; QCI-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 36(s1)
; QCI-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 32(s1)
; QCI-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 28(s1)
; QCI-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 24(s1)
; QCI-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 20(s1)
; QCI-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, 16(s1)
; QCI-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-NEXT:    lw a0, 96(sp) # 4-byte Folded Reload
; QCI-NEXT:    sw a0, %lo(var)(s0)
; QCI-NEXT:    lw s1, 140(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s2, 136(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s3, 132(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s4, 128(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s5, 124(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s6, 120(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s7, 116(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s8, 112(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s9, 108(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s10, 104(sp) # 4-byte Folded Reload
; QCI-NEXT:    lw s11, 100(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s1
; QCI-NEXT:    .cfi_restore s2
; QCI-NEXT:    .cfi_restore s3
; QCI-NEXT:    .cfi_restore s4
; QCI-NEXT:    .cfi_restore s5
; QCI-NEXT:    .cfi_restore s6
; QCI-NEXT:    .cfi_restore s7
; QCI-NEXT:    .cfi_restore s8
; QCI-NEXT:    .cfi_restore s9
; QCI-NEXT:    .cfi_restore s10
; QCI-NEXT:    .cfi_restore s11
; QCI-NEXT:    addi sp, sp, 144
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_spill_call_nonest:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -144
; QCI-FP-NEXT:    .cfi_def_cfa_offset 240
; QCI-FP-NEXT:    sw s1, 140(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s2, 136(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s3, 132(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s4, 128(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s5, 124(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s6, 120(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s7, 116(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s8, 112(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s9, 108(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s10, 104(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    sw s11, 100(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s1, -100
; QCI-FP-NEXT:    .cfi_offset s2, -104
; QCI-FP-NEXT:    .cfi_offset s3, -108
; QCI-FP-NEXT:    .cfi_offset s4, -112
; QCI-FP-NEXT:    .cfi_offset s5, -116
; QCI-FP-NEXT:    .cfi_offset s6, -120
; QCI-FP-NEXT:    .cfi_offset s7, -124
; QCI-FP-NEXT:    .cfi_offset s8, -128
; QCI-FP-NEXT:    .cfi_offset s9, -132
; QCI-FP-NEXT:    .cfi_offset s10, -136
; QCI-FP-NEXT:    .cfi_offset s11, -140
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    lui s6, %hi(var)
; QCI-FP-NEXT:    lw a0, %lo(var)(s6)
; QCI-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+4)(s6)
; QCI-FP-NEXT:    sw a0, -148(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+8)(s6)
; QCI-FP-NEXT:    sw a0, -152(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, %lo(var+12)(s6)
; QCI-FP-NEXT:    sw a0, -156(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    addi s1, s6, %lo(var)
; QCI-FP-NEXT:    lw a0, 16(s1)
; QCI-FP-NEXT:    sw a0, -160(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 20(s1)
; QCI-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 24(s1)
; QCI-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 28(s1)
; QCI-FP-NEXT:    sw a0, -172(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 32(s1)
; QCI-FP-NEXT:    sw a0, -176(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 36(s1)
; QCI-FP-NEXT:    sw a0, -180(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 40(s1)
; QCI-FP-NEXT:    sw a0, -184(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 44(s1)
; QCI-FP-NEXT:    sw a0, -188(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 48(s1)
; QCI-FP-NEXT:    sw a0, -192(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 52(s1)
; QCI-FP-NEXT:    sw a0, -196(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 56(s1)
; QCI-FP-NEXT:    sw a0, -200(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 60(s1)
; QCI-FP-NEXT:    sw a0, -204(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 64(s1)
; QCI-FP-NEXT:    sw a0, -208(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 68(s1)
; QCI-FP-NEXT:    sw a0, -212(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 72(s1)
; QCI-FP-NEXT:    sw a0, -216(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 76(s1)
; QCI-FP-NEXT:    sw a0, -220(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 80(s1)
; QCI-FP-NEXT:    sw a0, -224(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 84(s1)
; QCI-FP-NEXT:    sw a0, -228(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw a0, 88(s1)
; QCI-FP-NEXT:    sw a0, -232(s0) # 4-byte Folded Spill
; QCI-FP-NEXT:    lw s8, 92(s1)
; QCI-FP-NEXT:    lw s9, 96(s1)
; QCI-FP-NEXT:    lw s10, 100(s1)
; QCI-FP-NEXT:    lw s11, 104(s1)
; QCI-FP-NEXT:    lw s2, 108(s1)
; QCI-FP-NEXT:    lw s3, 112(s1)
; QCI-FP-NEXT:    lw s4, 116(s1)
; QCI-FP-NEXT:    lw s5, 120(s1)
; QCI-FP-NEXT:    lw s7, 124(s1)
; QCI-FP-NEXT:    li a0, 4
; QCI-FP-NEXT:    li a2, 1
; QCI-FP-NEXT:    li a4, 2
; QCI-FP-NEXT:    li a6, 3
; QCI-FP-NEXT:    sw a0, 0(sp)
; QCI-FP-NEXT:    li a0, 0
; QCI-FP-NEXT:    li a1, 0
; QCI-FP-NEXT:    li a3, 0
; QCI-FP-NEXT:    li a5, 0
; QCI-FP-NEXT:    li a7, 0
; QCI-FP-NEXT:    call function_with_one_stack_arg
; QCI-FP-NEXT:    call use_i64
; QCI-FP-NEXT:    sw s7, 124(s1)
; QCI-FP-NEXT:    sw s5, 120(s1)
; QCI-FP-NEXT:    sw s4, 116(s1)
; QCI-FP-NEXT:    sw s3, 112(s1)
; QCI-FP-NEXT:    sw s2, 108(s1)
; QCI-FP-NEXT:    sw s11, 104(s1)
; QCI-FP-NEXT:    sw s10, 100(s1)
; QCI-FP-NEXT:    sw s9, 96(s1)
; QCI-FP-NEXT:    sw s8, 92(s1)
; QCI-FP-NEXT:    lw a0, -232(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 88(s1)
; QCI-FP-NEXT:    lw a0, -228(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 84(s1)
; QCI-FP-NEXT:    lw a0, -224(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 80(s1)
; QCI-FP-NEXT:    lw a0, -220(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 76(s1)
; QCI-FP-NEXT:    lw a0, -216(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 72(s1)
; QCI-FP-NEXT:    lw a0, -212(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 68(s1)
; QCI-FP-NEXT:    lw a0, -208(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 64(s1)
; QCI-FP-NEXT:    lw a0, -204(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 60(s1)
; QCI-FP-NEXT:    lw a0, -200(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 56(s1)
; QCI-FP-NEXT:    lw a0, -196(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 52(s1)
; QCI-FP-NEXT:    lw a0, -192(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 48(s1)
; QCI-FP-NEXT:    lw a0, -188(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 44(s1)
; QCI-FP-NEXT:    lw a0, -184(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 40(s1)
; QCI-FP-NEXT:    lw a0, -180(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 36(s1)
; QCI-FP-NEXT:    lw a0, -176(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 32(s1)
; QCI-FP-NEXT:    lw a0, -172(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 28(s1)
; QCI-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 24(s1)
; QCI-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 20(s1)
; QCI-FP-NEXT:    lw a0, -160(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, 16(s1)
; QCI-FP-NEXT:    lw a0, -156(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+12)(s6)
; QCI-FP-NEXT:    lw a0, -152(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+8)(s6)
; QCI-FP-NEXT:    lw a0, -148(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var+4)(s6)
; QCI-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; QCI-FP-NEXT:    sw a0, %lo(var)(s6)
; QCI-FP-NEXT:    .cfi_def_cfa sp, 240
; QCI-FP-NEXT:    lw s1, 140(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s2, 136(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s3, 132(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s4, 128(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s5, 124(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s6, 120(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s7, 116(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s8, 112(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s9, 108(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s10, 104(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    lw s11, 100(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s1
; QCI-FP-NEXT:    .cfi_restore s2
; QCI-FP-NEXT:    .cfi_restore s3
; QCI-FP-NEXT:    .cfi_restore s4
; QCI-FP-NEXT:    .cfi_restore s5
; QCI-FP-NEXT:    .cfi_restore s6
; QCI-FP-NEXT:    .cfi_restore s7
; QCI-FP-NEXT:    .cfi_restore s8
; QCI-FP-NEXT:    .cfi_restore s9
; QCI-FP-NEXT:    .cfi_restore s10
; QCI-FP-NEXT:    .cfi_restore s11
; QCI-FP-NEXT:    addi sp, sp, 144
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_spill_call_nonest:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s11}, -112
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-PUSH-POP-NEXT:    .cfi_offset s1, -140
; QCI-PUSH-POP-NEXT:    .cfi_offset s2, -136
; QCI-PUSH-POP-NEXT:    .cfi_offset s3, -132
; QCI-PUSH-POP-NEXT:    .cfi_offset s4, -128
; QCI-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-PUSH-POP-NEXT:    .cfi_offset s6, -120
; QCI-PUSH-POP-NEXT:    .cfi_offset s7, -116
; QCI-PUSH-POP-NEXT:    .cfi_offset s8, -112
; QCI-PUSH-POP-NEXT:    .cfi_offset s9, -108
; QCI-PUSH-POP-NEXT:    .cfi_offset s10, -104
; QCI-PUSH-POP-NEXT:    .cfi_offset s11, -100
; QCI-PUSH-POP-NEXT:    addi sp, sp, -48
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 256
; QCI-PUSH-POP-NEXT:    lui s0, %hi(var)
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-PUSH-POP-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    addi s1, s0, %lo(var)
; QCI-PUSH-POP-NEXT:    lw a0, 16(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 20(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 24(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 28(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 32(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 36(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 40(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 44(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 48(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 52(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 56(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 60(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 64(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 68(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 72(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 76(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 80(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw a0, 84(s1)
; QCI-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-PUSH-POP-NEXT:    lw s4, 88(s1)
; QCI-PUSH-POP-NEXT:    lw s5, 92(s1)
; QCI-PUSH-POP-NEXT:    lw s6, 96(s1)
; QCI-PUSH-POP-NEXT:    lw s7, 100(s1)
; QCI-PUSH-POP-NEXT:    lw s8, 104(s1)
; QCI-PUSH-POP-NEXT:    lw s9, 108(s1)
; QCI-PUSH-POP-NEXT:    lw s10, 112(s1)
; QCI-PUSH-POP-NEXT:    lw s11, 116(s1)
; QCI-PUSH-POP-NEXT:    lw s2, 120(s1)
; QCI-PUSH-POP-NEXT:    lw s3, 124(s1)
; QCI-PUSH-POP-NEXT:    li a0, 4
; QCI-PUSH-POP-NEXT:    li a2, 1
; QCI-PUSH-POP-NEXT:    li a4, 2
; QCI-PUSH-POP-NEXT:    li a6, 3
; QCI-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-PUSH-POP-NEXT:    li a0, 0
; QCI-PUSH-POP-NEXT:    li a1, 0
; QCI-PUSH-POP-NEXT:    li a3, 0
; QCI-PUSH-POP-NEXT:    li a5, 0
; QCI-PUSH-POP-NEXT:    li a7, 0
; QCI-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-PUSH-POP-NEXT:    call use_i64
; QCI-PUSH-POP-NEXT:    sw s3, 124(s1)
; QCI-PUSH-POP-NEXT:    sw s2, 120(s1)
; QCI-PUSH-POP-NEXT:    sw s11, 116(s1)
; QCI-PUSH-POP-NEXT:    sw s10, 112(s1)
; QCI-PUSH-POP-NEXT:    sw s9, 108(s1)
; QCI-PUSH-POP-NEXT:    sw s8, 104(s1)
; QCI-PUSH-POP-NEXT:    sw s7, 100(s1)
; QCI-PUSH-POP-NEXT:    sw s6, 96(s1)
; QCI-PUSH-POP-NEXT:    sw s5, 92(s1)
; QCI-PUSH-POP-NEXT:    sw s4, 88(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 84(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 80(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 76(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 72(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 68(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 64(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 60(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 56(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 52(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 48(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 44(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 40(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 36(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 32(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 28(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 24(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 20(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, 16(s1)
; QCI-PUSH-POP-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-PUSH-POP-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-PUSH-POP-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-PUSH-POP-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-PUSH-POP-NEXT:    sw a0, %lo(var)(s0)
; QCI-PUSH-POP-NEXT:    addi sp, sp, 48
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s11}, 112
; QCI-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_spill_call_nonest:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s11}, -112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 256
; QCI-QCCMP-PUSH-POP-NEXT:    lui s0, %hi(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    addi s1, s0, %lo(var)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-NEXT:    lw s4, 88(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s5, 92(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s6, 96(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s7, 100(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s8, 104(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s9, 108(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s10, 112(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s11, 116(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s2, 120(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw s3, 124(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-NEXT:    sw s3, 124(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s2, 120(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s11, 116(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s10, 112(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s9, 108(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s8, 104(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s7, 100(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s6, 96(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s5, 92(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    sw s4, 88(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-NEXT:    sw a0, %lo(var)(s0)
; QCI-QCCMP-PUSH-POP-NEXT:    addi sp, sp, 48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s11}, 112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_spill_call_nonest:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s11}, -112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s2, -112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s3, -116
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s4, -120
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s5, -124
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s6, -128
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s7, -132
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s8, -136
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s9, -140
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s10, -144
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 256
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lui s6, %hi(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -164(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+4)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -168(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+8)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -172(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, %lo(var+12)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -176(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi s1, s6, %lo(var)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -180(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -184(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -188(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -192(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -196(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -200(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -204(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -208(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -212(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -216(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -220(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -224(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -228(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -232(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -236(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -240(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -244(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -248(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, 88(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, -252(s0) # 4-byte Folded Spill
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s8, 92(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s9, 96(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s10, 100(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s11, 104(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s2, 108(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s3, 112(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s4, 116(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s5, 120(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw s7, 124(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a2, 1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a4, 2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a6, 3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 0(sp)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a1, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a3, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a5, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li a7, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call function_with_one_stack_arg
; QCI-QCCMP-PUSH-POP-FP-NEXT:    call use_i64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s7, 124(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s5, 120(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s4, 116(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s3, 112(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s2, 108(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s11, 104(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s10, 100(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s9, 96(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw s8, 92(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -252(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 88(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -248(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 84(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -244(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 80(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -240(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 76(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -236(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 72(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -232(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 68(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -228(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 64(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -224(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 60(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -220(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 56(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -216(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 52(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -212(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 48(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -208(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 44(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -204(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 40(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -200(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 36(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -196(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 32(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -192(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 28(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -188(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 24(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -184(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 20(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -180(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, 16(s1)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -176(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+12)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -172(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+8)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -168(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var+4)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    lw a0, -164(s0) # 4-byte Folded Reload
; QCI-QCCMP-PUSH-POP-FP-NEXT:    sw a0, %lo(var)(s6)
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 256
; QCI-QCCMP-PUSH-POP-FP-NEXT:    addi sp, sp, 48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 208
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s11}, 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s2
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s3
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s4
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s5
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s6
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s7
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s9
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s10
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  %2 = call i64 @function_with_one_stack_arg(i64 0, i64 1, i64 2, i64 3, i32 4)
  call void @use_i64(i64 %2)
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_nest_explicit_s11() "interrupt"="qci-nest" {
; QCI-LABEL: test_nest_explicit_s11:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -16
; QCI-NEXT:    .cfi_def_cfa_offset 112
; QCI-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s11, -100
; QCI-NEXT:    #APP
; QCI-NEXT:    li s4, 0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s11
; QCI-NEXT:    addi sp, sp, 16
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nest_explicit_s11:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-FP-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s11, -100
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    li s4, 0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-FP-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s11
; QCI-FP-NEXT:    addi sp, sp, 16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nest_explicit_s11:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s11}, -64
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 160
; QCI-PUSH-POP-NEXT:    .cfi_offset s11, -100
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    li s4, 0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s11}, 64
; QCI-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nest_explicit_s11:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s11}, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 160
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    li s4, 0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s11}, 64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nest_explicit_s11:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s11}, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 160
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li s4, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 160
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s11}, 64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  tail call void asm sideeffect "li s4, 0", "~{s11}"()
  ret void
}

define void @test_nonest_explicit_s11() "interrupt"="qci-nonest" {
; QCI-LABEL: test_nonest_explicit_s11:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -16
; QCI-NEXT:    .cfi_def_cfa_offset 112
; QCI-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s11, -100
; QCI-NEXT:    #APP
; QCI-NEXT:    li s11, 0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s11
; QCI-NEXT:    addi sp, sp, 16
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nonest_explicit_s11:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-FP-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s11, -100
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    li s11, 0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-FP-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s11
; QCI-FP-NEXT:    addi sp, sp, 16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nonest_explicit_s11:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s11}, -64
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 160
; QCI-PUSH-POP-NEXT:    .cfi_offset s11, -100
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    li s11, 0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s11}, 64
; QCI-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nonest_explicit_s11:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s11}, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 160
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    li s11, 0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s11}, 64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nonest_explicit_s11:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s11}, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 160
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s11, -148
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li s11, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 160
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s11}, 64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s11
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  tail call void asm sideeffect "li s11, 0", "~{s11}"()
  ret void
}

define void @test_nest_explicit_ra_s0() "interrupt"="qci-nest" {
; QCI-LABEL: test_nest_explicit_ra_s0:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    #APP
; QCI-NEXT:    li s4, 0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nest_explicit_ra_s0:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    li s4, 0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nest_explicit_ra_s0:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    li s4, 0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nest_explicit_ra_s0:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    li s4, 0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nest_explicit_ra_s0:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li s4, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  tail call void asm sideeffect "li s4, 0", "~{ra},~{s0}"()
  ret void
}

define void @test_nonest_explicit_ra_s0() "interrupt"="qci-nonest" {
; QCI-LABEL: test_nonest_explicit_ra_s0:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    #APP
; QCI-NEXT:    li s11, 0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nonest_explicit_ra_s0:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    li s11, 0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nonest_explicit_ra_s0:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    li s11, 0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nonest_explicit_ra_s0:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    li s11, 0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nonest_explicit_ra_s0:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li s11, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  tail call void asm sideeffect "li s11, 0", "~{ra},~{s0}"()
  ret void
}


define void @test_nest_explicit_s1() "interrupt"="qci-nest" {
; QCI-LABEL: test_nest_explicit_s1:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter.nest
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -16
; QCI-NEXT:    .cfi_def_cfa_offset 112
; QCI-NEXT:    sw s1, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s1, -100
; QCI-NEXT:    #APP
; QCI-NEXT:    li s4, 0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    lw s1, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s1
; QCI-NEXT:    addi sp, sp, 16
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nest_explicit_s1:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter.nest
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-FP-NEXT:    sw s1, 12(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s1, -100
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    li s4, 0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-FP-NEXT:    lw s1, 12(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s1
; QCI-FP-NEXT:    addi sp, sp, 16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nest_explicit_s1:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s1}, -16
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-PUSH-POP-NEXT:    .cfi_offset s1, -100
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    li s4, 0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s1}, 16
; QCI-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nest_explicit_s1:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s1}, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    li s4, 0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s1}, 16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nest_explicit_s1:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter.nest
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s1}, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li s4, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s1}, 16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  tail call void asm sideeffect "li s4, 0", "~{s1}"()
  ret void
}

define void @test_nonest_explicit_s1() "interrupt"="qci-nonest" {
; QCI-LABEL: test_nonest_explicit_s1:
; QCI:       # %bb.0:
; QCI-NEXT:    qc.c.mienter
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    .cfi_offset ra, -16
; QCI-NEXT:    .cfi_offset t0, -24
; QCI-NEXT:    .cfi_offset t1, -28
; QCI-NEXT:    .cfi_offset t2, -32
; QCI-NEXT:    .cfi_offset s0, -8
; QCI-NEXT:    .cfi_offset a0, -36
; QCI-NEXT:    .cfi_offset a1, -40
; QCI-NEXT:    .cfi_offset a2, -44
; QCI-NEXT:    .cfi_offset a3, -48
; QCI-NEXT:    .cfi_offset a4, -52
; QCI-NEXT:    .cfi_offset a5, -56
; QCI-NEXT:    .cfi_offset a6, -60
; QCI-NEXT:    .cfi_offset a7, -64
; QCI-NEXT:    .cfi_offset t3, -68
; QCI-NEXT:    .cfi_offset t4, -72
; QCI-NEXT:    .cfi_offset t5, -76
; QCI-NEXT:    .cfi_offset t6, -80
; QCI-NEXT:    addi sp, sp, -16
; QCI-NEXT:    .cfi_def_cfa_offset 112
; QCI-NEXT:    sw s1, 12(sp) # 4-byte Folded Spill
; QCI-NEXT:    .cfi_offset s1, -100
; QCI-NEXT:    #APP
; QCI-NEXT:    li s11, 0
; QCI-NEXT:    #NO_APP
; QCI-NEXT:    lw s1, 12(sp) # 4-byte Folded Reload
; QCI-NEXT:    .cfi_restore s1
; QCI-NEXT:    addi sp, sp, 16
; QCI-NEXT:    .cfi_def_cfa_offset 96
; QCI-NEXT:    qc.c.mileaveret
;
; QCI-FP-LABEL: test_nonest_explicit_s1:
; QCI-FP:       # %bb.0:
; QCI-FP-NEXT:    qc.c.mienter
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    .cfi_offset ra, -16
; QCI-FP-NEXT:    .cfi_offset t0, -24
; QCI-FP-NEXT:    .cfi_offset t1, -28
; QCI-FP-NEXT:    .cfi_offset t2, -32
; QCI-FP-NEXT:    .cfi_offset s0, -8
; QCI-FP-NEXT:    .cfi_offset a0, -36
; QCI-FP-NEXT:    .cfi_offset a1, -40
; QCI-FP-NEXT:    .cfi_offset a2, -44
; QCI-FP-NEXT:    .cfi_offset a3, -48
; QCI-FP-NEXT:    .cfi_offset a4, -52
; QCI-FP-NEXT:    .cfi_offset a5, -56
; QCI-FP-NEXT:    .cfi_offset a6, -60
; QCI-FP-NEXT:    .cfi_offset a7, -64
; QCI-FP-NEXT:    .cfi_offset t3, -68
; QCI-FP-NEXT:    .cfi_offset t4, -72
; QCI-FP-NEXT:    .cfi_offset t5, -76
; QCI-FP-NEXT:    .cfi_offset t6, -80
; QCI-FP-NEXT:    addi sp, sp, -16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-FP-NEXT:    sw s1, 12(sp) # 4-byte Folded Spill
; QCI-FP-NEXT:    .cfi_offset s1, -100
; QCI-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-FP-NEXT:    #APP
; QCI-FP-NEXT:    li s11, 0
; QCI-FP-NEXT:    #NO_APP
; QCI-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-FP-NEXT:    lw s1, 12(sp) # 4-byte Folded Reload
; QCI-FP-NEXT:    .cfi_restore s1
; QCI-FP-NEXT:    addi sp, sp, 16
; QCI-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-FP-NEXT:    qc.c.mileaveret
;
; QCI-PUSH-POP-LABEL: test_nonest_explicit_s1:
; QCI-PUSH-POP:       # %bb.0:
; QCI-PUSH-POP-NEXT:    qc.c.mienter
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-PUSH-POP-NEXT:    cm.push {ra, s0-s1}, -16
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-PUSH-POP-NEXT:    .cfi_offset s1, -100
; QCI-PUSH-POP-NEXT:    #APP
; QCI-PUSH-POP-NEXT:    li s11, 0
; QCI-PUSH-POP-NEXT:    #NO_APP
; QCI-PUSH-POP-NEXT:    cm.pop {ra, s0-s1}, 16
; QCI-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-LABEL: test_nonest_explicit_s1:
; QCI-QCCMP-PUSH-POP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.push {ra, s0-s1}, -16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-NEXT:    li s11, 0
; QCI-QCCMP-PUSH-POP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-NEXT:    qc.cm.pop {ra, s0-s1}, 16
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-NEXT:    qc.c.mileaveret
;
; QCI-QCCMP-PUSH-POP-FP-LABEL: test_nonest_explicit_s1:
; QCI-QCCMP-PUSH-POP-FP:       # %bb.0:
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mienter
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset ra, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t0, -24
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t1, -28
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t2, -32
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s0, -8
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a0, -36
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a1, -40
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a2, -44
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a3, -48
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a4, -52
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a5, -56
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a6, -60
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset a7, -64
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t3, -68
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t4, -72
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t5, -76
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset t6, -80
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.push {ra, s0-s1}, -16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_offset s1, -108
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa s0, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    li s11, 0
; QCI-QCCMP-PUSH-POP-FP-NEXT:    #NO_APP
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa sp, 112
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.cm.pop {ra, s0-s1}, 16
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_restore s1
; QCI-QCCMP-PUSH-POP-FP-NEXT:    .cfi_def_cfa_offset 96
; QCI-QCCMP-PUSH-POP-FP-NEXT:    qc.c.mileaveret
  tail call void asm sideeffect "li s11, 0", "~{s1}"()
  ret void
}
