; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d -loongarch-check-zero-division < %s \
; RUN:     | FileCheck %s --check-prefix=LA32R-TRAP
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d -loongarch-check-zero-division < %s \
; RUN:     | FileCheck %s --check-prefix=LA32S-TRAP
; RUN: llc --mtriple=loongarch64 -mattr=+d -loongarch-check-zero-division < %s \
; RUN:     | FileCheck %s --check-prefix=LA64-TRAP

;; Test the sdiv/udiv/srem/urem LLVM IR.

define i1 @sdiv_i1(i1 %a, i1 %b) {
; LA32R-LABEL: sdiv_i1:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_i1:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_i1:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_i1:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i1 %a, %b
  ret i1 %r
}

define i8 @sdiv_i8(i8 %a, i8 %b) {
; LA32R-LABEL: sdiv_i8:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    slli.w $a1, $a1, 24
; LA32R-NEXT:    srai.w $a1, $a1, 24
; LA32R-NEXT:    slli.w $a0, $a0, 24
; LA32R-NEXT:    srai.w $a0, $a0, 24
; LA32R-NEXT:    div.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_i8:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    ext.w.b $a1, $a1
; LA32S-NEXT:    ext.w.b $a0, $a0
; LA32S-NEXT:    div.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.b $a1, $a1
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_i8:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    slli.w $a1, $a1, 24
; LA32R-TRAP-NEXT:    srai.w $a1, $a1, 24
; LA32R-TRAP-NEXT:    slli.w $a0, $a0, 24
; LA32R-TRAP-NEXT:    srai.w $a0, $a0, 24
; LA32R-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB1_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB1_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_i8:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    ext.w.b $a1, $a1
; LA32S-TRAP-NEXT:    ext.w.b $a0, $a0
; LA32S-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB1_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB1_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.b $a1, $a1
; LA64-TRAP-NEXT:    ext.w.b $a0, $a0
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB1_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB1_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i8 %a, %b
  ret i8 %r
}

define i16 @sdiv_i16(i16 %a, i16 %b) {
; LA32R-LABEL: sdiv_i16:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    slli.w $a1, $a1, 16
; LA32R-NEXT:    srai.w $a1, $a1, 16
; LA32R-NEXT:    slli.w $a0, $a0, 16
; LA32R-NEXT:    srai.w $a0, $a0, 16
; LA32R-NEXT:    div.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_i16:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    ext.w.h $a1, $a1
; LA32S-NEXT:    ext.w.h $a0, $a0
; LA32S-NEXT:    div.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.h $a1, $a1
; LA64-NEXT:    ext.w.h $a0, $a0
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_i16:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    slli.w $a1, $a1, 16
; LA32R-TRAP-NEXT:    srai.w $a1, $a1, 16
; LA32R-TRAP-NEXT:    slli.w $a0, $a0, 16
; LA32R-TRAP-NEXT:    srai.w $a0, $a0, 16
; LA32R-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB2_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB2_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_i16:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    ext.w.h $a1, $a1
; LA32S-TRAP-NEXT:    ext.w.h $a0, $a0
; LA32S-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB2_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB2_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.h $a1, $a1
; LA64-TRAP-NEXT:    ext.w.h $a0, $a0
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB2_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB2_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i16 %a, %b
  ret i16 %r
}

define i32 @sdiv_i32(i32 %a, i32 %b) {
; LA32R-LABEL: sdiv_i32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_i32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_i32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB3_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB3_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_i32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB3_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB3_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB3_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB3_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define i32 @sdiv_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: sdiv_ui32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_ui32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_ui32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB4_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB4_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_ui32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB4_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB4_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB4_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB4_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define signext i32 @sdiv_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32R-LABEL: sdiv_si32_ui32_ui32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_si32_ui32_ui32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_si32_ui32_ui32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB5_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB5_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_si32_ui32_ui32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB5_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB5_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB5_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB5_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define signext i32 @sdiv_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: sdiv_si32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_si32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_si32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB6_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB6_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_si32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB6_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB6_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB6_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB6_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define i64 @sdiv_i64(i64 %a, i64 %b) {
; LA32R-LABEL: sdiv_i64:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    .cfi_def_cfa_offset 16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    .cfi_offset 1, -4
; LA32R-NEXT:    bl __divdi3
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: sdiv_i64:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    .cfi_def_cfa_offset 16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    .cfi_offset 1, -4
; LA32S-NEXT:    bl __divdi3
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: sdiv_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: sdiv_i64:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32R-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32R-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-TRAP-NEXT:    .cfi_offset 1, -4
; LA32R-TRAP-NEXT:    bl __divdi3
; LA32R-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: sdiv_i64:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32S-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32S-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-TRAP-NEXT:    .cfi_offset 1, -4
; LA32S-TRAP-NEXT:    bl __divdi3
; LA32S-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB7_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB7_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i64 %a, %b
  ret i64 %r
}

define i1 @udiv_i1(i1 %a, i1 %b) {
; LA32R-LABEL: udiv_i1:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_i1:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_i1:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_i1:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i1 %a, %b
  ret i1 %r
}

define i8 @udiv_i8(i8 %a, i8 %b) {
; LA32R-LABEL: udiv_i8:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    andi $a0, $a0, 255
; LA32R-NEXT:    div.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_i8:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    andi $a0, $a0, 255
; LA32S-NEXT:    div.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    div.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_i8:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    andi $a1, $a1, 255
; LA32R-TRAP-NEXT:    andi $a0, $a0, 255
; LA32R-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB9_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB9_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_i8:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    andi $a1, $a1, 255
; LA32S-TRAP-NEXT:    andi $a0, $a0, 255
; LA32S-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB9_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB9_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    andi $a1, $a1, 255
; LA64-TRAP-NEXT:    andi $a0, $a0, 255
; LA64-TRAP-NEXT:    div.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB9_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB9_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i8 %a, %b
  ret i8 %r
}

define i16 @udiv_i16(i16 %a, i16 %b) {
; LA32R-LABEL: udiv_i16:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    div.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_i16:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-NEXT:    div.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    div.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_i16:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    lu12i.w $a2, 15
; LA32R-TRAP-NEXT:    ori $a2, $a2, 4095
; LA32R-TRAP-NEXT:    and $a1, $a1, $a2
; LA32R-TRAP-NEXT:    and $a0, $a0, $a2
; LA32R-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB10_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB10_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_i16:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-TRAP-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB10_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB10_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-TRAP-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-TRAP-NEXT:    div.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB10_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB10_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i16 %a, %b
  ret i16 %r
}

define i32 @udiv_i32(i32 %a, i32 %b) {
; LA32R-LABEL: udiv_i32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_i32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_i32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB11_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB11_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_i32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB11_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB11_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB11_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB11_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define i32 @udiv_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: udiv_ui32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_ui32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_ui32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB12_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB12_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_ui32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB12_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB12_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB12_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB12_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define signext i32 @udiv_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32R-LABEL: udiv_si32_ui32_ui32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_si32_ui32_ui32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_si32_ui32_ui32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB13_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB13_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_si32_ui32_ui32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB13_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB13_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB13_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB13_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define signext i32 @udiv_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: udiv_si32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    div.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_si32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    div.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_si32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB14_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB14_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_si32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB14_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB14_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB14_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB14_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define i64 @udiv_i64(i64 %a, i64 %b) {
; LA32R-LABEL: udiv_i64:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    .cfi_def_cfa_offset 16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    .cfi_offset 1, -4
; LA32R-NEXT:    bl __udivdi3
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: udiv_i64:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    .cfi_def_cfa_offset 16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    .cfi_offset 1, -4
; LA32S-NEXT:    bl __udivdi3
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: udiv_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: udiv_i64:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32R-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32R-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-TRAP-NEXT:    .cfi_offset 1, -4
; LA32R-TRAP-NEXT:    bl __udivdi3
; LA32R-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: udiv_i64:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32S-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32S-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-TRAP-NEXT:    .cfi_offset 1, -4
; LA32S-TRAP-NEXT:    bl __udivdi3
; LA32S-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB15_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB15_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i64 %a, %b
  ret i64 %r
}

define i1 @srem_i1(i1 %a, i1 %b) {
; LA32R-LABEL: srem_i1:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    move $a0, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_i1:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    move $a0, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_i1:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    move $a0, $zero
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_i1:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    move $a0, $zero
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    move $a0, $zero
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i1 %a, %b
  ret i1 %r
}

define i8 @srem_i8(i8 %a, i8 %b) {
; LA32R-LABEL: srem_i8:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    slli.w $a1, $a1, 24
; LA32R-NEXT:    srai.w $a1, $a1, 24
; LA32R-NEXT:    slli.w $a0, $a0, 24
; LA32R-NEXT:    srai.w $a0, $a0, 24
; LA32R-NEXT:    mod.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_i8:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    ext.w.b $a1, $a1
; LA32S-NEXT:    ext.w.b $a0, $a0
; LA32S-NEXT:    mod.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.b $a1, $a1
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_i8:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    slli.w $a1, $a1, 24
; LA32R-TRAP-NEXT:    srai.w $a1, $a1, 24
; LA32R-TRAP-NEXT:    slli.w $a0, $a0, 24
; LA32R-TRAP-NEXT:    srai.w $a0, $a0, 24
; LA32R-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB17_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB17_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_i8:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    ext.w.b $a1, $a1
; LA32S-TRAP-NEXT:    ext.w.b $a0, $a0
; LA32S-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB17_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB17_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.b $a1, $a1
; LA64-TRAP-NEXT:    ext.w.b $a0, $a0
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB17_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB17_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i8 %a, %b
  ret i8 %r
}

define i16 @srem_i16(i16 %a, i16 %b) {
; LA32R-LABEL: srem_i16:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    slli.w $a1, $a1, 16
; LA32R-NEXT:    srai.w $a1, $a1, 16
; LA32R-NEXT:    slli.w $a0, $a0, 16
; LA32R-NEXT:    srai.w $a0, $a0, 16
; LA32R-NEXT:    mod.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_i16:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    ext.w.h $a1, $a1
; LA32S-NEXT:    ext.w.h $a0, $a0
; LA32S-NEXT:    mod.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.h $a1, $a1
; LA64-NEXT:    ext.w.h $a0, $a0
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_i16:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    slli.w $a1, $a1, 16
; LA32R-TRAP-NEXT:    srai.w $a1, $a1, 16
; LA32R-TRAP-NEXT:    slli.w $a0, $a0, 16
; LA32R-TRAP-NEXT:    srai.w $a0, $a0, 16
; LA32R-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB18_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB18_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_i16:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    ext.w.h $a1, $a1
; LA32S-TRAP-NEXT:    ext.w.h $a0, $a0
; LA32S-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB18_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB18_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.h $a1, $a1
; LA64-TRAP-NEXT:    ext.w.h $a0, $a0
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB18_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB18_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i16 %a, %b
  ret i16 %r
}

define i32 @srem_i32(i32 %a, i32 %b) {
; LA32R-LABEL: srem_i32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_i32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_i32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB19_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB19_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_i32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB19_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB19_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB19_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB19_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define i32 @srem_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: srem_ui32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_ui32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_ui32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB20_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB20_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_ui32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB20_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB20_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB20_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB20_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define signext i32 @srem_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32R-LABEL: srem_si32_ui32_ui32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_si32_ui32_ui32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_si32_ui32_ui32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB21_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB21_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_si32_ui32_ui32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB21_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB21_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB21_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB21_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define signext i32 @srem_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: srem_si32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_si32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_si32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB22_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB22_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_si32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB22_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB22_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB22_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB22_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define i64 @srem_i64(i64 %a, i64 %b) {
; LA32R-LABEL: srem_i64:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    .cfi_def_cfa_offset 16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    .cfi_offset 1, -4
; LA32R-NEXT:    bl __moddi3
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: srem_i64:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    .cfi_def_cfa_offset 16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    .cfi_offset 1, -4
; LA32S-NEXT:    bl __moddi3
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: srem_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: srem_i64:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32R-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32R-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-TRAP-NEXT:    .cfi_offset 1, -4
; LA32R-TRAP-NEXT:    bl __moddi3
; LA32R-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: srem_i64:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32S-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32S-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-TRAP-NEXT:    .cfi_offset 1, -4
; LA32S-TRAP-NEXT:    bl __moddi3
; LA32S-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB23_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB23_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i64 %a, %b
  ret i64 %r
}

define i1 @urem_i1(i1 %a, i1 %b) {
; LA32R-LABEL: urem_i1:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    move $a0, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_i1:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    move $a0, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_i1:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    move $a0, $zero
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_i1:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    move $a0, $zero
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    move $a0, $zero
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i1 %a, %b
  ret i1 %r
}

define i8 @urem_i8(i8 %a, i8 %b) {
; LA32R-LABEL: urem_i8:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    andi $a1, $a1, 255
; LA32R-NEXT:    andi $a0, $a0, 255
; LA32R-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_i8:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    andi $a1, $a1, 255
; LA32S-NEXT:    andi $a0, $a0, 255
; LA32S-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    mod.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_i8:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    andi $a1, $a1, 255
; LA32R-TRAP-NEXT:    andi $a0, $a0, 255
; LA32R-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB25_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB25_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_i8:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    andi $a1, $a1, 255
; LA32S-TRAP-NEXT:    andi $a0, $a0, 255
; LA32S-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB25_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB25_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    andi $a1, $a1, 255
; LA64-TRAP-NEXT:    andi $a0, $a0, 255
; LA64-TRAP-NEXT:    mod.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB25_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB25_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i8 %a, %b
  ret i8 %r
}

define i16 @urem_i16(i16 %a, i16 %b) {
; LA32R-LABEL: urem_i16:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 4095
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_i16:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    mod.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_i16:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    lu12i.w $a2, 15
; LA32R-TRAP-NEXT:    ori $a2, $a2, 4095
; LA32R-TRAP-NEXT:    and $a1, $a1, $a2
; LA32R-TRAP-NEXT:    and $a0, $a0, $a2
; LA32R-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB26_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB26_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_i16:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32S-TRAP-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB26_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB26_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-TRAP-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-TRAP-NEXT:    mod.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB26_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB26_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i16 %a, %b
  ret i16 %r
}

define i32 @urem_i32(i32 %a, i32 %b) {
; LA32R-LABEL: urem_i32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_i32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_i32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB27_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB27_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_i32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB27_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB27_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB27_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB27_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define i32 @urem_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: urem_ui32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_ui32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_ui32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB28_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB28_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_ui32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB28_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB28_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB28_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB28_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define signext i32 @urem_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32R-LABEL: urem_si32_ui32_ui32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_si32_ui32_ui32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_si32_ui32_ui32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB29_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB29_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_si32_ui32_ui32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB29_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB29_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB29_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB29_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define signext i32 @urem_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: urem_si32_si32_si32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_si32_si32_si32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_si32_si32_si32:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32R-TRAP-NEXT:    bne $a1, $zero, .LBB30_2
; LA32R-TRAP-NEXT:  # %bb.1: # %entry
; LA32R-TRAP-NEXT:    break 7
; LA32R-TRAP-NEXT:  .LBB30_2: # %entry
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_si32_si32_si32:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32S-TRAP-NEXT:    bne $a1, $zero, .LBB30_2
; LA32S-TRAP-NEXT:  # %bb.1: # %entry
; LA32S-TRAP-NEXT:    break 7
; LA32S-TRAP-NEXT:  .LBB30_2: # %entry
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB30_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB30_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define i64 @urem_i64(i64 %a, i64 %b) {
; LA32R-LABEL: urem_i64:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    .cfi_def_cfa_offset 16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    .cfi_offset 1, -4
; LA32R-NEXT:    bl __umoddi3
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: urem_i64:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    .cfi_def_cfa_offset 16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    .cfi_offset 1, -4
; LA32S-NEXT:    bl __umoddi3
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: urem_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: urem_i64:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32R-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32R-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-TRAP-NEXT:    .cfi_offset 1, -4
; LA32R-TRAP-NEXT:    bl __umoddi3
; LA32R-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: urem_i64:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32S-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32S-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-TRAP-NEXT:    .cfi_offset 1, -4
; LA32S-TRAP-NEXT:    bl __umoddi3
; LA32S-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bne $a1, $zero, .LBB31_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB31_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i64 %a, %b
  ret i64 %r
}

define signext i32 @pr107414(i32 signext %x) {
; LA32R-LABEL: pr107414:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    .cfi_def_cfa_offset 16
; LA32R-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-NEXT:    .cfi_offset 1, -4
; LA32R-NEXT:    move $a2, $a0
; LA32R-NEXT:    srai.w $a3, $a0, 31
; LA32R-NEXT:    lu12i.w $a0, -266831
; LA32R-NEXT:    ori $a0, $a0, 3337
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    bl __divdi3
; LA32R-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: pr107414:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    .cfi_def_cfa_offset 16
; LA32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    .cfi_offset 1, -4
; LA32S-NEXT:    move $a2, $a0
; LA32S-NEXT:    srai.w $a3, $a0, 31
; LA32S-NEXT:    lu12i.w $a0, -266831
; LA32S-NEXT:    ori $a0, $a0, 3337
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    bl __divdi3
; LA32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: pr107414:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    lu12i.w $a1, -266831
; LA64-NEXT:    ori $a1, $a1, 3337
; LA64-NEXT:    lu32i.d $a1, 0
; LA64-NEXT:    div.d $a0, $a1, $a0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    ret
;
; LA32R-TRAP-LABEL: pr107414:
; LA32R-TRAP:       # %bb.0: # %entry
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32R-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32R-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32R-TRAP-NEXT:    .cfi_offset 1, -4
; LA32R-TRAP-NEXT:    move $a2, $a0
; LA32R-TRAP-NEXT:    srai.w $a3, $a0, 31
; LA32R-TRAP-NEXT:    lu12i.w $a0, -266831
; LA32R-TRAP-NEXT:    ori $a0, $a0, 3337
; LA32R-TRAP-NEXT:    move $a1, $zero
; LA32R-TRAP-NEXT:    bl __divdi3
; LA32R-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32R-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32R-TRAP-NEXT:    ret
;
; LA32S-TRAP-LABEL: pr107414:
; LA32S-TRAP:       # %bb.0: # %entry
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32S-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32S-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32S-TRAP-NEXT:    .cfi_offset 1, -4
; LA32S-TRAP-NEXT:    move $a2, $a0
; LA32S-TRAP-NEXT:    srai.w $a3, $a0, 31
; LA32S-TRAP-NEXT:    lu12i.w $a0, -266831
; LA32S-TRAP-NEXT:    ori $a0, $a0, 3337
; LA32S-TRAP-NEXT:    move $a1, $zero
; LA32S-TRAP-NEXT:    bl __divdi3
; LA32S-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32S-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32S-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: pr107414:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    lu12i.w $a1, -266831
; LA64-TRAP-NEXT:    ori $a1, $a1, 3337
; LA64-TRAP-NEXT:    lu32i.d $a1, 0
; LA64-TRAP-NEXT:    div.d $a1, $a1, $a0
; LA64-TRAP-NEXT:    bne $a0, $zero, .LBB32_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB32_2: # %entry
; LA64-TRAP-NEXT:    addi.w $a0, $a1, 0
; LA64-TRAP-NEXT:    ret
entry:
  %conv = sext i32 %x to i64
  %div = sdiv i64 3202030857, %conv
  %conv1 = trunc i64 %div to i32
  ret i32 %conv1
}
