; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <4 x i16> @z_i32_v4i16(i32 %x) {
; CHECK-SD-LABEL: z_i32_v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: z_i32_v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    mov b1, v0.b[1]
; CHECK-GI-NEXT:    mov v2.b[0], v0.b[0]
; CHECK-GI-NEXT:    mov b3, v0.b[2]
; CHECK-GI-NEXT:    mov b0, v0.b[3]
; CHECK-GI-NEXT:    mov v2.b[1], v1.b[0]
; CHECK-GI-NEXT:    mov v2.b[2], v3.b[0]
; CHECK-GI-NEXT:    mov v2.b[3], v0.b[0]
; CHECK-GI-NEXT:    ushll v0.8h, v2.8b, #0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %b = bitcast i32 %x to <4 x i8>
  %e = zext <4 x i8> %b to <4 x i16>
  ret <4 x i16> %e
}

define <4 x i32> @z_i32_v4i32(i32 %x) {
; CHECK-SD-LABEL: z_i32_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: z_i32_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    mov b1, v0.b[2]
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    uxtb w8, w8
; CHECK-GI-NEXT:    fmov w10, s2
; CHECK-GI-NEXT:    fmov w11, s3
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    uxtb w9, w9
; CHECK-GI-NEXT:    uxtb w10, w10
; CHECK-GI-NEXT:    uxtb w11, w11
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov v0.h[1], w10
; CHECK-GI-NEXT:    mov v1.h[1], w11
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ret
  %b = bitcast i32 %x to <4 x i8>
  %e = zext <4 x i8> %b to <4 x i32>
  ret <4 x i32> %e
}

define <4 x i64> @z_i32_v4i64(i32 %x) {
; CHECK-SD-LABEL: z_i32_v4i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    movi v1.2d, #0x000000000000ff
; CHECK-SD-NEXT:    mov b2, v0.b[0]
; CHECK-SD-NEXT:    mov b3, v0.b[2]
; CHECK-SD-NEXT:    mov v2.b[4], v0.b[1]
; CHECK-SD-NEXT:    mov v3.b[4], v0.b[3]
; CHECK-SD-NEXT:    ushll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v3.2s, #0
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    and v1.16b, v2.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: z_i32_v4i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    mov b1, v0.b[2]
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    ubfx x8, x8, #0, #8
; CHECK-GI-NEXT:    fmov w10, s2
; CHECK-GI-NEXT:    fmov w11, s3
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ubfx x9, x9, #0, #8
; CHECK-GI-NEXT:    ubfx x10, x10, #0, #8
; CHECK-GI-NEXT:    ubfx x11, x11, #0, #8
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    mov v0.d[1], x10
; CHECK-GI-NEXT:    mov v1.d[1], x11
; CHECK-GI-NEXT:    ret
  %b = bitcast i32 %x to <4 x i8>
  %e = zext <4 x i8> %b to <4 x i64>
  ret <4 x i64> %e
}

define <4 x i16> @s_i32_v4i16(i32 %x) {
; CHECK-SD-LABEL: s_i32_v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: s_i32_v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    mov b1, v0.b[1]
; CHECK-GI-NEXT:    mov v2.b[0], v0.b[0]
; CHECK-GI-NEXT:    mov b3, v0.b[2]
; CHECK-GI-NEXT:    mov b0, v0.b[3]
; CHECK-GI-NEXT:    mov v2.b[1], v1.b[0]
; CHECK-GI-NEXT:    mov v2.b[2], v3.b[0]
; CHECK-GI-NEXT:    mov v2.b[3], v0.b[0]
; CHECK-GI-NEXT:    sshll v0.8h, v2.8b, #0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %b = bitcast i32 %x to <4 x i8>
  %e = sext <4 x i8> %b to <4 x i16>
  ret <4 x i16> %e
}

define <4 x i32> @s_i32_v4i32(i32 %x) {
; CHECK-SD-LABEL: s_i32_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #24
; CHECK-SD-NEXT:    sshr v0.4s, v0.4s, #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: s_i32_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    mov b1, v0.b[2]
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    sxtb w8, w8
; CHECK-GI-NEXT:    fmov w10, s2
; CHECK-GI-NEXT:    fmov w11, s3
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    sxtb w9, w9
; CHECK-GI-NEXT:    sxtb w10, w10
; CHECK-GI-NEXT:    sxtb w11, w11
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    mov v0.h[1], w10
; CHECK-GI-NEXT:    mov v1.h[1], w11
; CHECK-GI-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll v1.4s, v1.4h, #0
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ret
  %b = bitcast i32 %x to <4 x i8>
  %e = sext <4 x i8> %b to <4 x i32>
  ret <4 x i32> %e
}

define <4 x i64> @s_i32_v4i64(i32 %x) {
; CHECK-SD-LABEL: s_i32_v4i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    mov b1, v0.b[0]
; CHECK-SD-NEXT:    mov b2, v0.b[2]
; CHECK-SD-NEXT:    mov v1.b[4], v0.b[1]
; CHECK-SD-NEXT:    mov v2.b[4], v0.b[3]
; CHECK-SD-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll v1.2d, v2.2s, #0
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #56
; CHECK-SD-NEXT:    shl v1.2d, v1.2d, #56
; CHECK-SD-NEXT:    sshr v0.2d, v0.2d, #56
; CHECK-SD-NEXT:    sshr v1.2d, v1.2d, #56
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: s_i32_v4i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    mov b1, v0.b[2]
; CHECK-GI-NEXT:    mov b2, v0.b[1]
; CHECK-GI-NEXT:    mov b3, v0.b[3]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    sxtb x8, w8
; CHECK-GI-NEXT:    fmov w10, s2
; CHECK-GI-NEXT:    fmov w11, s3
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    sxtb x9, w9
; CHECK-GI-NEXT:    sxtb x10, w10
; CHECK-GI-NEXT:    sxtb x11, w11
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    mov v0.d[1], x10
; CHECK-GI-NEXT:    mov v1.d[1], x11
; CHECK-GI-NEXT:    ret
  %b = bitcast i32 %x to <4 x i8>
  %e = sext <4 x i8> %b to <4 x i64>
  ret <4 x i64> %e
}

define void @extractbitcastext(i32 %bytes, ptr %output) {
; CHECK-SD-LABEL: extractbitcastext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    fmov d0, x0
; CHECK-SD-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    stp q1, q0, [x1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extractbitcastext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    sxtw x8, w0
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    stp q1, q0, [x1]
; CHECK-GI-NEXT:    ret
  %conv = sext i32 %bytes to i64
  %b0 = bitcast i64 %conv to <8 x i8>
  %b1 = zext <8 x i8> %b0 to <8 x i16>
  %shuffle.i = shufflevector <8 x i16> %b1, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %z2 = zext nneg <4 x i16> %shuffle.i to <4 x i32>
  %shuffle.i23 = shufflevector <4 x i32> %z2, <4 x i32> poison, <2 x i32> <i32 0, i32 1>
  %z3 = zext nneg <2 x i32> %shuffle.i23 to <2 x i64>
  %shuffle.i24 = shufflevector <4 x i32> %z2, <4 x i32> poison, <2 x i32> <i32 2, i32 3>
  %z4 = zext nneg <2 x i32> %shuffle.i24 to <2 x i64>
  store <2 x i64> %z3, ptr %output, align 8
  %add.ptr = getelementptr inbounds nuw i8, ptr %output, i64 16
  store <2 x i64> %z4, ptr %add.ptr, align 8
  ret void
}

define void @extractbitcastext_s(i32 %bytes, ptr %output) {
; CHECK-SD-LABEL: extractbitcastext_s:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    fmov d0, x0
; CHECK-SD-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll v1.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    stp q1, q0, [x1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extractbitcastext_s:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    sxtw x8, w0
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    stp q1, q0, [x1]
; CHECK-GI-NEXT:    ret
  %conv = sext i32 %bytes to i64
  %b0 = bitcast i64 %conv to <8 x i8>
  %b1 = sext <8 x i8> %b0 to <8 x i16>
  %shuffle.i = shufflevector <8 x i16> %b1, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s2 = sext <4 x i16> %shuffle.i to <4 x i32>
  %shuffle.i23 = shufflevector <4 x i32> %s2, <4 x i32> poison, <2 x i32> <i32 0, i32 1>
  %s3 = sext <2 x i32> %shuffle.i23 to <2 x i64>
  %shuffle.i24 = shufflevector <4 x i32> %s2, <4 x i32> poison, <2 x i32> <i32 2, i32 3>
  %s4 = sext <2 x i32> %shuffle.i24 to <2 x i64>
  store <2 x i64> %s3, ptr %output, align 8
  %add.ptr = getelementptr inbounds nuw i8, ptr %output, i64 16
  store <2 x i64> %s4, ptr %add.ptr, align 8
  ret void
}


;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
