macro(check_project_file projectFile outvar)
  set(insideConfiguration FALSE)
  set(characterSetFound FALSE)

  if(NOT EXISTS "${projectFile}")
    set(RunCMake_TEST_FAILED "Project file ${projectFile} does not exist.")
    return()
  endif()

  string(REPLACE "${RunCMake_TEST_BINARY_DIR}/" "" projectName ${projectFile})

  file(STRINGS "${projectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<PropertyGroup Condition=\"'[$][(]Configuration[)]|[$][(]Platform[)]'=='([^\"])+\" Label=\"Configuration\">.*$")
      set(insideConfiguration TRUE)
    elseif(insideConfiguration)
      if(line MATCHES "^ *</PropertyGroup>.*$")
        set(insideConfiguration FALSE)
      elseif(line MATCHES "^ *<CharacterSet>(.+)</CharacterSet>*$")
        message(STATUS "Found CharacterSet = ${CMAKE_MATCH_1} in PropertyGroup 'Configuration' in ${projectName}")
        set(characterSetFound TRUE)
        set(${outvar} ${CMAKE_MATCH_1})
      endif()
    endif()
  endforeach()
  if(NOT characterSetFound)
    set(RunCMake_TEST_FAILED "CharacterSet not found in \"Configuration\" propertygroup in ${projectName}")
    return() # This should intentionally return from the caller, not the macro
  endif()
endmacro()

check_project_file("${RunCMake_TEST_BINARY_DIR}/CMakeFiles/${CMAKE_VERSION}/CompilerIdCXX/CompilerIdCXX.vcxproj" MULTI_BYTE_CHARSET)
check_project_file("${RunCMake_TEST_BINARY_DIR}/foo.vcxproj" OVERRIDDEN_CHARSET)

if (NOT "${MULTI_BYTE_CHARSET}" STREQUAL "MultiByte")
  set(RunCMake_TEST_FAILED "Default character-set (\"MultiByte\") was overridden (it shouldn't)")
  return()
endif()

if(NOT EXISTS "${RunCMake_TEST_BINARY_DIR}/set_charset.txt")
  set(RunCMake_TEST_FAILED "File 'set_charset.txt' with set charset does not exist.")
  return()
endif()
file(STRINGS "${RunCMake_TEST_BINARY_DIR}/set_charset.txt" SET_CHARSET)

if (NOT "${OVERRIDDEN_CHARSET}" STREQUAL "${SET_CHARSET}")
  set(RunCMake_TEST_FAILED "Failed to override the character-set with \"${SET_CHARSET}\"")
  return()
endif()
