; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -S -p vector-combine | FileCheck %s

; FIXME: The way we scalarize this today is by creating a
;
; %v = udiv <4 x i8> splat (i8 1), <i8 0, i8 1, i8 1, i8 1>
;
; to insert the scalar into, which is immediate UB.  Coincidentally, at creation
; this gets constant folded into <i8 poison, i8 1, i8 1, i8 1>, but we shouldn't
; rely on this.
define <4 x i8> @udiv_ub(i8 %x, i8 %y) {
; CHECK-LABEL: define <4 x i8> @udiv_ub(
; CHECK-SAME: i8 [[X:%.*]], i8 [[Y:%.*]]) {
; CHECK-NEXT:    [[V_SCALAR:%.*]] = udiv i8 [[X]], [[Y]]
; CHECK-NEXT:    [[V:%.*]] = insertelement <4 x i8> <i8 poison, i8 1, i8 1, i8 1>, i8 [[V_SCALAR]], i64 0
; CHECK-NEXT:    ret <4 x i8> [[V]]
;
  %x.insert = insertelement <4 x i8> splat (i8 1), i8 %x, i32 0
  %y.insert = insertelement <4 x i8> <i8 0, i8 1, i8 1, i8 1>, i8 %y, i32 0
  %v = udiv <4 x i8> %x.insert, %y.insert
  ret <4 x i8> %v
}


; Unfoldable constant expression may cause infinite loop between 
; scalarizing insertelement and folding binop(insert(x,a,idx),insert(y,b,idx))
@val = external hidden global ptr, align 8

define <2 x i64> @pr153012(i64 %idx) #0 {
; CHECK-LABEL: define <2 x i64> @pr153012(
; CHECK-SAME: i64 [[IDX:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A:%.*]] = insertelement <2 x i64> <i64 5, i64 ptrtoint (ptr @val to i64)>, i64 [[IDX]], i32 0
; CHECK-NEXT:    [[B:%.*]] = or disjoint <2 x i64> splat (i64 2), [[A]]
; CHECK-NEXT:    ret <2 x i64> [[B]]
;
entry:
  %a = insertelement <2 x i64> <i64 5, i64 ptrtoint (ptr @val to i64)>, i64 %idx, i32 0
  %b = or disjoint <2 x i64> splat (i64 2), %a
  ret <2 x i64> %b
}
