; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse3 | FileCheck %s --check-prefixes=SSE3
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+xop,+avx | FileCheck %s -check-prefixes=XOPAVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+xop,+avx2 | FileCheck %s -check-prefixes=XOPAVX2
;
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=goldmont | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1

define i32 @cmp_int_eq(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_eq'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_eq'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_eq'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_eq'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_eq'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_eq'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_eq'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_eq'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_eq'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_eq'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_eq'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_eq'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp eq i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp eq i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp eq i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp eq i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp eq i8 %arg8, %arg8
  %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp eq i16 %arg16, %arg16
  %V8I16  = icmp eq <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp eq i32 %arg32, %arg32
  %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp eq i64 %arg64, %arg64
  %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ne(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ne'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ne'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ne'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ne'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ne'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:24 SizeLat:24 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ne'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ne'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ne'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ne'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ne'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ne'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ne'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ne i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ne i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ne i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ne i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:3 for: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:6 for: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:24 SizeLat:12 for: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:48 SizeLat:24 for: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ne i8 %arg8, %arg8
  %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ne i16 %arg16, %arg16
  %V8I16  = icmp ne <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ne i32 %arg32, %arg32
  %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ne i64 %arg64, %arg64
  %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_sge(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sge'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_sge'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_sge'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_sge'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sge'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:24 SizeLat:24 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sge'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sge'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sge'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sge'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sge'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sge'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_sge'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sge i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sge i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sge i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sge i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:3 for: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:6 for: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:24 SizeLat:12 for: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:48 SizeLat:24 for: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp sge i8 %arg8, %arg8
  %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp sge i16 %arg16, %arg16
  %V8I16  = icmp sge <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp sge i32 %arg32, %arg32
  %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp sge i64 %arg64, %arg64
  %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_uge(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_uge'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 32 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_uge'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 32 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_uge'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 32 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_uge'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_uge'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:5 SizeLat:5 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:10 SizeLat:10 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:20 SizeLat:20 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:40 SizeLat:40 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_uge'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:5 SizeLat:5 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:8 Lat:5 SizeLat:9 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:16 Lat:10 SizeLat:18 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:32 Lat:20 SizeLat:36 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_uge'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:5 SizeLat:5 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:10 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:16 SizeLat:20 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_uge'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_uge'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_uge'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_uge'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:10 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:16 SizeLat:20 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_uge'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp uge i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp uge i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp uge i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp uge i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:8 SizeLat:5 for: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:8 Lat:16 SizeLat:10 for: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:16 Lat:32 SizeLat:20 for: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:32 Lat:64 SizeLat:40 for: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp uge i8 %arg8, %arg8
  %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp uge i16 %arg16, %arg16
  %V8I16  = icmp uge <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp uge i32 %arg32, %arg32
  %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp uge i64 %arg64, %arg64
  %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_sgt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sgt'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_sgt'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_sgt'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_sgt'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sgt'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sgt'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sgt'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sgt'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sgt'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sgt'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sgt'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_sgt'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sgt i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sgt i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sgt i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sgt i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp sgt i8 %arg8, %arg8
  %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp sgt i16 %arg16, %arg16
  %V8I16  = icmp sgt <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp sgt i32 %arg32, %arg32
  %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp sgt i64 %arg64, %arg64
  %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ugt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ugt'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ugt'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ugt'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ugt'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ugt'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:8 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:16 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:32 SizeLat:32 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ugt'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ugt'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ugt'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:9 SizeLat:7 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:18 SizeLat:14 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:9 SizeLat:7 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:18 SizeLat:14 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ugt'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ugt'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ugt'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ugt'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ugt i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ugt i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ugt i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ugt i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:4 for: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:6 Lat:14 SizeLat:8 for: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:12 Lat:28 SizeLat:16 for: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:24 Lat:56 SizeLat:32 for: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ugt i8 %arg8, %arg8
  %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ugt i16 %arg16, %arg16
  %V8I16  = icmp ugt <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ugt i32 %arg32, %arg32
  %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ugt i64 %arg64, %arg64
  %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_sle(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sle'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_sle'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_sle'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_sle'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:5 SizeLat:6 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:10 SizeLat:12 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:20 SizeLat:24 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:48 Lat:40 SizeLat:48 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sle'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:24 SizeLat:24 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sle'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sle'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sle'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sle'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sle'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sle'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_sle'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp sle i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp sle i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp sle i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp sle i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:3 for: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:6 for: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:24 SizeLat:12 for: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:48 SizeLat:24 for: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp sle i8 %arg8, %arg8
  %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp sle i16 %arg16, %arg16
  %V8I16  = icmp sle <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp sle i32 %arg32, %arg32
  %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp sle i64 %arg64, %arg64
  %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ule(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ule'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 16 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 32 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ule'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 16 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 32 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ule'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 16 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 32 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ule'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:7 SizeLat:8 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:14 SizeLat:16 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:28 SizeLat:32 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:64 Lat:56 SizeLat:64 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ule'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:5 SizeLat:5 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:10 SizeLat:10 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:20 SizeLat:20 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:32 Lat:40 SizeLat:40 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ule'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:3 SizeLat:7 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:6 SizeLat:14 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:12 SizeLat:28 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:5 SizeLat:5 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:8 Lat:5 SizeLat:9 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:16 Lat:10 SizeLat:18 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:32 Lat:20 SizeLat:36 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ule'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:5 SizeLat:5 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:10 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:16 SizeLat:20 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ule'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:6 Lat:8 SizeLat:6 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:16 SizeLat:12 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ule'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ule'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ule'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:6 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:12 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:5 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:10 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:16 Lat:16 SizeLat:20 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ule'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ule i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ule i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ule i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 16 for: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ule i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:8 SizeLat:5 for: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:8 Lat:16 SizeLat:10 for: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:16 Lat:32 SizeLat:20 for: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:32 Lat:64 SizeLat:40 for: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ule i8 %arg8, %arg8
  %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ule i16 %arg16, %arg16
  %V8I16  = icmp ule <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ule i32 %arg32, %arg32
  %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ule i64 %arg64, %arg64
  %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_slt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_slt'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_slt'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_slt'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_slt'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:4 SizeLat:5 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:8 SizeLat:10 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:16 SizeLat:20 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:32 SizeLat:40 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_slt'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:4 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:8 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:16 SizeLat:16 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_slt'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_slt'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_slt'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:10 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_slt'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_slt'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_slt'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_slt'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp slt i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp slt i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp slt i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp slt i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:8 for: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:16 for: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp slt i8 %arg8, %arg8
  %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp slt i16 %arg16, %arg16
  %V8I16  = icmp slt <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp slt i32 %arg32, %arg32
  %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp slt i64 %arg64, %arg64
  %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ult(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ult'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'cmp_int_ult'
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; SSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; SSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'cmp_int_ult'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSSE3-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSSE3-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSSE3-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_int_ult'
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; SSE41-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSE41-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSE41-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSE41-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; SSE41-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSE41-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSE41-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSE41-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; SSE41-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSE41-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSE41-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSE41-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSE41-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; SSE41-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:6 SizeLat:7 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:12 SizeLat:14 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:24 SizeLat:28 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:48 SizeLat:56 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ult'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:8 SizeLat:8 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:16 SizeLat:16 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:32 SizeLat:32 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ult'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:4 SizeLat:8 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:8 SizeLat:16 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:16 SizeLat:32 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ult'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:4 SizeLat:4 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ult'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:9 SizeLat:7 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:18 SizeLat:14 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:7 Lat:9 SizeLat:7 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:18 SizeLat:14 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ult'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ult'
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:2 SizeLat:6 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:4 SizeLat:12 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:8 SizeLat:24 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ult'
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found costs of 1 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:3 SizeLat:4 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:6 SizeLat:8 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:12 SizeLat:16 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'cmp_int_ult'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = icmp ult i8 %arg8, %arg8
; SLM-NEXT:  Cost Model: Found costs of 3 for: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SLM-NEXT:  Cost Model: Found costs of 6 for: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SLM-NEXT:  Cost Model: Found costs of 12 for: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SLM-NEXT:  Cost Model: Found costs of 24 for: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = icmp ult i16 %arg16, %arg16
; SLM-NEXT:  Cost Model: Found costs of 3 for: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SLM-NEXT:  Cost Model: Found costs of 6 for: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SLM-NEXT:  Cost Model: Found costs of 12 for: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SLM-NEXT:  Cost Model: Found costs of 24 for: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = icmp ult i32 %arg32, %arg32
; SLM-NEXT:  Cost Model: Found costs of 3 for: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SLM-NEXT:  Cost Model: Found costs of 6 for: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SLM-NEXT:  Cost Model: Found costs of 12 for: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SLM-NEXT:  Cost Model: Found costs of 24 for: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = icmp ult i64 %arg64, %arg64
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:7 SizeLat:4 for: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:6 Lat:14 SizeLat:8 for: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:12 Lat:28 SizeLat:16 for: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:24 Lat:56 SizeLat:32 for: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8 = icmp ult i8 %arg8, %arg8
  %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ult i16 %arg16, %arg16
  %V8I16  = icmp ult <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ult i32 %arg32, %arg32
  %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ult i64 %arg64, %arg64
  %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @scmp_int(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'scmp_int'
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:7 SizeLat:7 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:11 SizeLat:11 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:19 Lat:19 SizeLat:19 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:17 Lat:17 SizeLat:17 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:33 Lat:33 SizeLat:33 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:12 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:26 Lat:24 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:52 Lat:48 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:152 CodeSize:104 Lat:96 SizeLat:112 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'scmp_int'
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:7 SizeLat:7 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:11 SizeLat:11 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:19 Lat:19 SizeLat:19 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:17 Lat:17 SizeLat:17 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:33 Lat:33 SizeLat:33 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:12 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:26 Lat:24 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:52 Lat:48 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:152 CodeSize:104 Lat:96 SizeLat:112 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'scmp_int'
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:7 SizeLat:7 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:11 SizeLat:11 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:19 Lat:19 SizeLat:19 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:17 Lat:17 SizeLat:17 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:33 Lat:33 SizeLat:33 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:12 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:26 Lat:24 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:52 Lat:48 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:152 CodeSize:104 Lat:96 SizeLat:112 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'scmp_int'
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:7 SizeLat:7 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:11 SizeLat:11 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:19 Lat:19 SizeLat:19 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:12 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:26 Lat:24 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:52 Lat:48 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:104 CodeSize:104 Lat:96 SizeLat:112 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'scmp_int'
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:7 SizeLat:7 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:11 SizeLat:11 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE42-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:19 Lat:19 SizeLat:19 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE42-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:8 SizeLat:8 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:16 SizeLat:16 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:20 Lat:32 SizeLat:32 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:40 Lat:64 SizeLat:64 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'scmp_int'
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:17 Lat:8 SizeLat:20 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:32 Lat:14 SizeLat:38 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX1-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:62 Lat:26 SizeLat:74 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:32 Lat:14 SizeLat:38 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:62 Lat:26 SizeLat:74 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:34 Lat:16 SizeLat:40 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX1-NEXT:  Cost Model: Found costs of RThru:74 CodeSize:62 Lat:26 SizeLat:74 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:7 SizeLat:7 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:34 Lat:16 SizeLat:40 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:68 Lat:32 SizeLat:80 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'scmp_int'
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:5 SizeLat:8 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:8 Lat:8 SizeLat:14 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:14 Lat:14 SizeLat:26 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:5 SizeLat:8 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:8 SizeLat:14 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:14 Lat:14 SizeLat:26 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:5 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:14 Lat:14 SizeLat:26 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:7 SizeLat:7 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:5 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:16 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:20 Lat:20 SizeLat:32 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'scmp_int'
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:5 Lat:5 SizeLat:5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:5 Lat:5 SizeLat:8 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:47 CodeSize:17 Lat:23 SizeLat:17 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:94 CodeSize:32 Lat:44 SizeLat:32 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:5 Lat:5 SizeLat:5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:5 Lat:5 SizeLat:8 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:17 Lat:23 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:54 CodeSize:32 Lat:44 SizeLat:32 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:6 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:9 Lat:9 SizeLat:9 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:6 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:7 Lat:7 SizeLat:7 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'scmp_int'
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:10 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:10 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:7 Lat:7 SizeLat:7 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:7 Lat:7 SizeLat:7 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'scmp_int'
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:17 Lat:8 SizeLat:20 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:32 Lat:14 SizeLat:38 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:62 Lat:26 SizeLat:74 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:32 Lat:14 SizeLat:38 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:62 Lat:26 SizeLat:74 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:34 Lat:16 SizeLat:40 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:74 CodeSize:62 Lat:26 SizeLat:74 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:34 Lat:16 SizeLat:40 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:68 Lat:32 SizeLat:80 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'scmp_int'
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:5 SizeLat:8 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:8 Lat:8 SizeLat:14 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:14 Lat:14 SizeLat:26 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:5 SizeLat:8 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:8 SizeLat:14 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:14 Lat:14 SizeLat:26 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:5 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:14 Lat:14 SizeLat:26 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:5 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:16 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:20 Lat:20 SizeLat:32 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'scmp_int'
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.scmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:7 Lat:7 SizeLat:7 for: %V32I8 = call <32 x i8> @llvm.scmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:11 SizeLat:11 for: %V64I8 = call <64 x i8> @llvm.scmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:19 Lat:19 SizeLat:19 for: %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:9 Lat:9 SizeLat:9 for: %V8I32 = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:17 SizeLat:17 for: %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:33 Lat:33 SizeLat:33 for: %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:5 Lat:14 SizeLat:8 for: %V2I64 = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:10 Lat:28 SizeLat:16 for: %V4I64 = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:20 Lat:56 SizeLat:32 for: %V8I64 = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:40 Lat:112 SizeLat:64 for: %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8     = call i8 @llvm.scmp.i8.i8(i8 %arg8, i8 %arg8)
  %V16I8  = call <16 x i8> @llvm.scmp.v16i8.16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
  %V32I8  = call <32 x i8> @llvm.scmp.v32i8.32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
  %V64I8  = call <64 x i8> @llvm.scmp.v64i8.64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
  %V128I8 = call <128 x i8> @llvm.scmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)

  %I16    = call i16 @llvm.scmp.i16.i16(i16 %arg16, i16 %arg16)
  %V8I16  = call <8 x i16> @llvm.scmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
  %V16I16 = call <16 x i16> @llvm.scmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
  %V32I16 = call <32 x i16> @llvm.scmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
  %V64I16 = call <64 x i16> @llvm.scmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)

  %I32    = call i32 @llvm.scmp.i32.i32(i32 %arg32, i32 %arg32)
  %V4I32  = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
  %V8I32  = call <8 x i32> @llvm.scmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
  %V16I32 = call <16 x i32> @llvm.scmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
  %V32I32 = call <32 x i32> @llvm.scmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)

  %I64    = call i64 @llvm.scmp.i64.i64(i64 %arg64, i64 %arg64)
  %V2I64  = call <2 x i64> @llvm.scmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
  %V4I64  = call <4 x i64> @llvm.scmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
  %V8I64  = call <8 x i64> @llvm.scmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
  %V16I64 = call <16 x i64> @llvm.scmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)

  ret i32 undef
}

define i32 @ucmp_int(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'ucmp_int'
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE2-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:15 Lat:15 SizeLat:15 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:27 Lat:27 SizeLat:27 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE2-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:51 Lat:51 SizeLat:51 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE2-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE2-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE2-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:33 Lat:33 SizeLat:33 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE2-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:65 Lat:65 SizeLat:65 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:16 SizeLat:18 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:34 Lat:32 SizeLat:36 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:76 CodeSize:68 Lat:64 SizeLat:72 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:184 CodeSize:136 Lat:128 SizeLat:144 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE3-LABEL: 'ucmp_int'
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE3-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:15 Lat:15 SizeLat:15 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE3-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:27 Lat:27 SizeLat:27 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE3-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:51 Lat:51 SizeLat:51 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE3-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE3-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE3-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE3-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE3-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:33 Lat:33 SizeLat:33 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE3-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:65 Lat:65 SizeLat:65 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE3-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:16 SizeLat:18 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:34 Lat:32 SizeLat:36 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:76 CodeSize:68 Lat:64 SizeLat:72 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:184 CodeSize:136 Lat:128 SizeLat:144 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'ucmp_int'
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; SSSE3-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:15 Lat:15 SizeLat:15 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:27 Lat:27 SizeLat:27 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:51 Lat:51 SizeLat:51 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; SSSE3-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; SSSE3-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:33 Lat:33 SizeLat:33 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:65 Lat:65 SizeLat:65 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:16 SizeLat:18 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:34 Lat:32 SizeLat:36 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:76 CodeSize:68 Lat:64 SizeLat:72 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:184 CodeSize:136 Lat:128 SizeLat:144 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'ucmp_int'
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE41-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE41-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:15 Lat:15 SizeLat:15 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE41-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:27 Lat:27 SizeLat:27 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE41-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:51 Lat:51 SizeLat:51 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE41-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE41-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE41-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE41-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE41-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE41-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE41-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE41-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE41-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:16 SizeLat:18 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:34 Lat:32 SizeLat:36 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:68 CodeSize:68 Lat:64 SizeLat:72 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:136 CodeSize:136 Lat:128 SizeLat:144 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'ucmp_int'
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; SSE42-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:15 Lat:15 SizeLat:15 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:27 Lat:27 SizeLat:27 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:51 Lat:51 SizeLat:51 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; SSE42-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; SSE42-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SSE42-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:12 SizeLat:12 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:18 Lat:24 SizeLat:24 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:36 Lat:48 SizeLat:48 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:72 Lat:96 SizeLat:96 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'ucmp_int'
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX1-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:21 Lat:12 SizeLat:24 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:40 Lat:22 SizeLat:46 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX1-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:78 Lat:42 SizeLat:90 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX1-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:21 Lat:12 SizeLat:24 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:40 Lat:22 SizeLat:46 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:100 CodeSize:78 Lat:42 SizeLat:90 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX1-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:21 Lat:12 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX1-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:42 Lat:24 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX1-NEXT:  Cost Model: Found costs of RThru:90 CodeSize:78 Lat:42 SizeLat:90 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:11 SizeLat:11 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:21 Lat:12 SizeLat:24 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:42 Lat:24 SizeLat:48 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:84 Lat:48 SizeLat:96 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'ucmp_int'
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX2-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:12 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:16 Lat:16 SizeLat:22 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:30 Lat:30 SizeLat:42 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX2-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:12 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:16 Lat:16 SizeLat:22 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:30 Lat:30 SizeLat:42 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX2-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:9 Lat:9 SizeLat:12 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:18 Lat:18 SizeLat:24 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX2-NEXT:  Cost Model: Found costs of RThru:46 CodeSize:30 Lat:30 SizeLat:42 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:11 SizeLat:11 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:9 Lat:9 SizeLat:12 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:18 Lat:18 SizeLat:24 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:36 Lat:36 SizeLat:48 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'ucmp_int'
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:9 Lat:9 SizeLat:9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:25 CodeSize:9 Lat:9 SizeLat:12 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:21 Lat:27 SizeLat:21 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:40 Lat:52 SizeLat:40 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:9 Lat:9 SizeLat:9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:9 Lat:9 SizeLat:12 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:21 Lat:27 SizeLat:21 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:62 CodeSize:40 Lat:52 SizeLat:40 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:6 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:9 Lat:9 SizeLat:9 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:6 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:7 Lat:7 SizeLat:7 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'ucmp_int'
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:10 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:10 SizeLat:10 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:7 Lat:7 SizeLat:7 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:5 Lat:5 SizeLat:5 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:7 Lat:7 SizeLat:7 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX1-LABEL: 'ucmp_int'
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:17 Lat:8 SizeLat:20 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:32 Lat:14 SizeLat:38 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:62 Lat:26 SizeLat:74 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:32 Lat:14 SizeLat:38 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:62 Lat:26 SizeLat:74 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:34 Lat:16 SizeLat:40 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:74 CodeSize:62 Lat:26 SizeLat:74 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; XOPAVX1-NEXT:  Cost Model: Found costs of 5 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:17 Lat:8 SizeLat:20 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:34 Lat:16 SizeLat:40 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:68 Lat:32 SizeLat:80 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; XOPAVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; XOPAVX2-LABEL: 'ucmp_int'
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:12 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:16 Lat:16 SizeLat:22 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:30 Lat:30 SizeLat:42 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:12 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:16 Lat:16 SizeLat:22 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:30 Lat:30 SizeLat:42 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:9 Lat:9 SizeLat:12 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:18 Lat:18 SizeLat:24 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:46 CodeSize:30 Lat:30 SizeLat:42 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; XOPAVX2-NEXT:  Cost Model: Found costs of 5 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:9 Lat:9 SizeLat:12 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:18 Lat:18 SizeLat:24 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:36 Lat:36 SizeLat:48 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; XOPAVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'ucmp_int'
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I8 = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
; SLM-NEXT:  Cost Model: Found costs of 9 for: %V16I8 = call <16 x i8> @llvm.ucmp.v16i8.v16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
; SLM-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:15 Lat:15 SizeLat:15 for: %V32I8 = call <32 x i8> @llvm.ucmp.v32i8.v32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
; SLM-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:27 Lat:27 SizeLat:27 for: %V64I8 = call <64 x i8> @llvm.ucmp.v64i8.v64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
; SLM-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:51 Lat:51 SizeLat:51 for: %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I16 = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
; SLM-NEXT:  Cost Model: Found costs of 9 for: %V8I16 = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
; SLM-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
; SLM-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
; SLM-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I32 = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
; SLM-NEXT:  Cost Model: Found costs of 9 for: %V4I32 = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
; SLM-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:17 Lat:17 SizeLat:17 for: %V8I32 = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
; SLM-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:33 Lat:33 SizeLat:33 for: %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
; SLM-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:65 Lat:65 SizeLat:65 for: %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)
; SLM-NEXT:  Cost Model: Found costs of 5 for: %I64 = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
; SLM-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:9 Lat:18 SizeLat:12 for: %V2I64 = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:18 Lat:36 SizeLat:24 for: %V4I64 = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:36 Lat:72 SizeLat:48 for: %V8I64 = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:72 Lat:144 SizeLat:96 for: %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I8     = call i8 @llvm.ucmp.i8.i8(i8 %arg8, i8 %arg8)
  %V16I8  = call <16 x i8> @llvm.ucmp.v16i8.16i8(<16 x i8> %argv16i8, <16 x i8> %argv16i8)
  %V32I8  = call <32 x i8> @llvm.ucmp.v32i8.32i8(<32 x i8> %argv32i8, <32 x i8> %argv32i8)
  %V64I8  = call <64 x i8> @llvm.ucmp.v64i8.64i8(<64 x i8> %argv64i8, <64 x i8> %argv64i8)
  %V128I8 = call <128 x i8> @llvm.ucmp.v128i8.v128i8(<128 x i8> %argv128i8, <128 x i8> %argv128i8)

  %I16    = call i16 @llvm.ucmp.i16.i16(i16 %arg16, i16 %arg16)
  %V8I16  = call <8 x i16> @llvm.ucmp.v8i16.v8i16(<8 x i16> %argv8i16, <8 x i16> %argv8i16)
  %V16I16 = call <16 x i16> @llvm.ucmp.v16i16.v16i16(<16 x i16> %argv16i16, <16 x i16> %argv16i16)
  %V32I16 = call <32 x i16> @llvm.ucmp.v32i16.v32i16(<32 x i16> %argv32i16, <32 x i16> %argv32i16)
  %V64I16 = call <64 x i16> @llvm.ucmp.v64i16.v64i16(<64 x i16> %argv64i16, <64 x i16> %argv64i16)

  %I32    = call i32 @llvm.ucmp.i32.i32(i32 %arg32, i32 %arg32)
  %V4I32  = call <4 x i32> @llvm.ucmp.v4i32.v4i32(<4 x i32> %argv4i32, <4 x i32> %argv4i32)
  %V8I32  = call <8 x i32> @llvm.ucmp.v8i32.v8i32(<8 x i32> %argv8i32, <8 x i32> %argv8i32)
  %V16I32 = call <16 x i32> @llvm.ucmp.v16i32.v16i32(<16 x i32> %argv16i32, <16 x i32> %argv16i32)
  %V32I32 = call <32 x i32> @llvm.ucmp.v32i32.v32i32(<32 x i32> %argv32i32, <32 x i32> %argv32i32)

  %I64    = call i64 @llvm.ucmp.i64.i64(i64 %arg64, i64 %arg64)
  %V2I64  = call <2 x i64> @llvm.ucmp.v2i64.v2i64(<2 x i64> %argv2i64, <2 x i64> %argv2i64)
  %V4I64  = call <4 x i64> @llvm.ucmp.v4i64.v4i64(<4 x i64> %argv4i64, <4 x i64> %argv4i64)
  %V8I64  = call <8 x i64> @llvm.ucmp.v8i64.v8i64(<8 x i64> %argv8i64, <8 x i64> %argv8i64)
  %V16I64 = call <16 x i64> @llvm.ucmp.v16i64.v16i64(<16 x i64> %argv16i64, <16 x i64> %argv16i64)

  ret i32 undef
}

