; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s

define amdgpu_kernel void @and_i1_sext_bool(ptr addrspace(1) nocapture %arg) {
; GCN-LABEL: and_i1_sext_bool:
; GCN:       ; %bb.0: ; %bb
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    buffer_load_dword v4, v[2:3], s[0:3], 0 addr64
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, v0, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v4, vcc
; GCN-NEXT:    buffer_store_dword v0, v[2:3], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
bb:
  %x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %y = tail call i32 @llvm.amdgcn.workitem.id.y()
  %gep = getelementptr inbounds i32, ptr addrspace(1) %arg, i32 %x
  %v = load i32, ptr addrspace(1) %gep, align 4
  %cmp = icmp ugt i32 %x, %y
  %ext = sext i1 %cmp to i32
  %and = and i32 %v, %ext
  store i32 %and, ptr addrspace(1) %gep, align 4
  ret void
}

define i32 @and_sext_bool_fcmp(float %x, i32 %y) {
; GCN-LABEL: and_sext_bool_fcmp:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp oeq float %x, 0.0
  %sext = sext i1 %cmp to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_fpclass(float %x, i32 %y) {
; GCN-LABEL: and_sext_bool_fpclass:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v2, 0x7b
; GCN-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %class = call i1 @llvm.is.fpclass(float %x, i32 123)
  %sext = sext i1 %class to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_uadd_w_overflow(i32 %x, i32 %y) {
; GCN-LABEL: and_sext_bool_uadd_w_overflow:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %uadd = call { i32, i1 } @llvm.uadd.with.overflow.i32(i32 %x, i32 %y)
  %carry = extractvalue { i32, i1 } %uadd, 1
  %sext = sext i1 %carry to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_usub_w_overflow(i32 %x, i32 %y) {
; GCN-LABEL: and_sext_bool_usub_w_overflow:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %uadd = call { i32, i1 } @llvm.usub.with.overflow.i32(i32 %x, i32 %y)
  %carry = extractvalue { i32, i1 } %uadd, 1
  %sext = sext i1 %carry to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_sadd_w_overflow(i32 %x, i32 %y) {
; GCN-LABEL: and_sext_bool_sadd_w_overflow:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc, 0, v1
; GCN-NEXT:    v_add_i32_e64 v2, s[4:5], v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e64 s[4:5], v2, v0
; GCN-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %uadd = call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 %x, i32 %y)
  %carry = extractvalue { i32, i1 } %uadd, 1
  %sext = sext i1 %carry to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_ssub_w_overflow(i32 %x, i32 %y) {
; GCN-LABEL: and_sext_bool_ssub_w_overflow:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc, 0, v1
; GCN-NEXT:    v_add_i32_e64 v2, s[4:5], v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e64 s[4:5], v2, v0
; GCN-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %uadd = call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 %x, i32 %y)
  %carry = extractvalue { i32, i1 } %uadd, 1
  %sext = sext i1 %carry to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_smul_w_overflow(i32 %x, i32 %y) {
; GCN-LABEL: and_sext_bool_smul_w_overflow:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_hi_i32 v2, v0, v1
; GCN-NEXT:    v_mul_lo_u32 v0, v0, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 31, v0
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, v2, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %uadd = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 %x, i32 %y)
  %carry = extractvalue { i32, i1 } %uadd, 1
  %sext = sext i1 %carry to i32
  %and = and i32 %sext, %y
  ret i32 %and
}

define i32 @and_sext_bool_umul_w_overflow(i32 %x, i32 %y) {
; GCN-LABEL: and_sext_bool_umul_w_overflow:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_hi_u32 v0, v0, v1
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %uadd = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 %x, i32 %y)
  %carry = extractvalue { i32, i1 } %uadd, 1
  %sext = sext i1 %carry to i32
  %and = and i32 %sext, %y
  ret i32 %and
}


declare i32 @llvm.amdgcn.workitem.id.x() #0

declare i32 @llvm.amdgcn.workitem.id.y() #0

attributes #0 = { nounwind readnone speculatable }
