/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.encoder.http.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.BaseHttpServletResponseXMLMessageEncoder;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class HTTPSOAP11Encoder
extends BaseHttpServletResponseXMLMessageEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Encoder.class);
    @Nonnull
    private SOAPObjectBuilder<Envelope> envBuilder;
    @Nonnull
    private SOAPObjectBuilder<Body> bodyBuilder;

    public HTTPSOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.ensureBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.ensureBuilder(Body.DEFAULT_ELEMENT_NAME);
        this.setProtocolMessageLoggerSubCategory("SOAP");
    }

    @Override
    public void prepareContext() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object payload = null;
        assert (messageContext != null);
        Fault fault = SOAPMessagingSupport.getSOAP11Fault(messageContext);
        if (fault != null) {
            FaultCode fcode = fault.getCode();
            this.log.debug("Saw SOAP 1.1 Fault payload with fault code, replacing any existing context message: {}", (Object)(fcode != null ? fcode.getValue() : null));
            payload = fault;
            messageContext.setMessage(null);
        } else {
            payload = messageContext.getMessage();
        }
        if (payload == null || !(payload instanceof XMLObject)) {
            throw new MessageEncodingException("No outbound XML message or Fault contained in message context");
        }
        if (payload instanceof Envelope) {
            this.storeSOAPEnvelope((Envelope)payload);
        } else {
            this.buildAndStoreSOAPMessage((XMLObject)payload);
        }
    }

    @Override
    protected void doEncode() throws MessageEncodingException {
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope == null) {
            throw new MessageEncodingException("SOAP envelope was null");
        }
        Element envelopeElem = this.marshallMessage(envelope);
        HttpServletResponse response = this.prepareHttpServletResponse();
        try {
            SerializeSupport.writeNode(envelopeElem, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem writing SOAP envelope to servlet output stream", e);
        }
    }

    protected void storeSOAPEnvelope(@Nullable Envelope envelope) {
        this.getMessageContext().ensureSubcontext(SOAP11Context.class).setEnvelope(envelope);
    }

    @Nullable
    protected Envelope getSOAPEnvelope() {
        return this.getMessageContext().ensureSubcontext(SOAP11Context.class).getEnvelope();
    }

    protected void buildAndStoreSOAPMessage(@Nonnull XMLObject payload) {
        Body body;
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope == null) {
            envelope = this.envBuilder.buildObject();
            this.storeSOAPEnvelope(envelope);
        }
        if ((body = envelope.getBody()) == null) {
            body = this.bodyBuilder.buildObject();
            envelope.setBody(body);
        }
        if (!body.getUnknownXMLObjects().isEmpty()) {
            this.log.warn("Existing SOAP Envelope Body already contained children");
        }
        body.getUnknownXMLObjects().add(payload);
    }

    @Nonnull
    protected HttpServletResponse prepareHttpServletResponse() throws MessageEncodingException {
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            throw new MessageEncodingException("HttpServletResponse was null");
        }
        HttpServletSupport.addNoCacheHeaders(response);
        HttpServletSupport.setUTF8Encoding(response);
        HttpServletSupport.setContentType(response, "text/xml");
        String soapAction = this.getSOAPAction();
        if (soapAction != null) {
            response.setHeader("SOAPAction", soapAction);
        } else {
            response.setHeader("SOAPAction", "");
        }
        response.setStatus(this.getHTTPResponseStatusCode());
        return response;
    }

    @Nullable
    protected String getSOAPAction() {
        Header header;
        Envelope env = this.getSOAPEnvelope();
        Header header2 = header = env != null ? env.getHeader() : null;
        if (header == null) {
            return null;
        }
        List<XMLObject> objList = header.getUnknownXMLObjects(Action.ELEMENT_NAME);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        return ((Action)objList.get(0)).getURI();
    }

    protected int getHTTPResponseStatusCode() {
        Integer contextStatus = this.getMessageContext().ensureSubcontext(SOAP11Context.class).getHTTPResponseStatus();
        if (contextStatus != null) {
            return contextStatus;
        }
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope != null) {
            List<XMLObject> faults;
            Body body = envelope.getBody();
            List<XMLObject> list = faults = body != null ? body.getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME) : null;
            if (faults != null && !faults.isEmpty()) {
                return 500;
            }
        }
        return 200;
    }

    @Override
    @Nullable
    protected XMLObject getMessageToLog() {
        return this.getMessageContext().ensureSubcontext(SOAP11Context.class).getEnvelope();
    }
}

