/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.tribuo.util.Util;

public final class DescriptiveStats {
    private final List<Double> samples = new ArrayList<Double>();

    public DescriptiveStats() {
    }

    public DescriptiveStats(List<Double> values) {
        this.samples.addAll(values);
    }

    void addValue(double value) {
        this.samples.add(value);
    }

    public double getMean() {
        return Util.mean(this.samples);
    }

    public double getVariance() {
        return Util.sampleVariance(this.samples);
    }

    public double getStandardDeviation() {
        return Util.sampleStandardDeviation(this.samples);
    }

    public double getMax() {
        return (Double)Util.argmax(this.samples).getB();
    }

    public double getMin() {
        return (Double)Util.argmin(this.samples).getB();
    }

    public long getN() {
        return this.samples.size();
    }

    public List<Double> values() {
        return new ArrayList<Double>(this.samples);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptiveStats that = (DescriptiveStats)o;
        return this.samples.equals(that.samples);
    }

    public int hashCode() {
        return Objects.hash(this.samples);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<String> rows = Arrays.asList("count", "mean", "std", "min", "max");
        int maxRowLen = rows.stream().max(Comparator.comparingInt(String::length)).get().length();
        String fmtStr = String.format("%%-%ds", maxRowLen + 2);
        sb.append(String.format(fmtStr, "count"));
        sb.append(String.format("%d%n", this.getN()));
        sb.append(String.format(fmtStr, "mean"));
        sb.append(String.format("%.6f%n", this.getMean()));
        sb.append(String.format(fmtStr, "std"));
        sb.append(String.format("%.6f%n", this.getStandardDeviation()));
        sb.append(String.format(fmtStr, "min"));
        sb.append(String.format("%.6f%n", this.getMin()));
        sb.append(String.format(fmtStr, "max"));
        sb.append(String.format("%.6f%n", this.getMax()));
        return sb.toString();
    }
}

