/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.io.IOException;
import java.net.URL;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Time;
import org.videolan.Logger;

public class HSound {
    boolean isLooping = false;
    Player player = null;
    ControllerListenerImpl listener = new ControllerListenerImpl();
    private static final Logger logger = Logger.getLogger(HSound.class.getName());

    public void load(String location) throws IOException, SecurityException {
        this.load(new URL("file:" + location));
    }

    public void load(URL contents) throws IOException, SecurityException {
        this.dispose();
        try {
            this.player = Manager.createPlayer(contents);
        }
        catch (NoPlayerException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void set(byte[] data) {
        logger.unimplemented("set");
    }

    public void play() {
        if (this.player != null) {
            this.isLooping = false;
            this.player.addControllerListener(this.listener);
            this.player.start();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.removeControllerListener(this.listener);
            this.player.stop();
        }
    }

    public void loop() {
        if (this.player != null) {
            this.isLooping = true;
            this.player.removeControllerListener(this.listener);
            this.player.start();
        }
    }

    public void dispose() {
        if (this.player != null) {
            this.player.removeControllerListener(this.listener);
            this.player.stop();
            this.player.close();
            this.player = null;
        }
    }

    private class ControllerListenerImpl
    implements ControllerListener {
        private ControllerListenerImpl() {
        }

        @Override
        public void controllerUpdate(ControllerEvent event) {
            if (event instanceof EndOfMediaEvent) {
                if (HSound.this.isLooping) {
                    HSound.this.player.setMediaTime(new Time(0L));
                    HSound.this.player.start();
                } else {
                    HSound.this.stop();
                }
            }
        }
    }
}

