/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;

public class FeaturesImageNode
implements MetadataNode {
    public static final String NAME = "features";
    public static final String METADATA_VERSION = "metadataVersion";
    public static final String ZK_MIGRATION_STATE = "zkMigrationState";
    public static final String FINALIZED_PREFIX = "finalized_";
    private final FeaturesImage image;

    public FeaturesImageNode(FeaturesImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        childNames.add(METADATA_VERSION);
        childNames.add(ZK_MIGRATION_STATE);
        for (String featureName : this.image.finalizedVersions().keySet()) {
            childNames.add(FINALIZED_PREFIX + featureName);
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        if (name.equals(METADATA_VERSION)) {
            return new MetadataLeafNode(this.image.metadataVersion().toString());
        }
        if (name.startsWith(FINALIZED_PREFIX)) {
            String key = name.substring(FINALIZED_PREFIX.length());
            return new MetadataLeafNode(this.image.finalizedVersions().getOrDefault(key, (short)0).toString());
        }
        return null;
    }
}

