/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.initScript.util;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleTasksUtil {
    @Nullable
    private static String getRelativeTaskPath(@NotNull String targetProjectPath, @NotNull Task task) {
        String taskPath;
        if (targetProjectPath == null) {
            GradleTasksUtil.$$$reportNull$$$0(0);
        }
        if (task == null) {
            GradleTasksUtil.$$$reportNull$$$0(1);
        }
        if ((taskPath = task.getPath()).startsWith(targetProjectPath + ":")) {
            return taskPath.substring(targetProjectPath.length() + 1);
        }
        if (taskPath.startsWith(targetProjectPath)) {
            return taskPath.substring(targetProjectPath.length());
        }
        return null;
    }

    @NotNull
    private static List<String> getPossibleTaskNames(@NotNull String targetProjectPath, @NotNull Task task) {
        if (targetProjectPath == null) {
            GradleTasksUtil.$$$reportNull$$$0(2);
        }
        if (task == null) {
            GradleTasksUtil.$$$reportNull$$$0(3);
        }
        String relativeTaskPath = GradleTasksUtil.getRelativeTaskPath(targetProjectPath, task);
        ArrayList<String> possibleTaskNames = new ArrayList<String>();
        if (relativeTaskPath == null) {
            possibleTaskNames.add(task.getPath());
        } else {
            possibleTaskNames.add(task.getName());
            possibleTaskNames.add(task.getPath());
            possibleTaskNames.add(relativeTaskPath);
        }
        ArrayList<String> arrayList = possibleTaskNames;
        if (arrayList == null) {
            GradleTasksUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static TaskCollection<Task> getMatchedTasks(@NotNull String targetProjectPath, @NotNull TaskCollection<Task> tasks, @NotNull List<String> matchers) {
        if (targetProjectPath == null) {
            GradleTasksUtil.$$$reportNull$$$0(5);
        }
        if (tasks == null) {
            GradleTasksUtil.$$$reportNull$$$0(6);
        }
        if (matchers == null) {
            GradleTasksUtil.$$$reportNull$$$0(7);
        }
        TaskCollection taskCollection = tasks.matching(task -> {
            List<String> possibleNames = GradleTasksUtil.getPossibleTaskNames(targetProjectPath, task);
            for (String possibleName : possibleNames) {
                for (String matcher : matchers) {
                    if (!possibleName.startsWith(matcher)) continue;
                    return true;
                }
            }
            return false;
        });
        if (taskCollection == null) {
            GradleTasksUtil.$$$reportNull$$$0(8);
        }
        return taskCollection;
    }

    @NotNull
    private static Gradle getRootGradle(@NotNull Gradle gradle) {
        if (gradle == null) {
            GradleTasksUtil.$$$reportNull$$$0(9);
        }
        Gradle rootGradle = gradle;
        while (rootGradle.getParent() != null) {
            rootGradle = rootGradle.getParent();
        }
        Gradle gradle2 = rootGradle;
        if (gradle2 == null) {
            GradleTasksUtil.$$$reportNull$$$0(10);
        }
        return gradle2;
    }

    @NotNull
    private static String getCompositePathPrefix(@NotNull Gradle gradle) {
        if (gradle == null) {
            GradleTasksUtil.$$$reportNull$$$0(11);
        }
        Gradle rootGradle = gradle;
        LinkedList<String> compositePathPrefix = new LinkedList<String>();
        while (rootGradle.getParent() != null) {
            compositePathPrefix.addFirst(rootGradle.getRootProject().getName());
            rootGradle = rootGradle.getParent();
        }
        if (compositePathPrefix.isEmpty()) {
            return "";
        }
        StringJoiner compositePathPrefixJoiner = new StringJoiner(":");
        for (String compositeName : compositePathPrefix) {
            compositePathPrefixJoiner.add(compositeName);
        }
        String string = ":" + compositePathPrefixJoiner;
        if (string == null) {
            GradleTasksUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static List<String> getStartTaskNames(@NotNull Project project) {
        if (project == null) {
            GradleTasksUtil.$$$reportNull$$$0(13);
        }
        Gradle gradle = project.getGradle();
        Gradle rootGradle = GradleTasksUtil.getRootGradle(gradle);
        List<String> startTaskNames = rootGradle.getStartParameter().getTaskNames();
        String compositePathPrefix = GradleTasksUtil.getCompositePathPrefix(gradle);
        project.getLogger().debug("Composite path prefix: {}", (Object)compositePathPrefix);
        ArrayList<String> relativeStartTaskNames = new ArrayList<String>();
        for (String startTaskName : startTaskNames) {
            relativeStartTaskNames.add(startTaskName.startsWith(compositePathPrefix) ? startTaskName.substring(compositePathPrefix.length()) : startTaskName);
        }
        startTaskNames = relativeStartTaskNames;
        if (startTaskNames.isEmpty()) {
            startTaskNames = project.getDefaultTasks();
        }
        ArrayList<String> arrayList = startTaskNames;
        if (arrayList == null) {
            GradleTasksUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static String getTargetProjectPath(@NotNull Project project) {
        if (project == null) {
            GradleTasksUtil.$$$reportNull$$$0(15);
        }
        Gradle gradle = project.getGradle();
        File currentDir = gradle.getStartParameter().getCurrentDir();
        for (Project globalProject : gradle.getRootProject().getAllprojects()) {
            if (!globalProject.getProjectDir().equals(currentDir)) continue;
            String string = globalProject.getPath();
            if (string == null) {
                GradleTasksUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        throw new IllegalArgumentException("Cannot find project by working directory " + currentDir);
    }

    @NotNull
    public static TaskCollection<Task> getStartTasks(@NotNull Project project) {
        if (project == null) {
            GradleTasksUtil.$$$reportNull$$$0(17);
        }
        project.getLogger().debug("Project: {}", (Object)project);
        String targetProjectPath = GradleTasksUtil.getTargetProjectPath(project);
        project.getLogger().debug("Target Project Path: {}", (Object)targetProjectPath);
        List<String> startTaskNames = GradleTasksUtil.getStartTaskNames(project);
        project.getLogger().debug("Start Tasks Names: {}", startTaskNames);
        return GradleTasksUtil.getMatchedTasks(targetProjectPath, (TaskCollection<Task>)project.getTasks(), startTaskNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProjectPath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/initScript/util/GradleTasksUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradle";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/initScript/util/GradleTasksUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTaskNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchedTasks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGradle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositePathPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartTaskNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeTaskPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTaskNames";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedTasks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRootGradle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCompositePathPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStartTaskNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTargetProjectPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStartTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

