/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.BiDirectionalEnumerator;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class InMemoryStorage
implements VcsLogStorage {
    private final BiDirectionalEnumerator<CommitId> myCommitIdEnumerator = new BiDirectionalEnumerator(1);
    private final BiDirectionalEnumerator<VcsRef> myRefsEnumerator = new BiDirectionalEnumerator(1);

    InMemoryStorage() {
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            InMemoryStorage.$$$reportNull$$$0(0);
        }
        if (root == null) {
            InMemoryStorage.$$$reportNull$$$0(1);
        }
        return this.getOrPut(hash, root);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            InMemoryStorage.$$$reportNull$$$0(2);
        }
        if (root == null) {
            InMemoryStorage.$$$reportNull$$$0(3);
        }
        return this.myCommitIdEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    @NotNull
    public CommitId getCommitId(int commitIndex) {
        CommitId commitId = (CommitId)this.myCommitIdEnumerator.getValue(commitIndex);
        if (commitId == null) {
            InMemoryStorage.$$$reportNull$$$0(4);
        }
        return commitId;
    }

    @Override
    public boolean containsCommit(@NotNull CommitId id) {
        if (id == null) {
            InMemoryStorage.$$$reportNull$$$0(5);
        }
        return this.myCommitIdEnumerator.contains((Object)id);
    }

    @Override
    public void iterateCommits(@NotNull Predicate<? super CommitId> consumer) {
        if (consumer == null) {
            InMemoryStorage.$$$reportNull$$$0(6);
        }
        this.myCommitIdEnumerator.forEachValue(consumer);
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            InMemoryStorage.$$$reportNull$$$0(7);
        }
        return this.myRefsEnumerator.enumerate((Object)ref);
    }

    @Override
    @NotNull
    public VcsRef getVcsRef(int refIndex) {
        VcsRef vcsRef = (VcsRef)this.myRefsEnumerator.getValue(refIndex);
        if (vcsRef == null) {
            InMemoryStorage.$$$reportNull$$$0(8);
        }
        return vcsRef;
    }

    @Override
    public void flush() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/InMemoryStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/InMemoryStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrPut";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsCommit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommits";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRefIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }
}

