---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Pulumi API token'
---

## Description

The response body contains content that matches the pattern of a Pulumi API token was identified. Personal access tokens map to the permissions of a user. A malicious actor with access to this token can delete stacks, tags, updates, and webhooks as the owner of the access token. Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). To revoke the API token:

- Sign in to your Pulumi account and access <https://app.pulumi.com/>
- In the upper-right corner, select the profile picture and select "Personal access tokens"
- Find the identified token and select the ellipsis in the "Actions" column of the key and select "Delete token"
- When prompted, select "Delete token" in the "Delete token" dialog

For more information, please see [Pulumi's documentation on Personal access tokens](https://www.pulumi.com/docs/pulumi-cloud/access-management/access-tokens/#personal-access-tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.95 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
