---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token CircleCI access token'
---

## Description

The response body contains content that matches the pattern of a CircleCI project token was identified. CircleCI project tokens can be given one of three scopes: - Status - Read Only - Admin Depending on the access level of this detected token, a malicious actor with access to this token may be able to gain full access to the project and CI/CD pipelines.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate a project token:

- In the CircleCI application select Projects in the sidebar, then the ellipsis (...) next to your project, and select "Project Settings".
- Select API Permissions.
- Select the "X" in the Remove column for the token you wish to replace. When the confirmation window appears, enter the text DELETE in the form and then select "Delete API Token".
- Select "Create API Token".
- Choose the same scope used for the old token from the dropdown list.
- In the Label field, type a label for the token.
It can be the same name given to the old token.
- Select "Add API Token".

For more information please see their [documentation on rotating project tokens](https://circleci.com/docs/managing-api-tokens/#rotating-a-project-api-token).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.131 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
