/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLQuery;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandler;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;

public abstract class GhidraURLQueryTask
extends Task
implements GhidraURLResultHandler {
    private final URL ghidraUrl;
    private final Class<? extends DomainObject> contentClass;
    private final GhidraURLQuery.LinkFileControl linkFileControl;
    private boolean done = false;

    protected GhidraURLQueryTask(String title, URL ghidraUrl, Class<? extends DomainObject> contentClass, GhidraURLQuery.LinkFileControl linkFileControl) {
        super(title, true, false, true);
        if (!GhidraURL.isLocalProjectURL(ghidraUrl) && !GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            throw new IllegalArgumentException("Unsupported URL: " + String.valueOf(ghidraUrl));
        }
        this.ghidraUrl = ghidraUrl;
        this.contentClass = contentClass;
        this.linkFileControl = linkFileControl;
    }

    protected boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) throws CancelledException {
        Thread t = Thread.currentThread();
        CancelledListener cancelledListener = () -> t.interrupt();
        monitor.addCancelledListener(cancelledListener);
        try {
            GhidraURLQuery.queryUrl(this.ghidraUrl, this.contentClass, this, this.linkFileControl, monitor);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException e) {
            this.handleError("URL Access Failure", e.getMessage(), this.ghidraUrl, e);
        }
        finally {
            monitor.removeCancelledListener(cancelledListener);
            monitor.checkCancelled();
            this.done = true;
        }
    }

    @Override
    public void handleError(String title, String message, URL url, IOException cause) {
        Msg.showError(GhidraURLQuery.class, null, (String)title, (Object)(message + ":\n" + String.valueOf(url)));
    }

    @Override
    public void processResult(DomainFile domainFile, URL url, TaskMonitor monitor) throws IOException {
        this.handleError("Unsupported Content", "File URL: " + String.valueOf(url), null, null);
    }

    @Override
    public void processResult(DomainFolder domainFolder, URL url, TaskMonitor monitor) throws IOException {
        this.handleError("Unsupported Content", "Folder URL: " + String.valueOf(url), null, null);
    }
}

