/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.features.codecompare.graphanalysis.Pinning;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;

public class DecompileDataDiff {
    private DecompileData[] decompileData = new DecompileData[2];
    private ClangTokenGroup[] markup = new ClangTokenGroup[2];
    private HighFunction[] hfunc = new HighFunction[2];
    private boolean sizeCollapse;
    private static int NOT_EXACT_MATCH_CONSTANTS = 0;
    private static int EXACT_MATCH_CONSTANTS = 1;
    private Configuration[] pairing;

    public DecompileDataDiff(DecompileData decompileData1, DecompileData decompileData2) {
        this.decompileData[0] = decompileData1;
        this.decompileData[1] = decompileData2;
        int size1 = decompileData1.getProgram().getLanguage().getLanguageDescription().getSize();
        int size2 = decompileData2.getProgram().getLanguage().getLanguageDescription().getSize();
        this.sizeCollapse = size1 != size2;
        this.markup[0] = this.decompileData[0].getCCodeMarkup();
        this.markup[1] = this.decompileData[1].getCCodeMarkup();
        this.hfunc[0] = this.decompileData[0].getHighFunction();
        this.hfunc[1] = this.decompileData[1].getHighFunction();
        this.pairing = new Configuration[2];
    }

    public ArrayList<TokenBin> getTokenMap(boolean matchConstantsExactly, TaskMonitor monitor) throws CancelledException {
        int index;
        int n = index = matchConstantsExactly ? EXACT_MATCH_CONSTANTS : NOT_EXACT_MATCH_CONSTANTS;
        if (this.pairing[index] == null) {
            Pinning pin = Pinning.makePinning(this.hfunc[0], this.hfunc[1], matchConstantsExactly, this.sizeCollapse, true, monitor);
            ArrayList<TokenBin> highBins = pin.buildTokenMap(this.markup[0], this.markup[1]);
            this.pairing[index] = new Configuration(highBins, this.hfunc[0], this.hfunc[1]);
        }
        return this.pairing[index].highBins;
    }

    public HashSet<ClangToken> getLeftHighlightTokenSet(boolean matchConstantsExactly, TaskMonitor monitor) throws CancelledException {
        int index;
        int n = index = matchConstantsExactly ? EXACT_MATCH_CONSTANTS : NOT_EXACT_MATCH_CONSTANTS;
        if (this.pairing[index] == null) {
            this.getTokenMap(matchConstantsExactly, monitor);
        }
        return this.pairing[index].leftHighlightTokenSet;
    }

    public HashSet<ClangToken> getRightHighlightTokenSet(boolean matchConstantsExactly, TaskMonitor monitor) throws CancelledException {
        int matchConstantsIndex;
        int n = matchConstantsIndex = matchConstantsExactly ? EXACT_MATCH_CONSTANTS : NOT_EXACT_MATCH_CONSTANTS;
        if (this.pairing[matchConstantsIndex] == null) {
            this.getTokenMap(matchConstantsExactly, monitor);
        }
        return this.pairing[matchConstantsIndex].rightHighlightTokenSet;
    }

    public HighFunction getLeftHighFunction() {
        return this.hfunc[0];
    }

    public HighFunction getRightHighFunction() {
        return this.hfunc[1];
    }

    private static class Configuration {
        ArrayList<TokenBin> highBins;
        HashSet<ClangToken> leftHighlightTokenSet;
        HashSet<ClangToken> rightHighlightTokenSet;

        public Configuration(ArrayList<TokenBin> highBins, HighFunction leftFunc, HighFunction rightFunc) {
            this.highBins = highBins;
            this.leftHighlightTokenSet = new HashSet();
            this.rightHighlightTokenSet = new HashSet();
            for (TokenBin bin : highBins) {
                if (bin.getMatch() != null) continue;
                for (ClangToken token : bin) {
                    ClangFunction clangFunction = token.getClangFunction();
                    HighFunction highFunction = clangFunction.getHighFunction();
                    if (leftFunc == highFunction) {
                        this.leftHighlightTokenSet.add(token);
                        continue;
                    }
                    if (rightFunc != highFunction) continue;
                    this.rightHighlightTokenSet.add(token);
                }
            }
        }
    }
}

