/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.ascii;

import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.util.ascii.CharSetRecognizer;
import ghidra.util.ascii.Sequence;

public class MinLengthCharSequenceMatcher {
    private final int minimumSequenceLength;
    long sequenceStartIndex = -1L;
    long currentIndex = -1L;
    boolean inAsciiSequence = false;
    private CharSetRecognizer charSet;
    private Sequence lastSequence;
    private int alignment;

    public MinLengthCharSequenceMatcher(int minimumSequenceLength, CharSetRecognizer charSet, int alignment) {
        this.minimumSequenceLength = minimumSequenceLength;
        this.charSet = charSet;
        this.alignment = alignment;
    }

    public boolean addChar(int c) {
        this.lastSequence = null;
        ++this.currentIndex;
        if (this.charSet.contains(c)) {
            if (!this.inAsciiSequence && this.meetsAlignmentRequirement()) {
                this.sequenceStartIndex = this.currentIndex;
                this.inAsciiSequence = true;
            }
        } else {
            if (c == 0) {
                return this.checkSequence(this.sequenceStartIndex, this.currentIndex, true);
            }
            return this.checkSequence(this.sequenceStartIndex, this.currentIndex - 1L, false);
        }
        return false;
    }

    private boolean meetsAlignmentRequirement() {
        return this.currentIndex % (long)this.alignment == 0L;
    }

    public boolean endSequence() {
        this.lastSequence = null;
        return this.checkSequence(this.sequenceStartIndex, this.currentIndex, false);
    }

    public void reset() {
        this.currentIndex = -1L;
        this.inAsciiSequence = false;
        this.lastSequence = null;
    }

    public Sequence getSequence() {
        return this.lastSequence;
    }

    private boolean checkSequence(long start, long end, boolean nullTerminated) {
        if (!this.inAsciiSequence) {
            return false;
        }
        this.inAsciiSequence = false;
        long length = end - start + 1L;
        if (nullTerminated) {
            --length;
        }
        if (length >= (long)this.minimumSequenceLength) {
            this.lastSequence = new Sequence(start, end, (AbstractStringDataType)StringDataType.dataType, nullTerminated);
        }
        return this.lastSequence != null;
    }
}

