/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.tree.GTree;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class RefreshFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Refresh", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.hasSelectedNodes()).popupMenuPath(new String[]{"Refresh"}).popupMenuGroup("Z", "Z").popupMenuIcon(FSBIcons.REFRESH).toolBarIcon(FSBIcons.REFRESH).description("Refresh file info").onAction(ac -> ac.getComponentProvider().runTask(monitor -> this.doRefreshInfo(ac.getSelectedNodes(), ac.getTree(), monitor))).build());
    }

    void doRefreshInfo(List<FSBNode> nodes, GTree gTree, TaskMonitor monitor) {
        try {
            for (FSBNode node : nodes) {
                node.refreshNode(monitor);
            }
            gTree.refilterLater();
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        Swing.runLater(() -> gTree.repaint());
    }
}

