/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.NumberParseResult;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.features.base.memsearch.matcher.MaskedByteSequenceByteMatcher;
import ghidra.util.HTMLUtilities;
import java.util.StringTokenizer;

class FloatSearchFormat
extends SearchFormat {
    private String longName;
    private int byteSize;

    FloatSearchFormat(String name, String longName, int size) {
        super(name);
        if (size != 8 && size != 4) {
            throw new IllegalArgumentException("Only supports 4 or 8 byte floating point numbers");
        }
        this.longName = longName;
        this.byteSize = size;
    }

    @Override
    public ByteMatcher parse(String input, SearchSettings settings) {
        if ((input = input.trim()).isBlank()) {
            return new InvalidByteMatcher("");
        }
        StringTokenizer tokenizer = new StringTokenizer(input);
        int tokenCount = tokenizer.countTokens();
        byte[] bytes = new byte[tokenCount * this.byteSize];
        int bytesPosition = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            NumberParseResult result = this.parseNumber(tok, settings);
            if (result.errorMessage() != null) {
                return new InvalidByteMatcher(result.errorMessage(), result.validInput());
            }
            System.arraycopy(result.bytes(), 0, bytes, bytesPosition, this.byteSize);
            bytesPosition += this.byteSize;
        }
        return new MaskedByteSequenceByteMatcher(input, bytes, settings);
    }

    private NumberParseResult parseNumber(String tok, SearchSettings settings) {
        if (tok.equals("-") || tok.equals("-.")) {
            return new NumberParseResult(null, "Incomplete negative floating point number", true);
        }
        if (tok.equals(".")) {
            return new NumberParseResult(null, "Incomplete floating point number", true);
        }
        if (tok.endsWith("E") || tok.endsWith("e") || tok.endsWith("E-") || tok.endsWith("e-")) {
            return new NumberParseResult(null, "Incomplete floating point number", true);
        }
        try {
            long value = this.getValue(tok);
            return new NumberParseResult(this.getBytes(value, settings), null, true);
        }
        catch (NumberFormatException e) {
            return new NumberParseResult(null, "Floating point parse error: " + e.getMessage(), false);
        }
    }

    private long getValue(String tok) {
        switch (this.byteSize) {
            case 4: {
                float floatValue = Float.parseFloat(tok);
                return Float.floatToIntBits(floatValue);
            }
        }
        double dvalue = Double.parseDouble(tok);
        return Double.doubleToLongBits(dvalue);
    }

    private byte[] getBytes(long value, SearchSettings settings) {
        byte[] bytes = new byte[this.byteSize];
        for (int i = 0; i < this.byteSize; ++i) {
            byte b;
            bytes[i] = b = (byte)value;
            value >>= 8;
        }
        if (settings.isBigEndian()) {
            this.reverse(bytes);
        }
        return bytes;
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)("Interpret values as a sequence of\n" + this.longName + " numbers, separated by spaces"));
    }

    @Override
    public int compareValues(byte[] bytes1, byte[] bytes2, SearchSettings settings) {
        boolean isBigEndian = settings.isBigEndian();
        for (int i = 0; i < bytes1.length / this.byteSize; ++i) {
            double value2;
            double value1 = this.getValue(bytes1, i, isBigEndian);
            if (value1 == (value2 = this.getValue(bytes2, i, isBigEndian).doubleValue())) continue;
            return Double.compare(value1, value2);
        }
        return 0;
    }

    public Double getValue(byte[] bytes, int index, boolean isBigEndian) {
        long bits = this.fromBytes(bytes, index, isBigEndian);
        switch (this.byteSize) {
            case 4: {
                float f = Float.intBitsToFloat((int)bits);
                return f;
            }
        }
        return Double.longBitsToDouble(bits);
    }

    private long fromBytes(byte[] bytes, int index, boolean isBigEndian) {
        byte[] bigEndianBytes = new byte[this.byteSize];
        System.arraycopy(bytes, index * this.byteSize, bigEndianBytes, 0, this.byteSize);
        if (!isBigEndian) {
            this.reverse(bigEndianBytes);
        }
        long value = 0L;
        for (int i = 0; i < bigEndianBytes.length; ++i) {
            value = value << 8 | (long)(bigEndianBytes[i] & 0xFF);
        }
        return value;
    }

    @Override
    public String getValueString(byte[] bytes, SearchSettings settings) {
        StringBuilder buffer = new StringBuilder();
        int numValues = bytes.length / this.byteSize;
        for (int i = 0; i < numValues; ++i) {
            double value = this.getValue(bytes, i, settings.isBigEndian());
            buffer.append(Double.toString(value));
            if (i == numValues - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    @Override
    public String convertText(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        SearchFormat oldFormat = oldSettings.getSearchFormat();
        switch (oldFormat.getFormatType()) {
            case BYTE: {
                return this.getTextFromBytes(text, oldFormat, oldSettings);
            }
        }
        return this.isValidText(text, newSettings) ? text : "";
    }

    private String getTextFromBytes(String text, SearchFormat oldFormat, SearchSettings settings) {
        MaskedByteSequenceByteMatcher matcher;
        byte[] bytes;
        ByteMatcher byteMatcher = oldFormat.parse(text, settings);
        if (byteMatcher instanceof MaskedByteSequenceByteMatcher && (bytes = (matcher = (MaskedByteSequenceByteMatcher)byteMatcher).getBytes()).length >= this.byteSize) {
            String valueString = this.getValueString(bytes, settings);
            return valueString.replaceAll(",", "");
        }
        return this.isValidText(text, settings) ? text : "";
    }

    @Override
    public SearchFormat.SearchFormatType getFormatType() {
        return SearchFormat.SearchFormatType.FLOATING_POINT;
    }
}

