/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffLineNumber
implements StructConverter {
    public static final int SIZEOF = 6;
    private int l_addr;
    private short l_lnno;

    CoffLineNumber(BinaryReader reader) throws IOException {
        this.l_addr = reader.readNextInt();
        this.l_lnno = reader.readNextShort();
    }

    public int getAddress() {
        return this.l_addr;
    }

    public long getFunctionNameSymbolIndex() {
        return this.l_addr;
    }

    public short getLineNumber() {
        return this.l_lnno;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(CoffLineNumber.class);
    }
}

