/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ObfuscatedFileByteProvider;
import java.io.IOException;
import java.io.OutputStream;

public class ObfuscatedOutputStream
extends OutputStream {
    private OutputStream delegate;
    private long currentPosition;

    public ObfuscatedOutputStream(OutputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] tmpBuffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            long byteIndex = this.currentPosition + (long)i;
            int xorMaskIndex = (int)(byteIndex % (long)ObfuscatedFileByteProvider.XOR_MASK_BYTES.length);
            byte xorMask = ObfuscatedFileByteProvider.XOR_MASK_BYTES[xorMaskIndex];
            tmpBuffer[i] = (byte)(b[i + off] ^ xorMask);
        }
        this.delegate.write(tmpBuffer, 0, tmpBuffer.length);
        this.currentPosition += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }
}

