/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.analysis.rust.RustConstants;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.framework.Application;
import ghidra.framework.store.LockException;
import ghidra.program.database.SpecExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.bytesearch.GenericByteSequencePattern;
import ghidra.util.bytesearch.GenericMatchAction;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MemoryBytePatternSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xml.sax.SAXException;

public class RustUtilities {
    public static boolean isRust(Program program, MemoryBlock block, TaskMonitor monitor) throws IOException, CancelledException {
        if (block == null) {
            return false;
        }
        GenericMatchAction<AtomicBoolean> action = new GenericMatchAction<AtomicBoolean>(new AtomicBoolean()){

            @Override
            public void apply(Program prog, Address addr, Match match) {
                ((AtomicBoolean)this.getMatchValue()).set(true);
            }
        };
        MemoryBytePatternSearcher searcher = new MemoryBytePatternSearcher("Rust signatures");
        for (byte[] sig : RustConstants.RUST_SIGNATURES) {
            searcher.addPattern(new GenericByteSequencePattern<AtomicBoolean>(sig, action));
        }
        searcher.search(program, (AddressSetView)new AddressSet(block.getAddressRange()), monitor);
        return ((AtomicBoolean)action.getMatchValue()).get();
    }

    public static boolean isRustProgram(Program program) {
        String name = program.getCompiler();
        return name != null && name.contains("rustc");
    }

    public static int addExtensions(Program program, TaskMonitor monitor, String subPath) throws IOException {
        Language language = program.getLanguageCompilerSpecPair().getLanguage();
        Processor processor = language.getProcessor();
        int bitSize = language.getLanguageDescription().getSize();
        String spath = "extensions/rust/" + subPath + bitSize;
        ResourceFile module = Application.getModuleDataSubDirectory((String)processor.toString(), (String)spath);
        int extensionCount = 0;
        ResourceFile[] files = module.listFiles();
        if (files != null) {
            for (ResourceFile file : files) {
                InputStream stream = file.getInputStream();
                byte[] bytes = stream.readAllBytes();
                String xml = new String(bytes);
                try {
                    SpecExtension extension = new SpecExtension(program);
                    extension.addReplaceCompilerSpecExtension(xml, monitor);
                    ++extensionCount;
                }
                catch (SleighException | LockException | XmlParseException | SAXException e) {
                    Msg.error(RustUtilities.class, (Object)("Failed to load Rust cspec extension: " + file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return extensionCount;
    }
}

