/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.function.EditFunctionSignatureDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import java.util.Iterator;

public class OverridePrototypeAction
extends AbstractDecompilerAction {
    public OverridePrototypeAction() {
        super("Override Signature");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionOverrideSignature"));
        this.setPopupMenuData(new MenuData(new String[]{"Override Signature"}, "Decompile"));
    }

    static PcodeOp getCallOp(Program program, ClangToken tokenAtCursor) {
        PcodeOp op;
        PcodeOp op2;
        if (tokenAtCursor == null) {
            return null;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return ((ClangFuncNameToken)tokenAtCursor).getPcodeOp();
        }
        Address addr = tokenAtCursor.getMinAddress();
        if (addr != null && (op2 = OverridePrototypeAction.getOpForAddress(program, addr, tokenAtCursor)) != null) {
            return op2;
        }
        ClangNode parent = tokenAtCursor.Parent();
        if (parent instanceof ClangStatement && OverridePrototypeAction.isCallOp(op = ((ClangStatement)parent).getPcodeOp())) {
            return op;
        }
        return null;
    }

    static Symbol getSymbol(Function func, ClangToken tokenAtCursor) {
        if (tokenAtCursor == null || func instanceof UndefinedFunction) {
            return null;
        }
        Namespace overspace = HighFunction.findOverrideSpace((Function)func);
        if (overspace == null) {
            return null;
        }
        PcodeOp op = OverridePrototypeAction.getCallOp(func.getProgram(), tokenAtCursor);
        if (op == null) {
            return null;
        }
        SymbolTable symtab = func.getProgram().getSymbolTable();
        SymbolIterator iter = symtab.getSymbolsAsIterator(op.getSeqnum().getTarget());
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (sym.getSymbolType() != SymbolType.LABEL || !sym.getParentNamespace().equals((Object)overspace) || !sym.getName().startsWith("prt")) continue;
            return sym;
        }
        return null;
    }

    private static PcodeOp getOpForAddress(Program program, Address addr, ClangToken token) {
        ClangFunction cfunc = token.getClangFunction();
        if (cfunc == null) {
            return null;
        }
        Instruction instr = program.getListing().getInstructionAt(addr);
        if (instr == null) {
            return null;
        }
        if (!instr.getFlowType().isCall()) {
            return null;
        }
        HighFunction hfunc = cfunc.getHighFunction();
        Iterator iter = hfunc.getPcodeOps(addr);
        while (iter.hasNext()) {
            PcodeOpAST op = (PcodeOpAST)iter.next();
            if (!OverridePrototypeAction.isCallOp((PcodeOp)op)) continue;
            return op;
        }
        return null;
    }

    private static boolean isCallOp(PcodeOp op) {
        if (op == null) {
            return false;
        }
        int opCode = op.getOpcode();
        return opCode == 7 || opCode == 8;
    }

    static Function getCalledFunction(Program program, PcodeOp op) {
        Reference[] references;
        if (op.getOpcode() != 7) {
            return null;
        }
        Address addr = op.getInput(0).getAddress();
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(addr);
        if (function != null) {
            return function;
        }
        Address opAddr = op.getSeqnum().getTarget();
        for (Reference ref : references = program.getReferenceManager().getFlowReferencesFrom(opAddr)) {
            if (!ref.getReferenceType().isCall() || (function = functionManager.getFunctionAt(ref.getToAddress())) == null) continue;
            return function;
        }
        return null;
    }

    private String generateSignature(PcodeOp op, String name, Function calledfunc) {
        if (calledfunc != null && calledfunc.getSignatureSource().isLowerOrEqualPriorityThan(SourceType.ANALYSIS)) {
            calledfunc = null;
        }
        StringBuffer buf = new StringBuffer();
        Varnode vn = op.getOutput();
        DataType dt = null;
        if (calledfunc != null && Undefined.isUndefined((DataType)(dt = calledfunc.getReturnType()))) {
            dt = null;
        }
        if (dt == null && vn != null) {
            dt = vn.getHigh().getDataType();
        }
        if (dt != null) {
            buf.append(dt.getDisplayName());
        } else {
            buf.append(DataType.VOID.getDisplayName());
        }
        buf.append(' ').append(name).append('(');
        int index = 1;
        if (calledfunc != null) {
            for (Parameter p : calledfunc.getParameters()) {
                String dtName = this.getInputDataTypeName(op, index, p.getDataType());
                if (index++ != 1) {
                    buf.append(", ");
                }
                buf.append(dtName);
                if (p.getSource() == SourceType.DEFAULT) continue;
                buf.append(' ');
                buf.append(p.getName());
            }
        }
        for (int i = index; i < op.getNumInputs(); ++i) {
            if (i != 1) {
                buf.append(", ");
            }
            buf.append(this.getInputDataTypeName(op, i, null));
        }
        buf.append(')');
        return buf.toString();
    }

    private String getInputDataTypeName(PcodeOp op, int inIndex, DataType preferredDt) {
        if (preferredDt != null && !Undefined.isUndefined((DataType)preferredDt)) {
            return preferredDt.getDisplayName();
        }
        Varnode vn = op.getInput(inIndex);
        DataType dt = null;
        if (vn != null) {
            dt = vn.getHigh().getDataType();
        }
        if (dt != null) {
            return dt.getDisplayName();
        }
        return "BAD";
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        PcodeOp callOp = OverridePrototypeAction.getCallOp(context.getProgram(), context.getTokenAtCursor());
        if (callOp == null) {
            return false;
        }
        return OverridePrototypeAction.getSymbol(context.getFunction(), context.getTokenAtCursor()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        String signature;
        FunctionDefinition fdef;
        Function func = context.getFunction();
        Program program = func.getProgram();
        PcodeOp op = OverridePrototypeAction.getCallOp(program, context.getTokenAtCursor());
        Function calledFunc = OverridePrototypeAction.getCalledFunction(program, op);
        boolean varargs = false;
        if (calledFunc != null) {
            varargs = calledFunc.hasVarArgs();
        }
        if (op.getOpcode() == 7 && !varargs && OptionDialog.showOptionDialog((Component)context.getDecompilerPanel(), (String)"Warning : Localized Override", (String)"Incorrect information entered here may hide other good information.\nFor direct calls, it is usually better to alter the prototype on the function\nitself, rather than overriding the local call. Proceed anyway?", (String)"Proceed") != 1) {
            return;
        }
        String name = "func";
        if (calledFunc != null) {
            name = calledFunc.getName();
        }
        if ((fdef = OverridePrototypeAction.editSignature(context, calledFunc, signature = this.generateSignature(op, name, calledFunc))) == null) {
            return;
        }
        int transaction = program.startTransaction("Override Signature");
        boolean commit = false;
        try {
            Address addr = op.getSeqnum().getTarget();
            HighFunctionDBUtil.writeOverride((Function)func, (Address)addr, (FunctionSignature)fdef);
            commit = true;
        }
        catch (Exception e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)context.getDecompilerPanel(), (String)"Override Signature Failed", (Object)("Error overriding signature: " + String.valueOf(e)));
        }
        finally {
            program.endTransaction(transaction, commit);
        }
    }

    static FunctionDefinition editSignature(DecompilerActionContext context, Function calledFunc, String signature) {
        Function func = context.getFunction();
        Program program = func.getProgram();
        PluginTool tool = context.getTool();
        String conv = program.getCompilerSpec().getDefaultCallingConvention().getName();
        if (calledFunc != null) {
            conv = calledFunc.getCallingConventionName();
        }
        ProtoOverrideDialog dialog = new ProtoOverrideDialog(tool, calledFunc != null ? calledFunc : func, signature, conv);
        tool.showDialog((DialogComponentProvider)dialog);
        return dialog.getFunctionDefinition();
    }

    private static class ProtoOverrideDialog
    extends EditFunctionSignatureDialog {
        private FunctionDefinition functionDefinition;
        private final String initialSignature;
        private final String initialConvention;

        public ProtoOverrideDialog(PluginTool tool, Function func, String signature, String conv) {
            super(tool, "Override Signature", func, false, true, false);
            this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionOverrideSignature"));
            this.initialSignature = signature;
            this.initialConvention = conv;
        }

        protected String getPrototypeString() {
            return this.initialSignature;
        }

        protected String getCallingConventionName() {
            return this.initialConvention;
        }

        protected boolean applyChanges() throws CancelledException {
            return this.parseFunctionDefinition();
        }

        private boolean parseFunctionDefinition() {
            this.functionDefinition = null;
            try {
                this.functionDefinition = this.parseSignature();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.functionDefinition == null) {
                return false;
            }
            this.functionDefinition.setNoReturn(this.hasNoReturnSelected());
            try {
                this.functionDefinition.setCallingConvention(this.getCallingConvention());
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            return true;
        }

        public FunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }
    }
}

