/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.TokenKey;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TokenHighlights
implements Iterable<HighlightToken> {
    private Map<TokenKey, HighlightToken> highlightsByToken = new HashMap<TokenKey, HighlightToken>();

    public Map<String, Color> copyHighlightsByName() {
        HashMap<String, Color> results = new HashMap<String, Color>();
        Collection<HighlightToken> values = this.highlightsByToken.values();
        for (HighlightToken hl : values) {
            String name = hl.getToken().getText();
            results.put(name, hl.getColor());
        }
        return results;
    }

    private TokenKey getKey(HighlightToken ht) {
        return new TokenKey(ht);
    }

    private TokenKey getKey(ClangToken t) {
        return new TokenKey(t);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.highlightsByToken.size();
    }

    public void add(HighlightToken t) {
        this.highlightsByToken.put(this.getKey(t), t);
    }

    public HighlightToken get(ClangToken t) {
        return this.highlightsByToken.get(this.getKey(t));
    }

    public boolean contains(ClangToken t) {
        return this.highlightsByToken.containsKey(this.getKey(t));
    }

    public void clear() {
        this.highlightsByToken.clear();
    }

    public void remove(ClangToken t) {
        this.highlightsByToken.remove(this.getKey(t));
    }

    @Override
    public Iterator<HighlightToken> iterator() {
        return this.highlightsByToken.values().iterator();
    }

    public String toString() {
        return this.highlightsByToken.values().toString();
    }
}

