/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.onetomany;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyTableModel;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class VTMatchSourceTableModel
extends VTMatchOneToManyTableModel {
    private static final String TITLE = "VTMatch Source Table Model";

    public VTMatchSourceTableModel(ServiceProvider serviceProvider, VTController vtController) {
        super(TITLE, vtController);
    }

    protected TableColumnDescriptor<VTMatch> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SessionNumberTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.StatusTableColumn(), 1, true);
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MatchTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ScoreTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ConfidenceScoreTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ImpliedMatchCountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.RelatedMatchCountColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MultipleDestinationLabelsTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationNamespaceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLabelTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLabelSourceTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationAddressTableColumn(), 2, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLengthTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLengthTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.LengthDeltaTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AlgorithmTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.TagTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AppliedMarkupStatusBatteryTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AppliedMarkupStatusTableColumn());
        return descriptor;
    }

    @Override
    public Address getAddress(int row) {
        VTMatch match = (VTMatch)this.getRowObject(row);
        VTAssociation association = match.getAssociation();
        return association.getDestinationAddress();
    }

    @Override
    protected void doLoad(Accumulator<VTMatch> accumulator, TaskMonitor monitor) throws CancelledException {
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        VTAssociationManager associationManager = this.session.getAssociationManager();
        if (this.address == null || associationManager == null) {
            return;
        }
        Collection<VTAssociation> associations = associationManager.getRelatedAssociationsBySourceAddress(this.address);
        monitor.initialize((long)associations.size());
        for (VTAssociation vtAssociation : associations) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            for (VTMatchSet matchSet : matchSets) {
                monitor.checkCancelled();
                Collection<VTMatch> matches = matchSet.getMatches(vtAssociation);
                for (VTMatch match : matches) {
                    monitor.checkCancelled();
                    accumulator.add((Object)match);
                }
            }
        }
    }

    @Override
    protected Comparator<VTMatch> createSortComparator(int columnIndex) {
        int destinationAddressColumnIndex = this.getColumnIndex(AbstractVTMatchTableModel.DestinationAddressTableColumn.class);
        if (destinationAddressColumnIndex == columnIndex) {
            return new AbstractVTMatchTableModel.DestinationAddressComparator();
        }
        return super.createSortComparator(columnIndex);
    }
}

