/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class TaintGateAction
extends TaintAbstractDecompilerAction {
    private TaintPlugin plugin;
    private TaintState.MarkType mtype;

    public TaintGateAction(TaintPlugin plugin) {
        super("Mark Gate");
        this.setHelpLocation(new HelpLocation("DecompilerTaint", "TaintGate"));
        this.setPopupMenuData(new MenuData(new String[]{"Taint", "Gate"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(83, 512));
        this.plugin = plugin;
        this.mtype = TaintState.MarkType.GATE;
    }

    protected void mark(ClangToken token) {
        this.plugin.toggleIcon(this.mtype, token, false);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (this.plugin.getTaintState() == null) {
            return false;
        }
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return false;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return true;
        }
        return tokenAtCursor.isVariableRef();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        this.mark(context.getTokenAtCursor());
    }
}

