/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Handle
implements StructConverter {
    public static final String NAME = "MINIDUMP_HANDLE";
    private long handle;
    private int typeNameRVA;
    private int objectNameRVA;
    private int attributes;
    private int GrantedAccess;
    private int HandleCount;
    private int PointerCount;
    private int ObjectInfoRva;
    private DumpFileReader reader;
    private long index;
    private int entrySize;
    private boolean expandedFormat;

    Handle(DumpFileReader reader, long index, int entrySize) throws IOException {
        this.reader = reader;
        this.index = index;
        this.entrySize = entrySize;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setHandle(this.reader.readNextLong());
        this.setTypeNameRVA(this.reader.readNextInt());
        this.setObjectNameRVA(this.reader.readNextInt());
        this.setAttributes(this.reader.readNextInt());
        this.setGrantedAccess(this.reader.readNextInt());
        this.setHandleCount(this.reader.readNextInt());
        this.setPointerCount(this.reader.readNextInt());
        boolean bl = this.expandedFormat = (long)this.entrySize > this.reader.getPointerIndex() - this.index;
        if (this.expandedFormat) {
            this.setObjectInfoRva(this.reader.readNextInt());
            this.reader.readNextInt();
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "Handle", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "TypeNameRVA", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ObjectNameRVA", null);
        struct.add(DWORD, 4, "Attributes", null);
        struct.add(DWORD, 4, "GrantedAccess", null);
        struct.add(DWORD, 4, "HandleCount", null);
        struct.add(DWORD, 4, "PointerCount", null);
        if (this.expandedFormat) {
            struct.add((DataType)Pointer32DataType.dataType, 4, "ObjectInfoRva", null);
            struct.add(DWORD, 4, "Reserved0", null);
        }
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getHandle() {
        return this.handle;
    }

    public void setHandle(long handle) {
        this.handle = handle;
    }

    public int getTypeNameRVA() {
        return this.typeNameRVA;
    }

    public void setTypeNameRVA(int typeNameRVA) {
        this.typeNameRVA = typeNameRVA;
    }

    public int getObjectNameRVA() {
        return this.objectNameRVA;
    }

    public void setObjectNameRVA(int objectNameRVA) {
        this.objectNameRVA = objectNameRVA;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public void setAttributes(int attributes) {
        this.attributes = attributes;
    }

    public int getGrantedAccess() {
        return this.GrantedAccess;
    }

    public void setGrantedAccess(int grantedAccess) {
        this.GrantedAccess = grantedAccess;
    }

    public int getHandleCount() {
        return this.HandleCount;
    }

    public void setHandleCount(int handleCount) {
        this.HandleCount = handleCount;
    }

    public int getPointerCount() {
        return this.PointerCount;
    }

    public void setPointerCount(int pointerCount) {
        this.PointerCount = pointerCount;
    }

    public int getObjectInfoRva() {
        return this.ObjectInfoRva;
    }

    public void setObjectInfoRva(int objectInfoRva) {
        this.ObjectInfoRva = objectInfoRva;
    }
}

