/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target;

import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceExecutionState;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceExecutionStateful;
import ghidra.trace.model.target.iface.TraceMethod;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.Collection;
import java.util.stream.Stream;

public interface TraceObject
extends TraceUniqueObject {
    public static final String EXTRA_INTERFACES_ATTRIBUTE_NAME = "_extra_ifs";

    public Trace getTrace();

    public long getKey();

    public TraceObject getRoot();

    public KeyPath getCanonicalPath();

    public Lifespan.LifeSet getLife();

    public boolean isAlive(long var1);

    public boolean isAlive(Lifespan var1);

    public TraceObjectValPath insert(Lifespan var1, ConflictResolution var2);

    public void remove(Lifespan var1);

    public void removeTree(Lifespan var1);

    public TraceObjectValue getCanonicalParent(long var1);

    public Stream<? extends TraceObjectValue> getCanonicalParents(Lifespan var1);

    public boolean isRoot();

    public Stream<? extends TraceObjectValPath> getAllPaths(Lifespan var1);

    public Collection<Class<? extends TraceObjectInterface>> getInterfaces();

    public <I extends TraceObjectInterface> I queryInterface(Class<I> var1);

    public Collection<? extends TraceObjectValue> getParents(Lifespan var1);

    public Collection<? extends TraceObjectValue> getValues(Lifespan var1);

    public Collection<? extends TraceObjectValue> getValues(Lifespan var1, String var2);

    public Stream<? extends TraceObjectValue> getOrderedValues(Lifespan var1, String var2, boolean var3);

    public Collection<? extends TraceObjectValue> getElements(Lifespan var1);

    public Collection<? extends TraceObjectValue> getAttributes(Lifespan var1);

    public TraceObjectValue getValue(long var1, String var3);

    public TraceObjectValue getElement(long var1, String var3);

    public TraceObjectValue getElement(long var1, long var3);

    public TraceObjectValue getAttribute(long var1, String var3);

    public Stream<? extends TraceObjectValPath> getAncestorsRoot(Lifespan var1, PathFilter var2);

    public Stream<? extends TraceObjectValPath> getAncestors(Lifespan var1, PathFilter var2);

    public Stream<? extends TraceObjectValPath> getSuccessors(Lifespan var1, PathFilter var2);

    public Stream<? extends TraceObjectValPath> getOrderedSuccessors(Lifespan var1, KeyPath var2, boolean var3);

    public Stream<? extends TraceObjectValPath> getCanonicalSuccessors(PathFilter var1);

    public TraceObjectValue setValue(Lifespan var1, String var2, Object var3, ConflictResolution var4);

    public TraceObjectValue setValue(Lifespan var1, String var2, Object var3);

    public TraceObjectValue setAttribute(Lifespan var1, String var2, Object var3);

    public TraceObjectValue setElement(Lifespan var1, String var2, Object var3);

    public TraceObjectValue setElement(Lifespan var1, long var2, Object var4);

    public TraceObjectSchema getSchema();

    public Stream<? extends TraceObjectValPath> findAncestorsInterface(Lifespan var1, Class<? extends TraceObjectInterface> var2);

    public <I extends TraceObjectInterface> Stream<I> queryAncestorsInterface(Lifespan var1, Class<I> var2);

    public Stream<? extends TraceObject> findCanonicalAncestorsInterface(Class<? extends TraceObjectInterface> var1);

    public <I extends TraceObjectInterface> Stream<I> queryCanonicalAncestorsInterface(Class<I> var1);

    public Stream<? extends TraceObjectValPath> findSuccessorsInterface(Lifespan var1, Class<? extends TraceObjectInterface> var2, boolean var3);

    public <I extends TraceObjectInterface> Stream<I> querySuccessorsInterface(Lifespan var1, Class<I> var2, boolean var3);

    public void delete();

    @Override
    public boolean isDeleted();

    default public boolean isMethod(long snap) {
        if (this.getSchema().getInterfaces().contains(TraceMethod.class)) {
            return true;
        }
        TraceObjectValue extras = this.getAttribute(snap, EXTRA_INTERFACES_ATTRIBUTE_NAME);
        if (extras == null) {
            return false;
        }
        Object val = extras.getValue();
        if (!(val instanceof String)) {
            return false;
        }
        String valStr = (String)val;
        return valStr.contains("Method");
    }

    default public TraceObject findSuitableInterface(Class<? extends TraceObjectInterface> iface) {
        if (iface == TraceObjectInterface.class) {
            return this;
        }
        KeyPath path = this.getRoot().getSchema().searchForSuitable(iface, this.getCanonicalPath());
        if (path == null) {
            return null;
        }
        return this.getTrace().getObjectManager().getObjectByCanonicalPath(path);
    }

    default public TraceObject findSuitableContainerInterface(Class<? extends TraceObjectInterface> iface) {
        KeyPath path = this.getRoot().getSchema().searchForSuitableContainer(iface, this.getCanonicalPath());
        if (path == null) {
            return null;
        }
        return this.getTrace().getObjectManager().getObjectByCanonicalPath(path);
    }

    default public TraceObject findSuitableSchema(TraceObjectSchema schema) {
        KeyPath path = this.getRoot().getSchema().searchForSuitable(schema, this.getCanonicalPath());
        if (path == null) {
            return null;
        }
        return this.getTrace().getObjectManager().getObjectByCanonicalPath(path);
    }

    default public TraceObject findRegisterContainer(int frameLevel) {
        PathFilter regsMatcher = this.getRoot().getSchema().searchForRegisterContainer(frameLevel, this.getCanonicalPath());
        for (PathPattern regsPattern : regsMatcher.getPatterns()) {
            TraceObject regsObj = this.getTrace().getObjectManager().getObjectByCanonicalPath(regsPattern.getSingletonPath());
            if (regsObj == null) continue;
            return regsObj;
        }
        return null;
    }

    default public TraceExecutionState getExecutionState(long snap) {
        TraceObject stateful = this.findSuitableInterface(TraceExecutionStateful.class);
        if (stateful == null) {
            return null;
        }
        TraceObjectValue stateVal = stateful.getAttribute(snap, "_state");
        if (stateVal == null) {
            return TraceExecutionState.INACTIVE;
        }
        return TraceExecutionState.valueOf((String)stateVal.castValue());
    }

    public static enum ConflictResolution {
        TRUNCATE,
        DENY,
        ADJUST;

    }
}

