/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;

public class OpBehaviorIntNegate
extends UnaryOpBehavior {
    public OpBehaviorIntNegate() {
        super(25);
    }

    @Override
    public long evaluateUnary(int sizeout, int sizein, long in1) {
        long res = Utils.uintb_negate((long)in1, (int)sizein);
        return res;
    }

    @Override
    public BigInteger evaluateUnary(int sizeout, int sizein, BigInteger in1) {
        if (in1.signum() < 0) {
            throw new AssertException("Expected unsigned in value");
        }
        return in1.not();
    }
}

