/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PairedPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class PairedPcodeExecutorState<L, R>
implements PcodeExecutorState<Pair<L, R>> {
    private final PairedPcodeExecutorStatePiece<L, L, R> piece;
    private final PcodeArithmetic<Pair<L, R>> arithmetic;

    public PairedPcodeExecutorState(PairedPcodeExecutorStatePiece<L, L, R> piece) {
        this.piece = piece;
        this.arithmetic = piece.getArithmetic();
    }

    public PairedPcodeExecutorState(PcodeExecutorState<L> left, PcodeExecutorStatePiece<L, R> right, PcodeArithmetic<Pair<L, R>> arithmetic) {
        this.piece = new PairedPcodeExecutorStatePiece<L, L, R>(left, right, left.getArithmetic(), arithmetic);
        this.arithmetic = arithmetic;
    }

    public PairedPcodeExecutorState(PcodeExecutorState<L> left, PcodeExecutorStatePiece<L, R> right) {
        this(left, right, new PairedPcodeArithmetic(left.getArithmetic(), right.getArithmetic()));
    }

    @Override
    public Language getLanguage() {
        return this.piece.getLanguage();
    }

    @Override
    public PcodeArithmetic<Pair<L, R>> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return this.piece.streamPieces();
    }

    @Override
    public Map<Register, Pair<L, R>> getRegisterValues() {
        return this.piece.getRegisterValues();
    }

    @Override
    public PairedPcodeExecutorState<L, R> fork(PcodeStateCallbacks cb) {
        return new PairedPcodeExecutorState<L, R>(this.piece.fork(cb));
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return this.piece.getConcreteBuffer(address, purpose);
    }

    public PcodeExecutorStatePiece<L, L> getLeft() {
        return this.piece.getLeft();
    }

    public PcodeExecutorStatePiece<L, R> getRight() {
        return this.piece.getRight();
    }

    @Override
    public void setVar(AddressSpace space, Pair<L, R> offset, int size, boolean quantize, Pair<L, R> val) {
        this.piece.setVar(space, offset.getLeft(), size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, Pair<L, R> offset, int size, Pair<L, R> val) {
        this.piece.setVarInternal(space, offset.getLeft(), size, val);
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean quantize, Pair<L, R> val) {
        this.piece.setVar(space, offset, size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, long offset, int size, Pair<L, R> val) {
        this.piece.setVarInternal(space, offset, size, val);
    }

    @Override
    public Pair<L, R> getVar(AddressSpace space, Pair<L, R> offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVar(space, (L)offset.getLeft(), size, quantize, reason);
    }

    @Override
    public Pair<L, R> getVarInternal(AddressSpace space, Pair<L, R> offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVarInternal(space, (L)offset.getLeft(), size, reason);
    }

    @Override
    public Pair<L, R> getVar(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVar(space, offset, size, quantize, reason);
    }

    @Override
    public Pair<L, R> getVarInternal(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVarInternal(space, offset, size, reason);
    }

    @Override
    public void clear() {
        this.piece.clear();
    }
}

