// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GTKMM_COLUMNVIEWCOLUMN_H
#define _GTKMM_COLUMNVIEWCOLUMN_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <gtkmm/listitemfactory.h>
#include <giomm/menumodel.h>
#include <gtkmm/sorter.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkColumnViewColumn = struct _GtkColumnViewColumn;
using GtkColumnViewColumnClass = struct _GtkColumnViewColumnClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API ColumnViewColumn_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class GTKMM_API ColumnView;

/** The column added to Gtk::ColumnView.
 *
 * %Gtk::ColumnViewColumn represents the columns being added to Gtk::ColumnView.
 *
 * Columns have a title, and can optionally have a header menu set
 * with set_header_menu().
 *
 * A sorter can be associated with a column using set_sorter(), to let
 * users influence sorting by clicking on the column header.
 *
 * @see Gtk::ColumnView
 *
 * @ingroup ListView
 */

class GTKMM_API ColumnViewColumn : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = ColumnViewColumn;
  using CppClassType = ColumnViewColumn_Class;
  using BaseObjectType = GtkColumnViewColumn;
  using BaseClassType = GtkColumnViewColumnClass;

  // noncopyable
  ColumnViewColumn(const ColumnViewColumn&) = delete;
  ColumnViewColumn& operator=(const ColumnViewColumn&) = delete;

private:  friend class ColumnViewColumn_Class;
  static CppClassType columnviewcolumn_class_;

protected:
  explicit ColumnViewColumn(const Glib::ConstructParams& construct_params);
  explicit ColumnViewColumn(GtkColumnViewColumn* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  ColumnViewColumn(ColumnViewColumn&& src) noexcept;
  ColumnViewColumn& operator=(ColumnViewColumn&& src) noexcept;

  ~ColumnViewColumn() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkColumnViewColumn*       gobj()       { return reinterpret_cast<GtkColumnViewColumn*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkColumnViewColumn* gobj() const { return reinterpret_cast<GtkColumnViewColumn*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkColumnViewColumn* gobj_copy();

private:


protected:
    explicit ColumnViewColumn(const Glib::ustring& title, const Glib::RefPtr<ListItemFactory>& factory =  {});


public:
  
  static Glib::RefPtr<ColumnViewColumn> create(const Glib::ustring& title, const Glib::RefPtr<ListItemFactory>& factory =  {});


  /** Gets the column view that's currently displaying this column.
   * 
   * If @a self has not been added to a column view yet, <tt>nullptr</tt> is returned.
   * 
   * @return The column view displaying @a self.
   */
  ColumnView* get_column_view();
  
  /** Gets the column view that's currently displaying this column.
   * 
   * If @a self has not been added to a column view yet, <tt>nullptr</tt> is returned.
   * 
   * @return The column view displaying @a self.
   */
  const ColumnView* get_column_view() const;
  
  /** Sets the `Gtk::ListItemFactory` to use for populating list items
   * for this column.
   * 
   * @param factory The factory to use.
   */
  void set_factory(const Glib::RefPtr<ListItemFactory>& factory);
  
  /** Gets the factory that's currently used to populate list items
   * for this column.
   * 
   * @return The factory in use.
   */
  Glib::RefPtr<ListItemFactory> get_factory();
  
  /** Gets the factory that's currently used to populate list items
   * for this column.
   * 
   * @return The factory in use.
   */
  Glib::RefPtr<const ListItemFactory> get_factory() const;

  
  /** Sets the title of this column.
   * 
   * The title is displayed in the header of a `Gtk::ColumnView`
   * for this column and is therefore user-facing text that should
   * be translated.
   * 
   * @param title Title to use for this column.
   */
  void set_title(const Glib::ustring& title);
  
  /** Returns the title set with set_title().
   * 
   * @return The column's title.
   */
  Glib::ustring get_title() const;

  
  /** Associates a sorter with the column.
   * 
   * If @a sorter is unset, the column will not let users change
   * the sorting by clicking on its header.
   * 
   * This sorter can be made active by clicking on the column
   * header, or by calling sort_by_column().
   * 
   * See get_sorter() for the necessary steps
   * for setting up customizable sorting for Gtk::ColumnView.
   * 
   * @param sorter The `Gtk::Sorter` to associate with @a column.
   */
  void set_sorter(const Glib::RefPtr<Sorter>& sorter);
  
  /** Returns the sorter that is associated with the column.
   * 
   * @return The `Gtk::Sorter` of @a self.
   */
  Glib::RefPtr<Sorter> get_sorter();
  
  /** Returns the sorter that is associated with the column.
   * 
   * @return The `Gtk::Sorter` of @a self.
   */
  Glib::RefPtr<const Sorter> get_sorter() const;

  
  /** Sets whether this column should be visible in views.
   * 
   * @param visible Whether this column should be visible.
   */
  void set_visible(bool visible =  true);
  
  /** Returns whether this column is visible.
   * 
   * @return True if this column is visible.
   */
  bool get_visible() const;

  
  /** Sets the menu model that is used to create the context menu
   * for the column header.
   * 
   * @param model A `Gio::MenuModel`.
   */
  void set_header_menu(const Glib::RefPtr<Gio::MenuModel>& model);
  
  /** Gets the menu model that is used to create the context menu
   * for the column header.
   * 
   * @return The `Gio::MenuModel`.
   */
  Glib::RefPtr<Gio::MenuModel> get_header_menu();
  
  /** Gets the menu model that is used to create the context menu
   * for the column header.
   * 
   * @return The `Gio::MenuModel`.
   */
  Glib::RefPtr<const Gio::MenuModel> get_header_menu() const;

  
  /** Sets the fixed width of the column.
   * 
   * If @a fixed_width is -1, the fixed width of the column is unset.
   * 
   * Setting a fixed width overrides the automatically calculated
   * width. Interactive resizing also sets the “fixed-width” property.
   * 
   * @param fixed_width The new fixed width, or -1.
   */
  void set_fixed_width(int fixed_width);
  
  /** Gets the fixed width of the column.
   * 
   * @return The fixed with of the column.
   */
  int get_fixed_width() const;

  
  /** Sets whether this column should be resizable by dragging.
   * 
   * @param resizable Whether this column should be resizable.
   */
  void set_resizable(bool resizable =  true);
  
  /** Returns whether this column is resizable.
   * 
   * @return True if this column is resizable.
   */
  bool get_resizable() const;

  
  /** Sets the column to take available extra space.
   * 
   * The extra space is shared equally amongst all columns that
   * have are set to expand.
   * 
   * @param expand Whether this column should expand to fill available space.
   */
  void set_expand(bool expand =  true);
  
  /** Returns whether this column should expand.
   * 
   * @return True if this column expands.
   */
  bool get_expand() const;

  
  /** Sets the id of this column.
   * 
   * GTK makes no use of this, but applications can use it when
   * storing column view configuration.
   * 
   * It is up to callers to ensure uniqueness of IDs.
   * 
   * @newin{4,10}
   * 
   * @param id ID to use for this column.
   */
  void set_id(const Glib::ustring& id);
  
  /** Returns the ID set with set_id().
   * 
   * @newin{4,10}
   * 
   * @return The column's ID.
   */
  Glib::ustring get_id() const;

  /** The `Gtk::ColumnView` this column is a part of.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ColumnView* > property_column_view() const;


  /** Factory for populating list items.
   * 
   * The factory must be for configuring Gtk::ColumnViewCell objects.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<ListItemFactory> > property_factory() ;

/** Factory for populating list items.
   * 
   * The factory must be for configuring Gtk::ColumnViewCell objects.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ListItemFactory> > property_factory() const;

  /** Title displayed in the header.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** Title displayed in the header.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** Sorter for sorting items according to this column.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Sorter> > property_sorter() ;

/** Sorter for sorting items according to this column.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Sorter> > property_sorter() const;

  /** Whether this column is visible.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible() ;

/** Whether this column is visible.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible() const;

  /** Menu model used to create the context menu for the column header.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > property_header_menu() ;

/** Menu model used to create the context menu for the column header.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > property_header_menu() const;

  /** Whether this column is resizable.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resizable() ;

/** Whether this column is resizable.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resizable() const;

  /** Column gets share of extra width allocated to the view.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_expand() ;

/** Column gets share of extra width allocated to the view.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_expand() const;

  /** If not -1, this is the width that the column is allocated,
   * regardless of the size of its content.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_fixed_width() ;

/** If not -1, this is the width that the column is allocated,
   * regardless of the size of its content.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_fixed_width() const;

  /** An ID for the column.
   * 
   * GTK is not currently using the ID for anything, but
   * it can be used by applications when saving column view
   * configurations.
   * 
   * It is up to applications to ensure uniqueness of IDs.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_id() ;

/** An ID for the column.
   * 
   * GTK is not currently using the ID for anything, but
   * it can be used by applications when saving column view
   * configurations.
   * 
   * It is up to applications to ensure uniqueness of IDs.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_id() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ColumnViewColumn
   */
  GTKMM_API
  Glib::RefPtr<Gtk::ColumnViewColumn> wrap(GtkColumnViewColumn* object, bool take_copy = false);
}


#endif /* _GTKMM_COLUMNVIEWCOLUMN_H */

