"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonCatalogDataAdaptor = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * A CatalogDataAdaptor that reads from a provided list of JSON objects.
 * Used to read Integration information when the user uploads their own catalog.
 */
class JsonCatalogDataAdaptor {
  /**
   * Creates a new FileSystemCatalogDataAdaptor instance.
   *
   * @param integrationsList The list of JSON-serialized integrations to use as a pseudo-directory.
   */
  constructor(integrationsList) {
    _defineProperty(this, "isConfigLocalized", true);
    _defineProperty(this, "integrationsList", void 0);
    this.integrationsList = integrationsList;
  }
  async findIntegrationVersions(dirname) {
    const versions = [];
    for (const integration of this.integrationsList) {
      if (dirname && integration.name !== dirname) {
        continue;
      }
      versions.push(integration.version);
    }
    return {
      ok: true,
      value: versions
    };
  }
  async readFile(filename, type) {
    if (type !== undefined) {
      return {
        ok: false,
        error: new Error('JSON adaptor does not support subtypes (isConfigLocalized: true)')
      };
    }
    const filenameParts = filename.match(/([\w]+)-(\d+(\.\d+)*)\.json/);
    for (const integ of this.integrationsList) {
      if (integ.name === (filenameParts === null || filenameParts === void 0 ? void 0 : filenameParts[1]) && integ.version === (filenameParts === null || filenameParts === void 0 ? void 0 : filenameParts[2])) {
        return {
          ok: true,
          value: integ
        };
      }
    }
    return {
      ok: false,
      error: new Error('Config file not found: ' + filename)
    };
  }
  async readFileRaw(_filename, _type) {
    return {
      ok: false,
      error: new Error('JSON adaptor does not support raw files (isConfigLocalized: true)')
    };
  }
  async findIntegrations(dirname = '.') {
    if (dirname !== '.') {
      return {
        ok: false,
        error: new Error('Finding integrations for custom dirs not supported for JSONreader')
      };
    }
    const result = new Set([]);
    for (const integration of this.integrationsList) {
      result.add(integration.name);
    }
    return {
      ok: true,
      value: [...result]
    };
  }
  async getDirectoryType(dirname) {
    // First, filter list by dirname if available
    const integrationsList = dirname ? this.integrationsList.filter(i => i.name === dirname) : this.integrationsList;
    if (integrationsList.length === 0) {
      return 'unknown';
    }
    // The list is an integration iff all of its names match
    for (let i = 0; i < integrationsList.length - 1; i++) {
      if (integrationsList[i].name !== integrationsList[i + 1].name) {
        return 'repository';
      }
    }
    return 'integration';
  }
  join(filename) {
    // In other adaptors, joining moves from directories to integrations.
    // Since for JSON catalogs we use a flat structure, we just filter.
    return new JsonCatalogDataAdaptor(this.integrationsList.filter(i => i.name === filename));
  }
}
exports.JsonCatalogDataAdaptor = JsonCatalogDataAdaptor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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