/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.alertsv2;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.MonitorRunnerExecutionContext;
import org.opensearch.alerting.alertsv2.AlertV2Mover;
import org.opensearch.alerting.alertsv2.AlertV2MoverKt;
import org.opensearch.alerting.modelv2.AlertV2;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.modelv2.TriggerV2;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.VersionType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\b\u0010!\u001a\u00020\u001cH\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0082@\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0#H\u0082@\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0#H\u0082@\u00a2\u0006\u0002\u0010)J(\u0010+\u001a\u0004\u0018\u00010'2\b\u0010,\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0#H\u0082@\u00a2\u0006\u0002\u0010-J\u0012\u0010.\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u00010'H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/opensearch/alerting/alertsv2/AlertV2Mover;", "Lorg/opensearch/cluster/ClusterStateListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "isClusterManager", "", "alertV2IndexInitialized", "alertV2HistoryIndexInitialized", "alertV2HistoryEnabled", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "scheduledAlertsV2CheckAndExpire", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "executorName", "", "checkForExpirationInterval", "Lorg/opensearch/common/unit/TimeValue;", "clusterChanged", "", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "onManager", "offManager", "moveOrDeleteAlertV2s", "searchForExpiredAlerts", "", "Lorg/opensearch/alerting/modelv2/AlertV2;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteExpiredAlerts", "Lorg/opensearch/action/bulk/BulkResponse;", "expiredAlerts", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyExpiredAlerts", "deleteExpiredAlertsThatWereCopied", "copyResponse", "(Lorg/opensearch/action/bulk/BulkResponse;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkForFailures", "bulkResponse", "alertV2ContentParser", "Lorg/opensearch/core/xcontent/XContentParser;", "bytesReference", "Lorg/opensearch/core/common/bytes/BytesReference;", "areAlertV2IndicesPresent", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nAlertV2Mover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertV2Mover.kt\norg/opensearch/alerting/alertsv2/AlertV2Mover\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,478:1\n1869#2,2:479\n1869#2,2:483\n1563#2:485\n1634#2,3:486\n1563#2:489\n1634#2,3:490\n1208#2,2:493\n1236#2,4:495\n1563#2:502\n1634#2,3:503\n295#2,2:509\n216#3,2:481\n4154#4:499\n4254#4,2:500\n3829#4:506\n4344#4,2:507\n*S KotlinDebug\n*F\n+ 1 AlertV2Mover.kt\norg/opensearch/alerting/alertsv2/AlertV2Mover\n*L\n174#1:479,2\n237#1:483,2\n255#1:485\n255#1:486,3\n275#1:489\n275#1:490,3\n299#1:493,2\n299#1:495,4\n301#1:502\n301#1:503,3\n317#1:509,2\n199#1:481,2\n301#1:499\n301#1:500,2\n316#1:506\n316#1:507,2\n*E\n"})
public final class AlertV2Mover
implements ClusterStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean isClusterManager;
    private boolean alertV2IndexInitialized;
    private boolean alertV2HistoryIndexInitialized;
    private Boolean alertV2HistoryEnabled;
    @Nullable
    private Scheduler.Cancellable scheduledAlertsV2CheckAndExpire;
    @NotNull
    private final String executorName;
    @NotNull
    private final TimeValue checkForExpirationInterval;

    public AlertV2Mover(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_V2_HISTORY_ENABLED(), arg_0 -> AlertV2Mover._init_$lambda$0(this, arg_0));
        this.alertV2HistoryEnabled = (Boolean)AlertingSettings.Companion.getALERT_V2_HISTORY_ENABLED().get(settings);
        this.executorName = "management";
        this.checkForExpirationInterval = new TimeValue(1L, TimeUnit.MINUTES);
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isClusterManager != event.localNodeClusterManager()) {
            this.isClusterManager = event.localNodeClusterManager();
            if (this.isClusterManager) {
                this.onManager();
            } else {
                this.offManager();
            }
        }
        this.alertV2IndexInitialized = event.state().routingTable().hasIndex(".opensearch-alerting-v2-alerts");
        this.alertV2HistoryIndexInitialized = event.state().metadata().hasAlias(".opensearch-alerting-v2-alert-history-write");
    }

    public final void onManager() {
        try {
            this.moveOrDeleteAlertV2s();
            this.scheduledAlertsV2CheckAndExpire = this.threadPool.scheduleWithFixedDelay(() -> AlertV2Mover.onManager$lambda$1(this), this.checkForExpirationInterval, this.executorName);
        }
        catch (Exception e) {
            AlertV2MoverKt.access$getLogger$p().error("Error sweeping AlertV2s for expiration. This cannot be done until clustermanager node is restarted.", (Throwable)e);
        }
    }

    public final void offManager() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledAlertsV2CheckAndExpire;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    private final void moveOrDeleteAlertV2s() {
        if (!this.areAlertV2IndicesPresent()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)AlertV2MoverKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ AlertV2Mover this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AlertV2Mover.access$searchForExpiredAlerts(this.this$0, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        expiredAlerts = (List)v0;
                        copyResponse = null;
                        deleteResponse = null;
                        if (AlertV2Mover.access$getAlertV2HistoryEnabled$p(this.this$0).booleanValue()) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)expiredAlerts);
                        this.label = 2;
                        v1 = AlertV2Mover.access$deleteExpiredAlerts(this.this$0, expiredAlerts, (Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        deleteResponse = null;
                        copyResponse = null;
                        expiredAlerts = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        deleteResponse = (BulkResponse)v1;
                        ** GOTO lbl58
                    }
                }
                this.L$0 = expiredAlerts;
                this.label = 3;
                v2 = AlertV2Mover.access$copyExpiredAlerts(this.this$0, expiredAlerts, (Continuation)this);
                if (v2 == var5_2) {
                    return var5_2;
                }
                ** GOTO lbl43
                {
                    case 3: {
                        deleteResponse = null;
                        copyResponse = null;
                        expiredAlerts = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl43:
                        // 2 sources

                        copyResponse = (BulkResponse)v2;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)expiredAlerts);
                        this.L$1 = copyResponse;
                        this.label = 4;
                        v3 = AlertV2Mover.access$deleteExpiredAlertsThatWereCopied(this.this$0, copyResponse, expiredAlerts, (Continuation)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl57
                    }
                    case 4: {
                        deleteResponse = null;
                        copyResponse = (BulkResponse)this.L$1;
                        expiredAlerts = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl57:
                        // 2 sources

                        deleteResponse = (BulkResponse)v3;
lbl58:
                        // 2 sources

                        AlertV2Mover.access$checkForFailures(this.this$0, copyResponse);
                        AlertV2Mover.access$checkForFailures(this.this$0, deleteResponse);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object searchForExpiredAlerts(Continuation<? super List<AlertV2>> $completion) {
        if (!($completion instanceof searchForExpiredAlerts.1)) ** GOTO lbl-1000
        var23_2 = $completion;
        if ((var23_2.label & -2147483648) != 0) {
            var23_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Mover this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertV2Mover.access$searchForExpiredAlerts(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                AlertV2MoverKt.access$getLogger$p().debug("beginning search for expired alerts");
                var3_5 = new String[]{"monitor_v2.ppl_monitor.triggers.id", "monitor_v2.ppl_monitor.triggers.expires_minutes"};
                monitorV2sSearchQuery = SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.existsQuery((String)"monitor_v2")).fetchSource(var3_5, null).size(AlertingUtilsKt.getMAX_SEARCH_SIZE()).version(Boxing.boxBoolean((boolean)true));
                var4_7 = new String[]{".opendistro-alerting-config"};
                monitorV2sRequest = new SearchRequest(var4_7).source(monitorV2sSearchQuery);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)monitorV2sSearchQuery);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)monitorV2sRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, searchForExpiredAlerts$lambda$2(org.opensearch.action.search.SearchRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((SearchRequest)monitorV2sRequest), (Continuation)$continuation);
                if (v0 == var24_4) {
                    return var24_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                monitorV2sRequest = (SearchRequest)$continuation.L$1;
                monitorV2sSearchQuery = (SearchSourceBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                searchMonitorV2sResponse = (SearchResponse)v0;
                AlertV2MoverKt.access$getLogger$p().debug("searching triggers for their expire durations");
                triggerToExpireDuration = new LinkedHashMap<K, V>();
                v1 = searchMonitorV2sResponse.getHits();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getHits(...)");
                $this$forEach$iv = (Iterable)v1;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    hit = (SearchHit)element$iv;
                    $i$a$-forEach-AlertV2Mover$searchForExpiredAlerts$2 = false;
                    v2 = hit.getSourceAsMap().get("monitor_v2");
                    Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    monitorV2Obj = (Map)v2;
                    v3 = monitorV2Obj.get("ppl_monitor");
                    Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    pplMonitorObj = (Map)v3;
                    v4 = pplMonitorObj.get("triggers");
                    Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
                    triggers = (List)v4;
                    for (Map trigger : triggers) {
                        v5 = trigger.get("id");
                        Intrinsics.checkNotNull(v5, (String)"null cannot be cast to non-null type kotlin.String");
                        triggerId = (String)v5;
                        v6 = trigger.get("expires_minutes");
                        Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type kotlin.Int");
                        expireDuration = ((Integer)v6).intValue();
                        AlertV2MoverKt.access$getLogger$p().debug("triggerId: " + triggerId);
                        AlertV2MoverKt.access$getLogger$p().debug("triggerExpires: " + expireDuration);
                        triggerToExpireDuration.put(triggerId, Boxing.boxLong((long)expireDuration));
                    }
                }
                AlertV2MoverKt.access$getLogger$p().debug("trigger to expire duration map: " + triggerToExpireDuration);
                AlertV2MoverKt.access$getLogger$p().debug("searching active alerts index for expired alerts");
                now = Instant.now().toEpochMilli();
                expiredAlertsBoolQuery = QueryBuilders.boolQuery();
                $this$forEach$iv = triggerToExpireDuration;
                $i$f$forEach = false;
                for (Map.Entry<K, V> element$iv : $this$forEach$iv.entrySet()) {
                    pplMonitorObj = element$iv;
                    $i$a$-forEach-AlertV2Mover$searchForExpiredAlerts$3 = false;
                    triggerId = (String)pplMonitorObj.getKey();
                    expireDuration = ((Number)pplMonitorObj.getValue()).longValue();
                    expireDurationMillis = expireDuration * (long)60 * (long)1000;
                    maxValidTime = now - expireDurationMillis;
                    expiredAlertsBoolQuery.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"trigger_v2_id", (String)triggerId)).must((QueryBuilder)QueryBuilders.rangeQuery((String)"triggered_time").lte((Object)Boxing.boxLong((long)maxValidTime))));
                }
                expiredAlertsBoolQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"trigger_v2_id", (Collection)CollectionsKt.toList((Iterable)triggerToExpireDuration.keySet()))));
                expiredAlertsBoolQuery.minimumShouldMatch(1);
                expiredAlertsSearchQuery = SearchSourceBuilder.searchSource().query((QueryBuilder)expiredAlertsBoolQuery).size(AlertingUtilsKt.getMAX_SEARCH_SIZE()).version(Boxing.boxBoolean((boolean)true));
                $i$a$-forEach-AlertV2Mover$searchForExpiredAlerts$2 = new String[]{".opensearch-alerting-v2-alerts"};
                expiredAlertsRequest = new SearchRequest($i$a$-forEach-AlertV2Mover$searchForExpiredAlerts$2).source(expiredAlertsSearchQuery);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)monitorV2sSearchQuery);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)monitorV2sRequest);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)searchMonitorV2sResponse);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)triggerToExpireDuration);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)expiredAlertsBoolQuery);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)expiredAlertsSearchQuery);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)expiredAlertsRequest);
                $continuation.J$0 = now;
                $continuation.label = 2;
                v7 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, searchForExpiredAlerts$lambda$5(org.opensearch.action.search.SearchRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((SearchRequest)expiredAlertsRequest), (Continuation)$continuation);
                if (v7 == var24_4) {
                    return var24_4;
                }
                ** GOTO lbl109
            }
            case 2: {
                now = $continuation.J$0;
                expiredAlertsRequest = (SearchRequest)$continuation.L$6;
                expiredAlertsSearchQuery = (SearchSourceBuilder)$continuation.L$5;
                expiredAlertsBoolQuery = (BoolQueryBuilder)$continuation.L$4;
                triggerToExpireDuration = (Map)$continuation.L$3;
                searchMonitorV2sResponse = (SearchResponse)$continuation.L$2;
                monitorV2sRequest = (SearchRequest)$continuation.L$1;
                monitorV2sSearchQuery = (SearchSourceBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl109:
                // 2 sources

                expiredAlertsResponse = (SearchResponse)v7;
                expiredAlertV2s = new ArrayList<E>();
                v8 = expiredAlertsResponse.getHits();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getHits(...)");
                $this$forEach$iv = (Iterable)v8;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    hit = (SearchHit)element$iv;
                    $i$a$-forEach-AlertV2Mover$searchForExpiredAlerts$4 = false;
                    v9 = hit.getSourceRef();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getSourceRef(...)");
                    v10 = this.alertV2ContentParser(v9);
                    v11 = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getId(...)");
                    expiredAlertV2s.add(AlertV2.Companion.parse(v10, v11, hit.getVersion()));
                }
                AlertV2MoverKt.access$getLogger$p().debug("expired alerts: " + expiredAlertV2s);
                return expiredAlertV2s;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object deleteExpiredAlerts(List<AlertV2> expiredAlerts, Continuation<? super BulkResponse> $completion) {
        if (!($completion instanceof deleteExpiredAlerts.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Mover this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertV2Mover.access$deleteExpiredAlerts(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                AlertV2MoverKt.access$getLogger$p().debug("beginning to hard delete expired alerts permanently");
                if (expiredAlerts.isEmpty()) {
                    return null;
                }
                $this$map$iv = expiredAlerts;
                $i$f$map = false;
                var6_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_15 = (AlertV2)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-AlertV2Mover$deleteExpiredAlerts$deleteRequests$1 = false;
                    var13_17.add(new DeleteRequest(".opensearch-alerting-v2-alerts", it.getId()).routing(it.getMonitorId()).version(it.getVersion()).versionType(VersionType.EXTERNAL_GTE));
                }
                deleteRequests = (List)destination$iv$iv;
                deleteRequest = new BulkRequest().add((Iterable)deleteRequests);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)expiredAlerts);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deleteRequests);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)deleteRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, deleteExpiredAlerts$lambda$8(org.opensearch.action.bulk.BulkRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((BulkRequest)deleteRequest), (Continuation)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl43
            }
            case 1: {
                deleteRequest = (BulkRequest)$continuation.L$2;
                deleteRequests = (List)$continuation.L$1;
                expiredAlerts = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl43:
                // 2 sources

                deleteResponse = (BulkResponse)v0;
                return deleteResponse;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object copyExpiredAlerts(List<AlertV2> expiredAlerts, Continuation<? super BulkResponse> $completion) {
        if (!($completion instanceof copyExpiredAlerts.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Mover this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertV2Mover.access$copyExpiredAlerts(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                AlertV2MoverKt.access$getLogger$p().debug("beginning to copy expired alerts to history write index");
                if (expiredAlerts.isEmpty()) {
                    return null;
                }
                $this$map$iv = expiredAlerts;
                $i$f$map = false;
                var6_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_15 = (AlertV2)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-AlertV2Mover$copyExpiredAlerts$indexRequests$1 = false;
                    v0 = new IndexRequest(".opensearch-alerting-v2-alert-history-write").routing(it.getMonitorId());
                    v1 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"jsonBuilder(...)");
                    v2 = ToXContent.EMPTY_PARAMS;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"EMPTY_PARAMS");
                    var13_17.add(v0.source(it.toXContent(v1, v2)).version(it.getVersion()).versionType(VersionType.EXTERNAL_GTE).id(it.getId()));
                }
                indexRequests = (List)destination$iv$iv;
                copyRequest = new BulkRequest().add((Iterable)indexRequests);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)expiredAlerts);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequests);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)copyRequest);
                $continuation.label = 1;
                v3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, copyExpiredAlerts$lambda$10(org.opensearch.action.bulk.BulkRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((BulkRequest)copyRequest), (Continuation)$continuation);
                if (v3 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl48
            }
            case 1: {
                copyRequest = (BulkRequest)$continuation.L$2;
                indexRequests = (List)$continuation.L$1;
                expiredAlerts = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl48:
                // 2 sources

                copyResponse = (BulkResponse)v3;
                return copyResponse;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Object deleteExpiredAlertsThatWereCopied(BulkResponse copyResponse, List<AlertV2> expiredAlerts, Continuation<? super BulkResponse> $completion) {
        if (!($completion instanceof deleteExpiredAlertsThatWereCopied.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Mover this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertV2Mover.access$deleteExpiredAlertsThatWereCopied(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                AlertV2MoverKt.access$getLogger$p().debug("beginning to delete expired alerts that were copied to history write index");
                if (copyResponse == null) {
                    return null;
                }
                $this$associateBy$iv = expiredAlerts;
                $i$f$associateBy = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                var8_14 = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    var13_23 = (AlertV2)element$iv$iv;
                    var16_27 = destination$iv$iv;
                    $i$a$-associateBy-AlertV2Mover$deleteExpiredAlertsThatWereCopied$alertsById$1 = false;
                    var16_27.put(it.getId(), element$iv$iv);
                }
                alertsById = destination$iv$iv;
                v0 = copyResponse.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getItems(...)");
                $this$filterNot$iv /* !! */  = v0;
                $i$f$filterNot = false;
                $this$associateByTo$iv$iv = $this$filterNot$iv /* !! */ ;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (BulkItemResponse element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = element$iv$iv;
                    $i$a$-filterNot-AlertV2Mover$deleteExpiredAlertsThatWereCopied$deleteRequests$1 = false;
                    if (it.isFailed()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv /* !! */  = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    element$iv$iv = (BulkItemResponse)item$iv$iv;
                    var16_27 = destination$iv$iv;
                    $i$a$-map-AlertV2Mover$deleteExpiredAlertsThatWereCopied$deleteRequests$2 = false;
                    v1 = new DeleteRequest(".opensearch-alerting-v2-alerts", it.getId());
                    v2 = alertsById.get(it.getId());
                    Intrinsics.checkNotNull(v2);
                    var16_27.add(v1.routing(((AlertV2)v2).getMonitorId()).version(it.getVersion()).versionType(VersionType.EXTERNAL_GTE));
                }
                deleteRequests = (List)destination$iv$iv;
                deleteRequest = new BulkRequest().add((Iterable)deleteRequests);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)copyResponse);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)expiredAlerts);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)alertsById);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)deleteRequests);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)deleteRequest);
                $continuation.label = 1;
                v3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, deleteExpiredAlertsThatWereCopied$lambda$14(org.opensearch.action.bulk.BulkRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((BulkRequest)deleteRequest), (Continuation)$continuation);
                if (v3 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl79
            }
            case 1: {
                deleteRequest = (BulkRequest)$continuation.L$4;
                deleteRequests = (List)$continuation.L$3;
                alertsById = (Map)$continuation.L$2;
                expiredAlerts = (List)$continuation.L$1;
                copyResponse = (BulkResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl79:
                // 2 sources

                deleteResponse = (BulkResponse)v3;
                return deleteResponse;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForFailures(BulkResponse bulkResponse) {
        block4: {
            BulkResponse bulkResponse2 = bulkResponse;
            if (bulkResponse2 == null) break block4;
            BulkResponse it = bulkResponse2;
            boolean bl = false;
            if (bulkResponse.hasFailures()) {
                BulkItemResponse.Failure failure;
                Object v2;
                block3: {
                    void $this$firstOrNull$iv;
                    void $this$filterTo$iv$iv;
                    BulkItemResponse[] bulkItemResponseArray = bulkResponse.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)bulkItemResponseArray, (String)"getItems(...)");
                    Object $this$filter$iv = bulkItemResponseArray;
                    boolean $i$f$filter = false;
                    Object[] objectArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        BulkItemResponse it2 = (BulkItemResponse)element$iv$iv;
                        boolean bl2 = false;
                        if (!it2.isFailed()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BulkItemResponse it3 = (BulkItemResponse)element$iv;
                        boolean bl3 = false;
                        if (!(it3.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                        v2 = element$iv;
                        break block3;
                    }
                    v2 = null;
                }
                BulkItemResponse bulkItemResponse = v2;
                Exception retryCause = bulkItemResponse != null && (failure = bulkItemResponse.getFailure()) != null ? failure.getCause() : null;
                AlertV2MoverKt.access$getLogger$p().error("Failed to move or delete alert v2s: " + bulkResponse.buildFailureMessage(), (Throwable)retryCause);
            }
        }
    }

    private final XContentParser alertV2ContentParser(BytesReference bytesReference) {
        XContentParser xContentParser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)bytesReference, (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNullExpressionValue((Object)xContentParser, (String)"createParser(...)");
        return xContentParser;
    }

    private final boolean areAlertV2IndicesPresent() {
        return this.alertV2IndexInitialized && this.alertV2HistoryIndexInitialized;
    }

    private static final void _init_$lambda$0(AlertV2Mover this$0, Boolean it) {
        this$0.alertV2HistoryEnabled = it;
    }

    private static final void onManager$lambda$1(AlertV2Mover this$0) {
        this$0.moveOrDeleteAlertV2s();
    }

    private static final Unit searchForExpiredAlerts$lambda$2(SearchRequest $monitorV2sRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.search($monitorV2sRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit searchForExpiredAlerts$lambda$5(SearchRequest $expiredAlertsRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.search($expiredAlertsRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit deleteExpiredAlerts$lambda$8(BulkRequest $deleteRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.bulk($deleteRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit copyExpiredAlerts$lambda$10(BulkRequest $copyRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.bulk($copyRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit deleteExpiredAlertsThatWereCopied$lambda$14(BulkRequest $deleteRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.bulk($deleteRequest, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$searchForExpiredAlerts(AlertV2Mover $this, Continuation $completion) {
        return $this.searchForExpiredAlerts((Continuation<? super List<AlertV2>>)$completion);
    }

    public static final /* synthetic */ Boolean access$getAlertV2HistoryEnabled$p(AlertV2Mover $this) {
        return $this.alertV2HistoryEnabled;
    }

    public static final /* synthetic */ Object access$deleteExpiredAlerts(AlertV2Mover $this, List expiredAlerts, Continuation $completion) {
        return $this.deleteExpiredAlerts(expiredAlerts, (Continuation<? super BulkResponse>)$completion);
    }

    public static final /* synthetic */ Object access$copyExpiredAlerts(AlertV2Mover $this, List expiredAlerts, Continuation $completion) {
        return $this.copyExpiredAlerts(expiredAlerts, (Continuation<? super BulkResponse>)$completion);
    }

    public static final /* synthetic */ Object access$deleteExpiredAlertsThatWereCopied(AlertV2Mover $this, BulkResponse copyResponse, List expiredAlerts, Continuation $completion) {
        return $this.deleteExpiredAlertsThatWereCopied(copyResponse, expiredAlerts, (Continuation<? super BulkResponse>)$completion);
    }

    public static final /* synthetic */ void access$checkForFailures(AlertV2Mover $this, BulkResponse bulkResponse) {
        $this.checkForFailures(bulkResponse);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/opensearch/alerting/alertsv2/AlertV2Mover$Companion;", "", "<init>", "()V", "moveAlertV2s", "", "monitorV2Id", "", "monitorV2", "Lorg/opensearch/alerting/modelv2/MonitorV2;", "monitorCtx", "Lorg/opensearch/alerting/MonitorRunnerExecutionContext;", "(Ljava/lang/String;Lorg/opensearch/alerting/modelv2/MonitorV2;Lorg/opensearch/alerting/MonitorRunnerExecutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nAlertV2Mover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertV2Mover.kt\norg/opensearch/alerting/alertsv2/AlertV2Mover$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,478:1\n1563#2:479\n1634#2,3:480\n1869#2,2:483\n1208#2,2:485\n1236#2,4:487\n1563#2:491\n1634#2,3:492\n295#2,2:498\n1563#2:500\n1634#2,3:501\n1563#2:507\n1634#2,3:508\n1563#2:511\n1634#2,3:512\n295#2,2:518\n1563#2:520\n1634#2,3:521\n3829#3:495\n4344#3,2:496\n4154#3:504\n4254#3,2:505\n3829#3:515\n4344#3,2:516\n*S KotlinDebug\n*F\n+ 1 AlertV2Mover.kt\norg/opensearch/alerting/alertsv2/AlertV2Mover$Companion\n*L\n368#1:479\n368#1:480,3\n383#1:483,2\n398#1:485,2\n398#1:487,4\n407#1:491\n407#1:492,3\n428#1:498,2\n431#1:500\n431#1:501,3\n444#1:507\n444#1:508,3\n453#1:511\n453#1:512,3\n467#1:518,2\n470#1:520\n470#1:521,3\n427#1:495\n427#1:496,2\n444#1:504\n444#1:505,2\n466#1:515\n466#1:516,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object moveAlertV2s(@NotNull String monitorV2Id, @Nullable MonitorV2 monitorV2, @NotNull MonitorRunnerExecutionContext monitorCtx, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof moveAlertV2s.1)) ** GOTO lbl-1000
            var34_5 = $completion;
            if ((var34_5.label & -2147483648) != 0) {
                var34_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    Object L$13;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.moveAlertV2s(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var39_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    AlertV2MoverKt.access$getLogger$p().debug("beginning to move alerts for postIndex or postDelete of monitor: " + monitorV2Id);
                    v0 = monitorCtx.getClient();
                    Intrinsics.checkNotNull((Object)v0);
                    client = v0;
                    boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor_v2_id", (String)monitorV2Id));
                    if (monitorV2 != null) {
                        var7_10 = monitorV2.getTriggers();
                        var30_11 = "trigger_v2_id";
                        var29_12 = boolQuery;
                        $i$f$map = false;
                        var9_15 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (String item$iv$iv : $this$mapTo$iv$iv) {
                            var14_25 = (TriggerV2)item$iv$iv;
                            var31_32 = destination$iv$iv;
                            $i$a$-map-AlertV2Mover$Companion$moveAlertV2s$2 = false;
                            var31_32.add(it.getId());
                        }
                        var31_32 = (List)destination$iv$iv;
                        var29_12.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)var30_11, (Collection)((Collection)var31_32)));
                    }
                    alertsSearchQuery = SearchSourceBuilder.searchSource().query((QueryBuilder)boolQuery).size(AlertingUtilsKt.getMAX_SEARCH_SIZE()).version(Boxing.boxBoolean((boolean)true));
                    $this$mapTo$iv$iv = new String[]{".opensearch-alerting-v2-alerts"};
                    activeAlertsRequest = new SearchRequest($this$mapTo$iv$iv).source(alertsSearchQuery);
                    $continuation.L$0 = monitorV2Id;
                    $continuation.L$1 = monitorV2;
                    $continuation.L$2 = monitorCtx;
                    $continuation.L$3 = client;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)boolQuery);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)alertsSearchQuery);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)activeAlertsRequest);
                    $continuation.label = 1;
                    v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, moveAlertV2s$lambda$1(org.opensearch.action.search.SearchRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((SearchRequest)activeAlertsRequest), (Continuation)$continuation);
                    if (v1 == var39_7) {
                        return var39_7;
                    }
                    ** GOTO lbl60
                }
                case 1: {
                    activeAlertsRequest = (SearchRequest)$continuation.L$6;
                    alertsSearchQuery = (SearchSourceBuilder)$continuation.L$5;
                    boolQuery = (BoolQueryBuilder)$continuation.L$4;
                    client = (Client)$continuation.L$3;
                    monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                    monitorV2 = (MonitorV2)$continuation.L$1;
                    monitorV2Id = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl60:
                    // 2 sources

                    searchAlertsResponse = (SearchResponse)v1;
                    v2 = searchAlertsResponse.getHits().getTotalHits();
                    v3 = v2 != null ? v2.value() == 0L : false;
                    if (v3) {
                        return Unit.INSTANCE;
                    }
                    activeAlerts = new ArrayList<E>();
                    v4 = searchAlertsResponse.getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getHits(...)");
                    $this$forEach$iv = (Iterable)v4;
                    $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        hit = (SearchHit)element$iv;
                        $i$a$-forEach-AlertV2Mover$Companion$moveAlertV2s$3 = false;
                        v5 = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"createParser(...)");
                        v6 = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getId(...)");
                        activeAlerts.add(AlertV2.Companion.parse(v5, v6, hit.getVersion()));
                    }
                    $this$associateBy$iv = activeAlerts;
                    $i$f$associateBy = false;
                    capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    hit = $this$associateBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    $i$f$associateByTo = false;
                    for (T element$iv$iv : $this$associateByTo$iv$iv) {
                        var20_47 = (AlertV2)element$iv$iv;
                        var29_12 = destination$iv$iv;
                        $i$a$-associateBy-AlertV2Mover$Companion$moveAlertV2s$alertsById$1 = false;
                        var29_12.put(it.getId(), element$iv$iv);
                    }
                    alertsById = destination$iv$iv;
                    v7 = monitorCtx.getClusterService();
                    Intrinsics.checkNotNull((Object)v7);
                    alertV2HistoryEnabled = (Boolean)v7.getClusterSettings().get(AlertingSettings.Companion.getALERT_V2_HISTORY_ENABLED());
                    copyResponse = null;
                    if (!alertV2HistoryEnabled.booleanValue()) ** GOTO lbl214
                    AlertV2MoverKt.access$getLogger$p().debug("alert v2 history enabled, copying alerts to history write index");
                    v8 = searchAlertsResponse.getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getHits(...)");
                    $this$map$iv /* !! */  = (Iterable)v8;
                    $i$f$map = false;
                    $i$f$associateByTo /* !! */  = $this$map$iv /* !! */ ;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv /* !! */ , (int)10));
                    $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        var22_56 = (SearchHit)item$iv$iv;
                        var29_12 = destination$iv$iv;
                        $i$a$-map-AlertV2Mover$Companion$moveAlertV2s$indexRequests$1 = 0;
                        xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        v9 = new IndexRequest(".opensearch-alerting-v2-alert-history-write").routing(monitorV2Id);
                        Intrinsics.checkNotNull((Object)xcp);
                        v10 = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getId(...)");
                        v11 = AlertV2.Companion.parse(xcp, v10, hit.getVersion());
                        v12 = XContentFactory.jsonBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"jsonBuilder(...)");
                        var29_12.add(v9.source(v11.toXContentWithUser(v12)).version(hit.getVersion()).versionType(VersionType.EXTERNAL_GTE).id(hit.getId()));
                    }
                    indexRequests = (List)destination$iv$iv;
                    copyRequest = new BulkRequest().add((Iterable)indexRequests);
                    $continuation.L$0 = monitorV2Id;
                    $continuation.L$1 = monitorV2;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)monitorCtx);
                    $continuation.L$3 = client;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)boolQuery);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)alertsSearchQuery);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)activeAlertsRequest);
                    $continuation.L$7 = searchAlertsResponse;
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)activeAlerts);
                    $continuation.L$9 = alertsById;
                    $continuation.L$10 = alertV2HistoryEnabled;
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)indexRequests);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)copyRequest);
                    $continuation.label = 2;
                    v13 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, moveAlertV2s$lambda$5(org.opensearch.action.bulk.BulkRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((BulkRequest)copyRequest), (Continuation)$continuation);
                    if (v13 == var39_7) {
                        return var39_7;
                    }
                    ** GOTO lbl160
                }
                case 2: {
                    copyRequest = (BulkRequest)$continuation.L$12;
                    indexRequests = (List)$continuation.L$11;
                    copyResponse = null;
                    alertV2HistoryEnabled = (Boolean)$continuation.L$10;
                    alertsById = (Map)$continuation.L$9;
                    activeAlerts = (List)$continuation.L$8;
                    searchAlertsResponse = (SearchResponse)$continuation.L$7;
                    activeAlertsRequest = (SearchRequest)$continuation.L$6;
                    alertsSearchQuery = (SearchSourceBuilder)$continuation.L$5;
                    boolQuery = (BoolQueryBuilder)$continuation.L$4;
                    client = (Client)$continuation.L$3;
                    monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                    monitorV2 = (MonitorV2)$continuation.L$1;
                    monitorV2Id = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v13 = $result;
lbl160:
                    // 2 sources

                    v14 = copyResponse = (BulkResponse)v13;
                    Intrinsics.checkNotNull((Object)v14);
                    if (!v14.hasFailures()) ** GOTO lbl214
                    v15 = copyResponse.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getItems(...)");
                    $this$filter$iv /* !! */  = v15;
                    $i$f$filter = false;
                    it = $this$filter$iv /* !! */ ;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (TriggerV2 element$iv$iv : $this$filterTo$iv$iv) {
                        it = (BulkItemResponse)element$iv$iv;
                        $i$a$-filter-AlertV2Mover$Companion$moveAlertV2s$retryCause$1 = false;
                        if (!it.isFailed()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv /* !! */  = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv /* !! */ ) {
                        it = (BulkItemResponse)element$iv;
                        $i$a$-firstOrNull-AlertV2Mover$Companion$moveAlertV2s$retryCause$2 = false;
                        if (!(it.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                        v16 = element$iv;
                        ** GOTO lbl187
                    }
                    v16 = null;
lbl187:
                    // 2 sources

                    $this$mapTo$iv$iv = v16;
                    retryCause = $this$mapTo$iv$iv != null && ($this$firstOrNull$iv /* !! */  = $this$mapTo$iv$iv.getFailure()) != null ? $this$firstOrNull$iv /* !! */ .getCause() : null;
                    v17 = monitorV2Id;
                    v18 = monitorV2;
                    if (v18 != null && (v18 = v18.getTriggers()) != null) {
                        $this$firstOrNull$iv /* !! */  = (Iterable)v18;
                        var31_32 = v17;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        $i$a$-firstOrNull-AlertV2Mover$Companion$moveAlertV2s$retryCause$2 = $this$mapTo$iv$iv.iterator();
                        while ($i$a$-firstOrNull-AlertV2Mover$Companion$moveAlertV2s$retryCause$2.hasNext()) {
                            item$iv$iv = $i$a$-firstOrNull-AlertV2Mover$Companion$moveAlertV2s$retryCause$2.next();
                            element$iv$iv = (TriggerV2)item$iv$iv;
                            var32_82 = destination$iv$iv;
                            $i$a$-map-AlertV2Mover$Companion$moveAlertV2s$5 = false;
                            var32_82.add(it.getId());
                        }
                        v19 = (List)destination$iv$iv;
                        v17 = var31_32;
                    } else {
                        v19 = null;
                    }
                    var35_84 = retryCause;
                    var36_85 = "Failed to copy alertV2s for [" + (String)v17 + ", " + v19 + "]: " + copyResponse.buildFailureMessage();
                    throw new RuntimeException(var36_85, var35_84);
lbl214:
                    // 2 sources

                    AlertV2MoverKt.access$getLogger$p().debug("deleting alerts related to monitor: " + monitorV2Id);
                    if (alertV2HistoryEnabled.booleanValue()) {
                        v20 = copyResponse;
                        Intrinsics.checkNotNull((Object)v20);
                        v21 = v20.getItems();
                        Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"getItems(...)");
                        $this$filterNot$iv /* !! */  = v21;
                        $i$f$filterNot = false;
                        $this$mapTo$iv$iv = $this$filterNot$iv /* !! */ ;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (BulkItemResponse element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = element$iv$iv;
                            $i$a$-filterNot-AlertV2Mover$Companion$moveAlertV2s$deleteRequests$1 = false;
                            if (it.isFailed()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterNot$iv /* !! */  = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterNotTo$iv$iv = $this$map$iv /* !! */ ;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv /* !! */ , (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            element$iv$iv = (BulkItemResponse)item$iv$iv;
                            var29_12 = destination$iv$iv;
                            $i$a$-map-AlertV2Mover$Companion$moveAlertV2s$deleteRequests$2 = false;
                            v22 = new DeleteRequest(".opensearch-alerting-v2-alerts", it.getId());
                            v23 = alertsById.get(it.getId());
                            Intrinsics.checkNotNull(v23);
                            var29_12.add(v22.routing(((AlertV2)v23).getMonitorId()).version(it.getVersion()).versionType(VersionType.EXTERNAL_GTE));
                        }
                        v24 = (List)destination$iv$iv;
                    } else {
                        v25 = searchAlertsResponse.getHits();
                        Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"getHits(...)");
                        $this$map$iv /* !! */  = (Object[])v25;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv /* !! */ ;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv /* !! */ , (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (SearchHit)item$iv$iv;
                            var29_12 = destination$iv$iv;
                            $i$a$-map-AlertV2Mover$Companion$moveAlertV2s$deleteRequests$3 = false;
                            v26 = new DeleteRequest(".opensearch-alerting-v2-alerts", hit.getId());
                            v27 = alertsById.get(hit.getId());
                            Intrinsics.checkNotNull(v27);
                            var29_12.add(v26.routing(((AlertV2)v27).getMonitorId()).version(hit.getVersion()).versionType(VersionType.EXTERNAL_GTE));
                        }
                        v24 = (List)destination$iv$iv;
                    }
                    deleteRequests = v24;
                    deleteRequest = new BulkRequest().add((Iterable)deleteRequests);
                    $continuation.L$0 = monitorV2Id;
                    $continuation.L$1 = monitorV2;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)monitorCtx);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)client);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)boolQuery);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)alertsSearchQuery);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)activeAlertsRequest);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)searchAlertsResponse);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)activeAlerts);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)alertsById);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)alertV2HistoryEnabled);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)copyResponse);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)deleteRequests);
                    $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)deleteRequest);
                    $continuation.label = 3;
                    v28 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, moveAlertV2s$lambda$12(org.opensearch.action.bulk.BulkRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((BulkRequest)deleteRequest), (Continuation)$continuation);
                    if (v28 == var39_7) {
                        return var39_7;
                    }
                    ** GOTO lbl308
                }
                case 3: {
                    deleteRequest = (BulkRequest)$continuation.L$13;
                    deleteRequests = (List)$continuation.L$12;
                    copyResponse = (BulkResponse)$continuation.L$11;
                    alertV2HistoryEnabled = (Boolean)$continuation.L$10;
                    alertsById = (Map)$continuation.L$9;
                    activeAlerts = (List)$continuation.L$8;
                    searchAlertsResponse = (SearchResponse)$continuation.L$7;
                    activeAlertsRequest = (SearchRequest)$continuation.L$6;
                    alertsSearchQuery = (SearchSourceBuilder)$continuation.L$5;
                    boolQuery = (BoolQueryBuilder)$continuation.L$4;
                    client = (Client)$continuation.L$3;
                    monitorCtx = (MonitorRunnerExecutionContext)$continuation.L$2;
                    monitorV2 = (MonitorV2)$continuation.L$1;
                    monitorV2Id = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v28 = $result;
lbl308:
                    // 2 sources

                    if (!(deleteResponse = (BulkResponse)v28).hasFailures()) ** GOTO lbl358
                    v29 = deleteResponse.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"getItems(...)");
                    $this$filter$iv /* !! */  = v29;
                    $i$f$filter = false;
                    item$iv$iv = $this$filter$iv /* !! */ ;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (TriggerV2 element$iv$iv : $this$filterTo$iv$iv) {
                        it = (BulkItemResponse)element$iv$iv;
                        $i$a$-filter-AlertV2Mover$Companion$moveAlertV2s$retryCause$3 = false;
                        if (!it.isFailed()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv /* !! */  = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv /* !! */ ) {
                        it = (BulkItemResponse)element$iv;
                        $i$a$-firstOrNull-AlertV2Mover$Companion$moveAlertV2s$retryCause$4 = false;
                        if (!(it.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                        v30 = element$iv;
                        ** GOTO lbl333
                    }
                    v30 = null;
lbl333:
                    // 2 sources

                    var18_42 = v30;
                    retryCause = var18_42 != null && ($this$firstOrNull$iv /* !! */  = var18_42.getFailure()) != null ? $this$firstOrNull$iv /* !! */ .getCause() : null;
                    v31 = monitorV2Id;
                    v32 = monitorV2;
                    if (v32 != null && (v32 = v32.getTriggers()) != null) {
                        $this$firstOrNull$iv /* !! */  = (Iterable)v32;
                        var31_32 = v31;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            element$iv$iv = (TriggerV2)item$iv$iv;
                            var32_83 = destination$iv$iv;
                            $i$a$-map-AlertV2Mover$Companion$moveAlertV2s$6 = false;
                            var32_83.add(it.getId());
                        }
                        v33 = (List)destination$iv$iv;
                        v31 = var31_32;
                    } else {
                        v33 = null;
                    }
                    var37_87 = retryCause;
                    var38_88 = "Failed to delete alertV2s for [" + (String)v31 + ", " + v33 + "]: " + deleteResponse.buildFailureMessage();
                    throw new RuntimeException(var38_88, var37_87);
lbl358:
                    // 1 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private static final Unit moveAlertV2s$lambda$1(SearchRequest $activeAlertsRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$suspendUntil.search($activeAlertsRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit moveAlertV2s$lambda$5(BulkRequest $copyRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$suspendUntil.bulk($copyRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit moveAlertV2s$lambda$12(BulkRequest $deleteRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$suspendUntil.bulk($deleteRequest, it);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

